/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.Pos;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.AbstractList;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.XMLEntity;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EntityUtil {
    private static final String HEXVAL = "0123456789abcdef";
    public static final String NON_FILE_CHARSSIMPLE = "[\\\\/\\:\\;\\*\\?\"<>\\|!&', \u001f\u0084\u0093\u0094\u0096\u2013\u201e\u201c\u03b1 ]";
    public static String CONTROLCHARACTER = "abtnvfr";
    public static final String emfTypes = " EOBJECT EBIG_DECIMAL EBOOLEAN EBYTE EBYTE_ARRAY ECHAR EDATE EDOUBLE EFLOAT EINT EINTEGER ELONG EMAP ERESOURCE ESHORT ESTRING ";
    private static final String primitiveTypes = " void String char Char boolean Boolean byte Byte Object java.util.Date ";
    private static final String numericTypes = " long Long short Short int Integer byte Byte float Float double Double ";
    private static final String javaLang = "java.lang.";
    public static final String javaKeyWords = " abstract assert boolean break byte case catch char class const continue default do double else enum extends final finally float for if goto implements import instanceof int interface long native new package private protected public return short static strictfp super switch synchronized this throw throws transient try void volatile while ";
    private static final SimpleKeyValueList<String, String> transferMap = new SimpleKeyValueList().withKeyValueString("long:Long,int:Integer,char:Character,boolean:Boolean,byte:Byte,float:Float,double:Double", String.class);
    public static final String HTMLTOKEN = "Aacute:193,aacute:225,Acirc:194,acirc:226,acute:180,AElig:198,aelig:230,Agrave:192,agrave:224,alefsym:8501,Alpha:913,alpha:945,amp:38,and:8743,ang:8736,Aring:197,aring:229,asymp:8776,Atilde:195,atilde:227,Auml:196,auml:228,bdquo:8222,Beta:914,beta:946,brvbar:166,bull:8226,cap:8745,Ccedil:199,ccedil:231,cedil:184,cent:162,Chi:935,chi:967,circ:710,clubs:9827,cong:8773,copy:169,crarr:8629,cup:8746,curren:164,dagger:8224,Dagger:8225,darr:8595,dArr:8659,deg:176,Delta:916,delta:948,diams:9830,divide:247,Eacute:201,eacute:233,Ecirc:202,ecirc:234,Egrave:200,egrave:232,empty:8709,emsp:8195,ensp:8194,Epsilon:917,epsilon:949,equiv:8801,Eta:919,eta:951,ETH:208,eth:240,Euml:203,euml:235,euro:8364,exist:8707,fnof:402,forall:8704,frac12:189,frac14:188,frac34:190,frasl:8260,Gamma:915,gamma:947,ge:8805,harr:8596,hArr:8660,hearts:9829,hellip:8230,Iacute:205,iacute:237,Icirc:206,icirc:238,iexcl:161,Igrave:204,igrave:236,image:8465,infin:8734,int:8747,Iota:921,iota:953,iquest:191,isin:8712,Iuml:207,iuml:239,Kappa:922,kappa:954,Lambda:923,lambda:955,lang:9001,laquo:171,larr:8592,lArr:8656,lceil:8968,ldquo:8220,le:8804,lfloor:8970,lowast:8727,loz:9674,lrm:8206,lsaquo:8249,lsquo:8216,macr:175,mdash:8212,micro:181,middot:183,minus:8722,Mu:924,mu:956,nabla:8711,nbsp:160,ndash:8211,ne:8800,ni:8715,not:172,notin:8713,nsub:8836,Ntilde:209,ntilde:241,Nu:925,nu:957,Oacute:211,oacute:243,Ocirc:212,ocirc:244,OElig:338,oelig:339,Ograve:210,ograve:242,oline:8254,Omega:937,omega:969,Omicron:927,omicron:959,oplus:8853,or:8744,ordf:170,ordm:186,Oslash:216,oslash:248,Otilde:213,otilde:245,otimes:8855,Ouml:214,ouml:246,para:182,part:8706,permil:8240,perp:8869,Phi:934,phi:966,Pi:928,pi:960,piv:982,plusmn:177,pound:163,prime:8242,Prime:8243,prod:8719,prop:8733,Psi:936,psi:968,radic:8730,rang:9002,raquo:187,rarr:8594,rArr:8658,rceil:8969,rdquo:8221,real:8476,reg:174,rfloor:8971,Rho:929,rho:961,rlm:8207,rsaquo:8250,rsquo:8217,sbquo:8218,Scaron:352,scaron:353,sdot:8901,sect:167,shy:173,Sigma:931,sigma:963,sigmaf:962,sim:8764,spades:9824,sub:8834,sube:8838,sum:8721,sup1:185,sup2:178,sup3:179,sup:8835,supe:8839,szlig:223,Tau:932,tau:964,there4:8756,Theta:920,theta:952,thetasym:977,thinsp:8201,THORN:222,thorn:254,tilde:732,times:215,trade:8482,Uacute:218,uacute:250,uarr:8593,uArr:8657,Ucirc:219,ucirc:251,Ugrave:217,ugrave:249,uml:168,upsih:978,Upsilon:933,upsilon:965,Uuml:220,uuml:252,weierp:8472,Xi:926,xi:958,Yacute:221,yacute:253,yen:165,yuml:255,Yuml:376,Zeta:918,zeta:950,zwj:8205,zwnj:8204";
    private SimpleKeyValueList<String, Integer> entities = ((SimpleKeyValueList)new SimpleKeyValueList().withKeyValueString("Aacute:193,aacute:225,Acirc:194,acirc:226,acute:180,AElig:198,aelig:230,Agrave:192,agrave:224,alefsym:8501,Alpha:913,alpha:945,amp:38,and:8743,ang:8736,Aring:197,aring:229,asymp:8776,Atilde:195,atilde:227,Auml:196,auml:228,bdquo:8222,Beta:914,beta:946,brvbar:166,bull:8226,cap:8745,Ccedil:199,ccedil:231,cedil:184,cent:162,Chi:935,chi:967,circ:710,clubs:9827,cong:8773,copy:169,crarr:8629,cup:8746,curren:164,dagger:8224,Dagger:8225,darr:8595,dArr:8659,deg:176,Delta:916,delta:948,diams:9830,divide:247,Eacute:201,eacute:233,Ecirc:202,ecirc:234,Egrave:200,egrave:232,empty:8709,emsp:8195,ensp:8194,Epsilon:917,epsilon:949,equiv:8801,Eta:919,eta:951,ETH:208,eth:240,Euml:203,euml:235,euro:8364,exist:8707,fnof:402,forall:8704,frac12:189,frac14:188,frac34:190,frasl:8260,Gamma:915,gamma:947,ge:8805,harr:8596,hArr:8660,hearts:9829,hellip:8230,Iacute:205,iacute:237,Icirc:206,icirc:238,iexcl:161,Igrave:204,igrave:236,image:8465,infin:8734,int:8747,Iota:921,iota:953,iquest:191,isin:8712,Iuml:207,iuml:239,Kappa:922,kappa:954,Lambda:923,lambda:955,lang:9001,laquo:171,larr:8592,lArr:8656,lceil:8968,ldquo:8220,le:8804,lfloor:8970,lowast:8727,loz:9674,lrm:8206,lsaquo:8249,lsquo:8216,macr:175,mdash:8212,micro:181,middot:183,minus:8722,Mu:924,mu:956,nabla:8711,nbsp:160,ndash:8211,ne:8800,ni:8715,not:172,notin:8713,nsub:8836,Ntilde:209,ntilde:241,Nu:925,nu:957,Oacute:211,oacute:243,Ocirc:212,ocirc:244,OElig:338,oelig:339,Ograve:210,ograve:242,oline:8254,Omega:937,omega:969,Omicron:927,omicron:959,oplus:8853,or:8744,ordf:170,ordm:186,Oslash:216,oslash:248,Otilde:213,otilde:245,otimes:8855,Ouml:214,ouml:246,para:182,part:8706,permil:8240,perp:8869,Phi:934,phi:966,Pi:928,pi:960,piv:982,plusmn:177,pound:163,prime:8242,Prime:8243,prod:8719,prop:8733,Psi:936,psi:968,radic:8730,rang:9002,raquo:187,rarr:8594,rArr:8658,rceil:8969,rdquo:8221,real:8476,reg:174,rfloor:8971,Rho:929,rho:961,rlm:8207,rsaquo:8250,rsquo:8217,sbquo:8218,Scaron:352,scaron:353,sdot:8901,sect:167,shy:173,Sigma:931,sigma:963,sigmaf:962,sim:8764,spades:9824,sub:8834,sube:8838,sum:8721,sup1:185,sup2:178,sup3:179,sup:8835,supe:8839,szlig:223,Tau:932,tau:964,there4:8756,Theta:920,theta:952,thetasym:977,thinsp:8201,THORN:222,thorn:254,tilde:732,times:215,trade:8482,Uacute:218,uacute:250,uarr:8593,uArr:8657,Ucirc:219,ucirc:251,Ugrave:217,ugrave:249,uml:168,upsih:978,Upsilon:933,upsilon:965,Uuml:220,uuml:252,weierp:8472,Xi:926,xi:958,Yacute:221,yacute:253,yen:165,yuml:255,Yuml:376,Zeta:918,zeta:950,zwj:8205,zwnj:8204", Integer.class).with("lt", 60)).with((String)"gt", 62);

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static SimpleList<Pos> getExcelRange(String tag) {
        SimpleList<Pos> range = new SimpleList<Pos>();
        if (tag == null) {
            return range;
        }
        int pos = tag.toUpperCase().indexOf(":");
        if (pos > 0) {
            Pos start = Pos.valueOf(tag.substring(0, pos));
            Pos end = Pos.valueOf(tag.substring(pos + 1));
            Pos step = Pos.create(start.x, start.y);
            while (step.y <= end.y) {
                while (step.x <= end.x) {
                    range.add(step);
                    step = Pos.create(step.x + 1, step.y);
                }
                step = Pos.create(start.x, step.y + 1);
            }
        } else {
            range.add(Pos.valueOf(tag));
        }
        return range;
    }

    public static String valueToString(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null pointer");
        }
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String unQuoteControlCharacter(CharSequence value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(value.length());
        int i = 0;
        int len = value.length();
        if (value.charAt(0) == '\"') {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\\') {
                char no;
                int pos;
                if (i + 1 == len) {
                    sb.append('\\');
                    break;
                }
                if ((pos = CONTROLCHARACTER.indexOf(c = value.charAt(++i))) >= 0) {
                    sb.append(pos + 7);
                } else if (c == '\"') {
                    sb.append('\"');
                } else if (c == '9') {
                    sb.append(57);
                } else if (c == 'u') {
                    no = EntityUtil.fromHex(value.charAt(++i), value.charAt(++i), value.charAt(++i), value.charAt(++i));
                    sb.append(no);
                } else if (c == 'o') {
                    no = EntityUtil.fromOctal(value.charAt(++i), value.charAt(++i), value.charAt(++i));
                    sb.append(no);
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String unQuote(CharSequence value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        sb = new StringBuilder(value.length());
        i = 0;
        len = value.length();
        if (value.charAt(0) == '\"') {
            ++i;
            --len;
        }
        while (i < len) {
            c = value.charAt(i);
            if (c != '\\') ** GOTO lbl24
            if (i + 1 == len) {
                sb.append('\\');
                break;
            }
            if ((c = value.charAt(++i)) == 'u') {
                no = EntityUtil.fromHex(new char[]{value.charAt(++i), value.charAt(++i), value.charAt(++i), value.charAt(++i)});
                sb.append(no);
            } else {
                if (c != '\"' && c != '\\') {
                    sb.append('\\');
                }
lbl24:
                // 4 sources

                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String basicUnQuote(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (i + 1 == value.length()) {
                    sb.append('\\');
                    break;
                }
                if ((c = value.charAt(++i)) == 'u') {
                    char no = EntityUtil.fromHex(value.charAt(++i), value.charAt(++i), value.charAt(++i), value.charAt(++i));
                    sb.append(no);
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char fromHex(char ... values) {
        if (values == null) {
            return '\u0000';
        }
        return (char)((HEXVAL.indexOf(values[0]) << 24) + (HEXVAL.indexOf(values[1]) << 16) + (HEXVAL.indexOf(values[2]) << 8) + HEXVAL.indexOf(values[3]));
    }

    private static char fromOctal(char ... values) {
        if (values == null) {
            return '\u0000';
        }
        int result = 0;
        int mult = 1;
        for (int i = values.length - 1; i >= 0; --i) {
            result += values[i] * mult;
            mult *= 8;
        }
        return (char)result;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                String hhhh = "000" + Integer.toHexString(c);
                sb.append("\\u" + hhhh.substring(hhhh.length() - 4));
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String valueToString(Object value, boolean simpleText, BaseItem reference, Converter converter) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return EntityUtil.valueToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof BaseItem) {
            return ((BaseItem)value).toString(converter);
        }
        if (value instanceof Map) {
            BaseItem item = reference.getNewList(true).with((Map)value);
            return item.toString(converter);
        }
        if (value instanceof Collection) {
            BaseItem item = reference.getNewList(true);
            if (item instanceof SimpleKeyValueList) {
                return ((SimpleKeyValueList)item).withList((Collection)value).toString(converter);
            }
            return item.toString(converter);
        }
        if (value.getClass().getName().equals("[B")) {
            return EntityUtil.quote(new String((byte[])value));
        }
        if (value.getClass().isArray()) {
            Object[] items = (Object[])value;
            BaseItem item = reference.getNewList(false);
            for (Object entity : items) {
                item.with(entity);
            }
            return item.toString(converter);
        }
        if (simpleText) {
            return value.toString();
        }
        return EntityUtil.quote(value.toString());
    }

    public static Object wrap(Object object, BaseItem reference) {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof AbstractArray || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String) {
                return object;
            }
            if (object instanceof Collection) {
                return ((AbstractList)reference.getNewList(false)).withList((Collection)object);
            }
            if (object.getClass().isArray()) {
                return ((AbstractList)reference.getNewList(false)).withList((Collection)object);
            }
            if (object instanceof Map) {
                return ((SimpleKeyValueList)reference.getNewList(false)).withMap((Map)object);
            }
            if (object.getClass().getName().startsWith("java.") || object.getClass().getName().startsWith("javax.")) {
                return object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String repeat(char ch, int repeat) {
        if (repeat < 0) {
            return "";
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static boolean stringEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static String strZero(int value, int length) {
        return EntityUtil.strZero(String.valueOf(value), length, -1);
    }

    public static String strZero(long value, int length) {
        return EntityUtil.strZero(String.valueOf(value), length, -1);
    }

    public static String strZero(long value, int length, int max) {
        return EntityUtil.strZero(String.valueOf(value), length, max);
    }

    public static String strZero(int value, int length, int max) {
        return EntityUtil.strZero(String.valueOf(value), length, max);
    }

    public static String strZero(String value, int length, int max) {
        if (max > 0 && max < length) {
            length = max;
        }
        StringBuilder sb = new StringBuilder();
        if (length > value.length()) {
            sb.ensureCapacity(length);
            for (max = length - value.length(); max > 0; --max) {
                sb.append("0");
            }
        }
        sb.append(value);
        return sb.toString();
    }

    public static String getValidChars(String source, int maxLen) {
        int i = source.length() - 1;
        StringBuilder sb = new StringBuilder();
        if (i > 0) {
            while (' ' == source.charAt(i) || '.' == source.charAt(i)) {
                --i;
            }
        }
        if (maxLen > 0 && ++i > maxLen) {
            int lastComma;
            String search = source.substring(0, maxLen);
            int lastSpace = search.lastIndexOf(" ");
            if (lastSpace > (lastComma = search.lastIndexOf(","))) {
                i = lastSpace;
            } else if (lastComma > lastSpace) {
                i = lastComma;
            }
        }
        for (int k = 0; k < i; ++k) {
            char charAt = source.charAt(k);
            if (NON_FILE_CHARSSIMPLE.indexOf(charAt) >= 0 || charAt >= '\ud6d8') continue;
            sb.append(charAt);
        }
        return sb.toString();
    }

    public static boolean compareEntity(Entity entityA, Entity entityB) {
        return EntityUtil.compareEntity(entityA, entityB, null);
    }

    public static boolean compareEntity(Entity entityA, Entity entityB, Entity sameObject) {
        boolean isSamesize;
        if (entityB == null) {
            return entityA == null;
        }
        for (int i = entityA.size() - 1; i >= 0; --i) {
            Object oldValue;
            String key = entityA.getKeyByIndex(i);
            Object valueA = entityA.getValue(key);
            Object valueB = entityB.getValue(key);
            if (valueA == null) {
                if (valueB != null) continue;
                oldValue = entityA.getValue(key);
                if (sameObject != null) {
                    sameObject.with(key, oldValue);
                }
                entityA.without(key);
                entityB.without(key);
                continue;
            }
            oldValue = EntityUtil.compareValue(valueA, valueB);
            if (oldValue == null) continue;
            if (sameObject != null) {
                sameObject.with(key, oldValue);
            }
            entityA.without(key);
            entityB.without(key);
        }
        boolean bl = isSamesize = entityA.size() < 1 && entityB.size() < 1;
        if (entityA instanceof XMLEntity && entityB instanceof XMLEntity) {
            XMLEntity xmlA = (XMLEntity)entityA;
            XMLEntity xmlB = (XMLEntity)entityB;
            EntityUtil.compareEntity(xmlA.getChildren(), xmlB.getChildren());
            return isSamesize && xmlA.getTag().equals(xmlB.getTag());
        }
        return isSamesize;
    }

    public static boolean compareEntity(List<?> jsonA, List<?> jsonB) {
        return EntityUtil.compareEntity(jsonA, jsonB, null);
    }

    public static boolean compareEntity(List<?> jsonA, List<?> jsonB, BaseItem sameList) {
        if (jsonB == null) {
            return jsonA == null;
        }
        for (int i = jsonA.size() - 1; i >= 0; --i) {
            Object valueB;
            Object oldValue;
            Object valueA = jsonA.get(i);
            if (jsonB.size() < i || (oldValue = EntityUtil.compareValue(valueA, valueB = jsonB.get(i))) == null) continue;
            jsonA.remove(i);
            if (sameList != null) {
                sameList.with(oldValue);
            }
            jsonB.remove(i);
        }
        return jsonA.size() < 1 && jsonB.size() < 1;
    }

    static Object compareValue(Object valueA, Object valueB) {
        if (valueA instanceof Entity && valueB instanceof Entity) {
            Entity entityA = (Entity)valueA;
            Entity newKeyValue = (Entity)entityA.getNewList(true);
            if (EntityUtil.compareEntity(entityA, (Entity)valueB, newKeyValue)) {
                return newKeyValue;
            }
            return null;
        }
        if (valueA instanceof BaseItem && valueB instanceof List) {
            BaseItem sameList = ((BaseItem)valueA).getNewList(false);
            if (EntityUtil.compareEntity((List)valueA, (List)valueB, sameList)) {
                return sameList;
            }
            return null;
        }
        if (valueA.equals(valueB)) {
            return valueA;
        }
        return null;
    }

    public static boolean isEMFType(String tag) {
        return emfTypes.indexOf(" " + tag.toUpperCase() + " ") >= 0;
    }

    public static boolean isPrimitiveType(String type) {
        if (type == null) {
            return false;
        }
        if (type.endsWith("...")) {
            type = type.substring(0, type.length() - 3);
        }
        type = type.startsWith(javaLang) ? " " + type.substring(javaLang.length()) + " " : " " + type + " ";
        return numericTypes.indexOf(type) >= 0 || primitiveTypes.indexOf(type) >= 0;
    }

    public static boolean isNumericType(String type) {
        if (type == null) {
            return false;
        }
        if (type.startsWith(javaLang)) {
            type = type.substring(javaLang.length() + 1);
        }
        return numericTypes.indexOf(" " + type + " ") >= 0;
    }

    public static String convertPrimitiveToObjectType(String type) {
        int pos = transferMap.indexOf(type);
        if (pos < 0) {
            return type;
        }
        return transferMap.getValueByIndex(pos);
    }

    public static String toValidJavaId(String tag) {
        if (javaKeyWords.indexOf(" " + tag + " ") >= 0) {
            tag = "_" + tag;
        }
        return tag;
    }

    public static String getId(String name) {
        if (name.lastIndexOf("/") >= 0) {
            return name.substring(name.lastIndexOf("/") + 1);
        }
        if (name.indexOf("#") >= 0) {
            return name.substring(name.indexOf("#") + 2);
        }
        return name;
    }

    public static String shortClassName(String name) {
        if (name == null) {
            return "";
        }
        int pos = name.lastIndexOf(46);
        if ((pos = (name = name.substring(pos + 1)).lastIndexOf(36)) >= 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    public static String upFirstChar(String name) {
        if (name == null || name.length() < 1) {
            return name;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public String encode(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entity = this.entities.getKey(Integer.valueOf(ch));
            if (entity == null) {
                if (ch > '\u0080') {
                    buf.append("&#" + ch + ";");
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append("&" + entity + ";");
        }
        return buf.toString();
    }

    public String decode(String str) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                int semi = str.indexOf(59, i + 1);
                if (semi == -1 || semi - i > 7) {
                    buf.append(ch);
                    continue;
                }
                String entity = str.substring(i + 1, semi);
                if (entity.charAt(1) == ' ') {
                    buf.append(ch);
                    continue;
                }
                Integer iso = entity.charAt(0) == '#' ? (entity.charAt(1) == 'x' ? Integer.valueOf(entity.substring(2, entity.length()), 16) : Integer.valueOf(entity.substring(1, entity.length()))) : this.entities.get(entity);
                if (iso == null) {
                    buf.append(entity);
                } else {
                    buf.append((char)iso.intValue());
                }
                i = semi;
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static void writeByteHeader(ByteBuffer buffer, byte typ, int valueLength) {
        if (valueLength > 0) {
            if (typ != 0) {
                buffer.put(typ);
                if (EntityUtil.getSubGroup(typ) != 5) {
                    int lenSize = EntityUtil.getTypLen(typ, valueLength, true);
                    if (lenSize == 1) {
                        if (typ == 65 || EntityUtil.getSubGroup(typ) == 1) {
                            buffer.put((byte)(valueLength + 32));
                        } else {
                            buffer.put((byte)valueLength);
                        }
                    } else if (lenSize == 2) {
                        buffer.put((short)valueLength);
                    } else if (lenSize == 4) {
                        buffer.put(valueLength);
                    }
                }
            }
        } else if (buffer != null) {
            buffer.put((byte)34);
        }
    }

    public static byte[] clone(byte[] entity) {
        byte[] result = new byte[entity.length];
        for (int i = 0; i < entity.length; ++i) {
            result[i] = entity[i];
        }
        return result;
    }

    public static byte getTyp(byte group, byte subGroup) {
        return (byte)(group + subGroup);
    }

    public static byte getTyp(byte typ, int len, boolean isLast) {
        if (EntityUtil.isGroup(typ)) {
            if (isLast) {
                return EntityUtil.getTyp(typ, (byte)5);
            }
            if (len > Short.MAX_VALUE) {
                return EntityUtil.getTyp(typ, (byte)4);
            }
            if (len > 250) {
                return EntityUtil.getTyp(typ, (byte)3);
            }
            if (len > 32) {
                return EntityUtil.getTyp(typ, (byte)2);
            }
            return EntityUtil.getTyp(typ, (byte)1);
        }
        return typ;
    }

    public static int getTypLen(byte typ, int len, boolean isLast) {
        if (EntityUtil.isGroup(typ)) {
            int ref = typ % 16 - 10;
            if (ref == 0) {
                typ = EntityUtil.getTyp(typ, len, isLast);
                ref = typ % 16 - 10;
            }
            if (ref == 2 || ref == 1) {
                return 1;
            }
            if (ref == 3) {
                return 2;
            }
            if (ref == 4) {
                return 4;
            }
            return 0;
        }
        if (typ == 65) {
            return 1;
        }
        if (typ == 66) {
            return 4;
        }
        return 0;
    }

    public static ByteBuffer getBuffer(int len) {
        if (len < 1) {
            return null;
        }
        ByteBuffer message = ByteBuffer.allocate(len);
        return message;
    }

    public static boolean isPrimitive(byte typ) {
        return typ >= 48 && typ <= 54 || typ <= 64;
    }

    public static boolean isGroup(byte typ) {
        return (typ & 8) == 8;
    }

    public static String getStringTyp(byte typ) {
        if (typ == 34) {
            return "DATATYPE_NULL";
        }
        if (typ == 0) {
            return "DATATYPE_FIXED";
        }
        if (typ == 48) {
            return "DATATYPE_SHORT";
        }
        if (typ == 49) {
            return "DATATYPE_INTEGER";
        }
        if (typ == 50) {
            return "DATATYPE_LONG";
        }
        if (typ == 51) {
            return "DATATYPE_FLOAT";
        }
        if (typ == 52) {
            return "DATATYPE_DOUBLE";
        }
        if (typ == 53) {
            return "DATATYPE_DATE";
        }
        if (typ == 35) {
            return "DATATYPE_CLAZZID";
        }
        if (typ == 67) {
            return "DATATYPE_CLAZZPACKAGE";
        }
        if (typ == 65) {
            return "DATATYPE_CLAZZNAME";
        }
        if (typ == 66) {
            return "DATATYPE_CLAZZNAMELONG";
        }
        if (typ == 68) {
            return "DATATYPE_CLAZZTYP";
        }
        if (typ == 69) {
            return "DATATYPE_CLAZZTYPLONG";
        }
        if (typ == 54) {
            return "DATATYPE_BYTE";
        }
        if (typ == 55) {
            return "DATATYPE_UNSIGNEDBYTE";
        }
        if (typ == 64) {
            return "DATATYPE_CHAR";
        }
        if (typ == 70) {
            return "DATATYPE_ASSOC";
        }
        if (typ == 71) {
            return "DATATYPE_ASSOCLONG";
        }
        if (typ == 80) {
            return "DATATYPE_CLAZZSTREAM";
        }
        if (EntityUtil.isGroup(typ)) {
            byte group = EntityUtil.getGroup(typ);
            byte subgroup = EntityUtil.getSubGroup(typ);
            String result = group == 58 ? "DATATYPE_BYTEARRAY" : (group == 74 ? "DATATYPE_STRING" : (group == 90 ? "DATATYPE_LIST" : (group == 106 ? "DATATYPE_MAP" : (group == 122 ? "DATATYPE_CHECK" : ""))));
            if (subgroup == 1) {
                result = result + "LITTLE";
            } else if (subgroup == 2) {
                result = result + "SHORT";
            } else if (subgroup == 3) {
                result = result + "MID";
            } else if (subgroup == 4) {
                result = result + "BIG";
            } else if (subgroup == 5) {
                result = result + "LAST";
            }
            return result;
        }
        return null;
    }

    public static byte getGroup(byte typ) {
        return (byte)(typ / 16 * 16 + 10);
    }

    public static byte getSubGroup(byte typ) {
        return (byte)(typ % 16 - 10);
    }
}

