/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;
import java.beans.PropertyChangeEvent;

public class Equals
implements UpdateListener,
SendableEntityCreator {
    public static final String STRINGVALUE = "stringvalue";
    public static final String POSITION = "position";
    public static final String BYTEVALUE = "bytevalue";
    private String strValue;
    private int position = -1;
    private Byte bytevalue;

    @Override
    public boolean update(Object evt) {
        if (evt == null) {
            return this.strValue == null;
        }
        PropertyChangeEvent event = (PropertyChangeEvent)evt;
        if (event.getSource() instanceof BufferedBuffer) {
            BufferedBuffer buffer = (BufferedBuffer)event.getSource();
            int pos = this.position < 0 ? buffer.position() : this.position;
            return buffer.byteAt(pos) == this.bytevalue.byteValue();
        }
        return event.getPropertyName().equals(this.strValue);
    }

    public Equals withPosition(int value) {
        this.position = value;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public Equals withValue(Byte value) {
        this.bytevalue = value;
        return this;
    }

    public Byte getBytevalue() {
        return this.bytevalue;
    }

    public Equals withValue(String value) {
        this.strValue = value;
        return this;
    }

    public String getStringvalue() {
        return this.strValue;
    }

    public String toString() {
        if (this.strValue != null) {
            return "==" + this.strValue + " ";
        }
        return "==" + this.bytevalue + " ";
    }

    @Override
    public String[] getProperties() {
        return new String[]{STRINGVALUE, POSITION, BYTEVALUE};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new Equals();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (STRINGVALUE.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getStringvalue();
        }
        if (POSITION.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getPosition();
        }
        if (BYTEVALUE.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getBytevalue();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (STRINGVALUE.equalsIgnoreCase(attribute)) {
            ((Equals)entity).withValue(String.valueOf(value));
            return true;
        }
        if (POSITION.equalsIgnoreCase(attribute)) {
            ((Equals)entity).withPosition(Integer.parseInt("" + value));
            return true;
        }
        if (BYTEVALUE.equalsIgnoreCase(attribute)) {
            ((Equals)entity).withValue((Byte)value);
            return true;
        }
        return false;
    }
}

