/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.SimpleList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SimpleIterator<E>
implements ListIterator<E> {
    private int cursor;
    private int lastRet;
    private AbstractArray<E> list;
    private int checkPointer = -1;

    public SimpleIterator(AbstractArray<E> list) {
        this.with(list, 0);
    }

    public SimpleIterator(Object collection) {
        if (collection instanceof AbstractArray) {
            this.list = (AbstractArray)collection;
        } else if (collection instanceof List) {
            this.list = new SimpleList<E>();
            this.list.withList((List)collection);
        }
        this.cursor = 0;
        this.lastRet = -1;
    }

    public SimpleIterator(AbstractArray<E> list, int index) {
        this.with(list, index);
    }

    public SimpleIterator<E> with(AbstractArray<E> newList, int cursor) {
        this.cursor = cursor;
        this.lastRet = -1;
        this.list = newList;
        return this;
    }

    @Override
    public boolean hasPrevious() {
        return this.cursor != 0;
    }

    @Override
    public int nextIndex() {
        return this.cursor;
    }

    @Override
    public int previousIndex() {
        return this.cursor - 1;
    }

    @Override
    public E previous() {
        int i = this.cursor - 1;
        if (i < 0) {
            throw new NoSuchElementException();
        }
        this.cursor = i;
        this.lastRet = i;
        return this.list.get(this.lastRet);
    }

    @Override
    public void set(E e) {
        if (this.lastRet < 0) {
            throw new IllegalStateException();
        }
        try {
            this.list.setValue(this.lastRet, e, 0);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void add(E e) {
        try {
            int size = this.list.size();
            int pos = this.list.hasKey(e);
            if (pos >= 0) {
                this.list.grow(size + 1);
                this.list.addKey(this.cursor, e, size + 1);
                ++this.cursor;
                this.lastRet = -1;
                if (this.checkPointer >= 0) {
                    this.checkPointer = this.list.size();
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.list.size;
    }

    @Override
    public E next() {
        if (this.cursor >= this.list.size()) {
            throw new ConcurrentModificationException();
        }
        if (this.checkPointer >= 0 && this.checkPointer != this.list.size()) {
            throw new ConcurrentModificationException();
        }
        this.lastRet = this.cursor++;
        return this.list.get(this.lastRet);
    }

    @Override
    public void remove() {
        if (this.lastRet < 0) {
            throw new IllegalStateException();
        }
        try {
            this.list.removeByIndex(this.lastRet, 0, this.list.index);
            this.cursor = this.lastRet;
            this.lastRet = -1;
            if (this.checkPointer >= 0) {
                this.checkPointer = this.list.size();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConcurrentModificationException();
        }
    }

    public SimpleIterator<E> with(AbstractArray<?> newList) {
        this.cursor = 0;
        this.lastRet = -1;
        this.list = newList;
        return this;
    }

    public SimpleIterator<E> withCheckPointer(boolean checkPointer) {
        this.checkPointer = checkPointer ? this.list.size() : -1;
        return this;
    }
}

