/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.ByteBuffer;

public class ByteUtil {
    public static void writeByteHeader(ByteBuffer buffer, byte typ, int valueLength) {
        if (valueLength > 0) {
            if (typ != 0) {
                buffer.put(typ);
                if (ByteUtil.getSubGroup(typ) != 5) {
                    int lenSize = ByteUtil.getTypLen(typ, valueLength, true);
                    if (lenSize == 1) {
                        if (typ == 65 || ByteUtil.getSubGroup(typ) == 1) {
                            buffer.put((byte)(valueLength + 32));
                        } else {
                            buffer.put((byte)valueLength);
                        }
                    } else if (lenSize == 2) {
                        buffer.put((short)valueLength);
                    } else if (lenSize == 4) {
                        buffer.put(valueLength);
                    }
                }
            }
        } else if (buffer != null) {
            buffer.put((byte)34);
        }
    }

    public static byte[] clone(byte[] entity) {
        byte[] result = new byte[entity.length];
        for (int i = 0; i < entity.length; ++i) {
            result[i] = entity[i];
        }
        return result;
    }

    public static byte getTyp(byte group, byte subGroup) {
        return (byte)(group + subGroup);
    }

    public static byte getTyp(byte typ, int len, boolean isLast) {
        if (ByteUtil.isGroup(typ)) {
            if (isLast) {
                return ByteUtil.getTyp(typ, (byte)5);
            }
            if (len > Short.MAX_VALUE) {
                return ByteUtil.getTyp(typ, (byte)4);
            }
            if (len > 250) {
                return ByteUtil.getTyp(typ, (byte)3);
            }
            if (len > 32) {
                return ByteUtil.getTyp(typ, (byte)2);
            }
            return ByteUtil.getTyp(typ, (byte)1);
        }
        return typ;
    }

    public static int getTypLen(byte typ, int len, boolean isLast) {
        if (ByteUtil.isGroup(typ)) {
            int ref = typ % 16 - 10;
            if (ref == 0) {
                typ = ByteUtil.getTyp(typ, len, isLast);
                ref = typ % 16 - 10;
            }
            if (ref == 2 || ref == 1) {
                return 1;
            }
            if (ref == 3) {
                return 2;
            }
            if (ref == 4) {
                return 4;
            }
            return 0;
        }
        if (typ == 65) {
            return 1;
        }
        if (typ == 66) {
            return 4;
        }
        return 0;
    }

    public static ByteBuffer getBuffer(int len) {
        if (len < 1) {
            return null;
        }
        ByteBuffer message = ByteBuffer.allocate(len);
        return message;
    }

    public static boolean isPrimitive(byte typ) {
        return typ >= 48 && typ <= 54 || typ <= 64;
    }

    public static boolean isGroup(byte typ) {
        return (typ & 8) == 8;
    }

    public static String getStringTyp(byte typ) {
        if (typ == 34) {
            return "DATATYPE_NULL";
        }
        if (typ == 0) {
            return "DATATYPE_FIXED";
        }
        if (typ == 48) {
            return "DATATYPE_SHORT";
        }
        if (typ == 49) {
            return "DATATYPE_INTEGER";
        }
        if (typ == 50) {
            return "DATATYPE_LONG";
        }
        if (typ == 51) {
            return "DATATYPE_FLOAT";
        }
        if (typ == 52) {
            return "DATATYPE_DOUBLE";
        }
        if (typ == 53) {
            return "DATATYPE_DATE";
        }
        if (typ == 35) {
            return "DATATYPE_CLAZZID";
        }
        if (typ == 67) {
            return "DATATYPE_CLAZZPACKAGE";
        }
        if (typ == 65) {
            return "DATATYPE_CLAZZNAME";
        }
        if (typ == 66) {
            return "DATATYPE_CLAZZNAMELONG";
        }
        if (typ == 68) {
            return "DATATYPE_CLAZZTYP";
        }
        if (typ == 69) {
            return "DATATYPE_CLAZZTYPLONG";
        }
        if (typ == 54) {
            return "DATATYPE_BYTE";
        }
        if (typ == 55) {
            return "DATATYPE_UNSIGNEDBYTE";
        }
        if (typ == 64) {
            return "DATATYPE_CHAR";
        }
        if (typ == 70) {
            return "DATATYPE_ASSOC";
        }
        if (typ == 71) {
            return "DATATYPE_ASSOCLONG";
        }
        if (typ == 80) {
            return "DATATYPE_CLAZZSTREAM";
        }
        if (ByteUtil.isGroup(typ)) {
            byte group = ByteUtil.getGroup(typ);
            byte subgroup = ByteUtil.getSubGroup(typ);
            String result = "";
            if (group == 58) {
                result = "DATATYPE_BYTEARRAY";
            } else if (group == 74) {
                result = "DATATYPE_STRING";
            } else if (group == 90) {
                result = "DATATYPE_LIST";
            } else if (group == 106) {
                result = "DATATYPE_MAP";
            } else if (group == 122) {
                result = "DATATYPE_CHECK";
            }
            if (subgroup == 1) {
                result = result + "LITTLE";
            } else if (subgroup == 2) {
                result = result + "SHORT";
            } else if (subgroup == 3) {
                result = result + "MID";
            } else if (subgroup == 4) {
                result = result + "BIG";
            } else if (subgroup == 5) {
                result = result + "LAST";
            }
            return result;
        }
        return null;
    }

    public static byte getGroup(byte typ) {
        return (byte)(typ / 16 * 16 + 10);
    }

    public static byte getSubGroup(byte typ) {
        return (byte)(typ % 16 - 10);
    }
}

