/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.bytes.ByteEntity;
import de.uniks.networkparser.bytes.ByteUtil;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.converter.ByteConverterHTTP;
import de.uniks.networkparser.converter.ByteConverterString;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.list.SimpleList;

public class ByteList
extends SimpleList<ByteItem>
implements ByteItem {
    private byte typ = 0;

    @Override
    public BaseItem getNewList(boolean keyValue) {
        if (keyValue) {
            return new ByteEntity();
        }
        return new ByteList();
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Converter converter) {
        if (converter instanceof ByteConverter) {
            return this.toString((ByteConverter)converter, false);
        }
        return this.toString(null, false);
    }

    @Override
    public String toString(ByteConverter converter, boolean dynamic) {
        if (converter == null) {
            converter = new ByteConverterHTTP();
        }
        return converter.toString(this.getBytes(dynamic));
    }

    @Override
    public ByteBuffer getBytes(boolean isDynamic) {
        int len = this.calcLength(isDynamic, true);
        ByteBuffer buffer = ByteUtil.getBuffer(len);
        this.writeBytes(buffer, isDynamic, true, this.isPrimitive(isDynamic));
        buffer.flip(true);
        return buffer;
    }

    @Override
    public void writeBytes(ByteBuffer buffer, boolean isDynamic, boolean last, boolean isPrimitive) {
        isPrimitive = this.isPrimitive(isDynamic);
        int size = this.calcChildren(isDynamic, last);
        byte typ = isPrimitive ? (byte)80 : (byte)ByteUtil.getTyp(this.getTyp(), size, last);
        ByteUtil.writeByteHeader(buffer, typ, size);
        for (int i = 0; i < this.size(); ++i) {
            ((ByteItem)this.get(i)).writeBytes(buffer, isDynamic, i == this.size() - 1, isPrimitive);
        }
    }

    @Override
    public int calcLength(boolean isDynamic, boolean isLast) {
        if (this.size() == 0) {
            return 1;
        }
        int length = this.calcChildren(isDynamic, isLast);
        if (this.typ != 0) {
            length += 1 + ByteUtil.getTypLen(this.typ, length, isLast);
        }
        return length;
    }

    public int calcChildren(boolean isDynamic, boolean isLast) {
        int size = this.size();
        if (size < 1) {
            return 0;
        }
        boolean isPrimitive = isDynamic;
        int nullerBytes = 0;
        if (this.get(size - 1) instanceof ByteEntity) {
            boolean bl = isPrimitive = isPrimitive && ((ByteItem)this.get(0)).getTyp() == 68;
            if (((ByteItem)this.get(size - 1)).getTyp() == 34) {
                ++nullerBytes;
            }
        } else {
            isPrimitive = false;
        }
        int length = ((ByteItem)this.get(size - 1)).calcLength(isDynamic, true);
        for (int i = size - 2; i >= 0; --i) {
            int len = ((ByteItem)this.get(i)).calcLength(isDynamic, false);
            if (isPrimitive) {
                if (((ByteItem)this.get(i)).getTyp() == 34) {
                    ++nullerBytes;
                }
                isPrimitive = ((ByteItem)this.get(i)).size() == len - 1;
            }
            length += len;
        }
        if (isPrimitive) {
            length = length - size + 1 + 1 + nullerBytes;
        }
        return length;
    }

    private boolean isPrimitive(boolean isDynamic) {
        if (!isDynamic) {
            return false;
        }
        if (this.size() < 1) {
            return false;
        }
        if (!(this.get(this.size() - 1) instanceof ByteEntity)) {
            return false;
        }
        if (((ByteItem)this.get(0)).getTyp() != 68) {
            return false;
        }
        for (int i = 1; i < this.size(); ++i) {
            int len = ((ByteItem)this.get(i)).calcLength(isDynamic, false);
            if (((ByteItem)this.get(i)).size() == len - 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte getTyp() {
        return this.typ;
    }

    public ByteList withTyp(Byte value) {
        if (value != null) {
            this.typ = value;
        }
        return this;
    }

    public SimpleList<ByteItem> withValue(String value) {
        ByteConverterString converter = new ByteConverterString();
        this.add(((ByteEntity)this.getNewList(true)).withValue((byte)0, converter.decode(value)));
        return this;
    }

    @Override
    public ByteList with(Object ... values) {
        if (values != null) {
            for (Object value : values) {
                if (!(value instanceof ByteItem)) continue;
                this.add((ByteItem)value);
            }
        }
        return this;
    }

    @Override
    public boolean remove(Object value) {
        return this.removeByObject(value) >= 0;
    }
}

