/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import java.nio.charset.Charset;

public class ByteBuffer
extends BufferedBuffer {
    protected byte[] buffer;

    @Override
    public char charAt(int index) {
        return (char)this.buffer[index];
    }

    @Override
    public byte byteAt(int index) {
        return this.buffer[index];
    }

    @Override
    public CharacterBuffer subSequence(int start, int length) {
        byte[] sub = new byte[length];
        for (int i = 0; i < length; ++i) {
            sub[i] = this.buffer[start + length];
        }
        return new CharacterBuffer().with(sub);
    }

    public ByteBuffer withBufferLength(int length) {
        super.withLength(length);
        this.buffer = new byte[length];
        return this;
    }

    @Override
    public char getChar() {
        char result = (char)this.getByte();
        result = (char)(result << 8 + (char)this.getByte());
        return result;
    }

    @Override
    public byte getByte() {
        return this.buffer[++this.position];
    }

    public byte[] getValue(int start, int len) {
        this.withPosition(start);
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getByte();
        }
        return array;
    }

    public byte[] array() {
        return this.buffer;
    }

    public void put(byte value) {
        if (this.buffer != null) {
            this.buffer[this.position++] = value;
        }
    }

    public void put(short value) {
        if (this.buffer != null) {
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(int value) {
        if (this.buffer != null) {
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(long value) {
        if (this.buffer != null) {
            this.buffer[this.position++] = (byte)(value >>> 56);
            this.buffer[this.position++] = (byte)(value >>> 48);
            this.buffer[this.position++] = (byte)(value >>> 40);
            this.buffer[this.position++] = (byte)(value >>> 32);
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(char value) {
        if (this.buffer != null) {
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(float value) {
        int bits = Float.floatToIntBits(value);
        if (this.buffer != null) {
            this.buffer[this.position++] = (byte)(bits & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 24 & 0xFF);
        }
    }

    public void put(double value) {
        long bits = Double.doubleToLongBits(value);
        if (this.buffer != null) {
            this.buffer[this.position++] = (byte)(bits >> 56 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 48 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 40 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 32 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 0 & 0xFFL);
        }
    }

    public void put(byte[] value) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                this.put(value[i]);
            }
        }
    }

    public void put(byte[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.put(value[offset + i]);
        }
    }

    public ByteBuffer flip(boolean preFirst) {
        if (preFirst) {
            this.position = -1;
            return this;
        }
        this.position = 0;
        return this;
    }

    public ByteBuffer getNewBuffer(int capacity) {
        return new ByteBuffer().withBufferLength(capacity);
    }

    public static ByteBuffer allocate(int len) {
        ByteBuffer bytesBuffer = new ByteBuffer();
        bytesBuffer.withBufferLength(len);
        return bytesBuffer;
    }

    public ByteBuffer getNewBuffer(byte[] array) {
        return new ByteBuffer().with(array);
    }

    public ByteBuffer with(String string) {
        this.buffer = string.getBytes(Charset.forName("UTF-8"));
        this.position = 0;
        this.length = this.buffer.length;
        return this;
    }

    public ByteBuffer with(byte[] array) {
        this.buffer = array;
        this.position = 0;
        this.length = array.length;
        return this;
    }

    public ByteBuffer with(byte value) {
        if (this.buffer == null) {
            this.buffer = new byte[]{value};
            this.length = 1;
            this.position = 0;
        } else if (this.length < this.buffer.length) {
            this.buffer[this.length++] = value;
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.buffer);
    }
}

