/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.calculator;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.calculator.Addition;
import de.uniks.networkparser.calculator.Division;
import de.uniks.networkparser.calculator.Maximum;
import de.uniks.networkparser.calculator.Minimum;
import de.uniks.networkparser.calculator.Mod;
import de.uniks.networkparser.calculator.Multiply;
import de.uniks.networkparser.calculator.Operator;
import de.uniks.networkparser.calculator.Potenz;
import de.uniks.networkparser.calculator.Subtract;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RegCalculator {
    public static final int LINE = 1;
    public static final int POINT = 2;
    public static final int POTENZ = 3;
    public static final int FUNCTION = 4;
    public static final String BACKETSOPEN = "([{";
    public static final String BACKETSCLOSE = ")]}";
    private HashMap<String, Operator> operators = new HashMap();
    private Map<String, Double> constants = new HashMap<String, Double>();

    public RegCalculator withStandard() {
        this.withOperator(new Addition());
        this.withOperator(new Subtract());
        this.withOperator(new Multiply());
        this.withOperator(new Division());
        this.withOperator(new Potenz());
        this.withOperator(new Mod());
        this.withOperator(new Minimum());
        this.withOperator(new Maximum());
        return this;
    }

    public RegCalculator withOperator(Operator value) {
        this.operators.put(value.getTag(), value);
        return this;
    }

    public RegCalculator withConstants(String tag, double value) {
        this.constants.put(tag, value);
        return this;
    }

    public Double calculate(String formular) {
        Double[] values = this.calculateFields(formular);
        if (values.length < 1) {
            return null;
        }
        return values[0];
    }

    public Double[] calculateFields(String formular) {
        int pos;
        CharacterBuffer tokener = new CharacterBuffer();
        tokener.with(formular);
        ArrayList<String> parts = new ArrayList<String>();
        if (tokener.getCurrentChar() == '(' && tokener.charAt(tokener.length() - 1) == ')') {
            pos = tokener.position();
            String value = tokener.getStringPart(Character.valueOf('('), Character.valueOf(')'));
            if (value != null && tokener.position() == tokener.length()) {
                tokener.withStartPosition(++pos);
                tokener.withPosition(0);
                tokener.withBufferLength(tokener.length() - 2);
            } else {
                tokener.withPosition(pos);
            }
        }
        Character current = Character.valueOf(tokener.getCurrentChar());
        boolean defaultMulti = false;
        while (!tokener.isEnd()) {
            String value;
            if (current == null) {
                current = Character.valueOf(tokener.nextClean(defaultMulti));
            }
            if (current.charValue() == ',') {
                current = null;
                defaultMulti = false;
                continue;
            }
            pos = BACKETSOPEN.indexOf(current.charValue());
            if (pos >= 0 && (value = tokener.getStringPart(Character.valueOf(BACKETSOPEN.charAt(pos)), Character.valueOf(BACKETSCLOSE.charAt(pos)))) != null) {
                if (defaultMulti) {
                    parts.add("*");
                }
                if (pos > 0) {
                    parts.add("(" + value.substring(1, value.length() - 1) + ")");
                } else {
                    parts.add(value);
                }
                defaultMulti = true;
                current = null;
                continue;
            }
            StringBuilder sb = new StringBuilder();
            if (Character.isDigit(current.charValue()) || current.charValue() == '.') {
                while (Character.isDigit(current.charValue()) || current.charValue() == '.') {
                    sb.append(current);
                    current = Character.valueOf(tokener.getChar());
                }
                if (defaultMulti) {
                    parts.add("*");
                }
                parts.add(sb.toString());
                defaultMulti = true;
                continue;
            }
            if (current.charValue() != ' ') {
                sb.append(current);
            }
            while (!tokener.isEnd()) {
                if (this.addOperator(sb.toString(), tokener, parts)) {
                    sb = new StringBuilder();
                    defaultMulti = false;
                    break;
                }
                current = Character.valueOf(tokener.getChar());
                sb.append(current);
            }
            if (sb.length() > 0) {
                this.addOperator(sb.toString(), tokener, parts);
                defaultMulti = false;
            }
            current = null;
        }
        int z = parts.size() - 1;
        while (z >= 0) {
            Operator operator;
            pos = ((String)parts.get(z)).indexOf("(");
            if (pos < 0) {
                if (z > 0 && (operator = this.operators.get(parts.get(z - 1))) != null && operator.getPriority() == 1) {
                    Operator preOperator;
                    if (z > 1 && (preOperator = this.operators.get(parts.get(z - 2))) == null) {
                        --z;
                        continue;
                    }
                    if (operator.getTag().equals("-")) {
                        parts.set(z - 1, "" + Double.valueOf(parts.get(z)) * -1.0);
                    } else {
                        parts.set(z - 1, "" + Double.valueOf(parts.get(z)));
                    }
                    parts.remove(z);
                    --z;
                }
                --z;
                continue;
            }
            if (pos > 0) {
                operator = this.operators.get(((String)parts.get(z)).substring(0, ((String)parts.get(z)).indexOf("(")));
                Double[] values = this.calculateFields(parts.get(z).substring(pos + 1, parts.get(z).length() - 1));
                if (operator != null && values.length >= operator.getValues()) {
                    parts.set(z, "" + operator.calculate(values));
                }
            }
            parts.set(z, "" + this.calculate((String)parts.get(z)));
        }
        for (int prio = 3; prio > 0; --prio) {
            for (int i = 0; i < parts.size(); ++i) {
                Operator operator = this.operators.get(parts.get(i));
                if (operator == null || operator.getPriority() != prio) continue;
                parts.set(i - 1, "" + operator.calculate(new Double[]{Double.valueOf(parts.get(i - 1)), Double.valueOf(parts.get(i + 1))}));
                parts.remove(i);
                parts.remove(i);
                --i;
            }
        }
        Double[] result = new Double[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            result[i] = Double.valueOf((String)parts.get(i));
        }
        return result;
    }

    private boolean addOperator(String value, CharacterBuffer tokener, ArrayList<String> parts) {
        if (this.constants.containsKey(value)) {
            return parts.add("" + this.constants.get(value));
        }
        if (this.operators.containsKey(value)) {
            if (this.operators.get(value).getPriority() == 4) {
                tokener.skip();
                return parts.add(value + tokener.getStringPart(Character.valueOf('('), Character.valueOf(')')));
            }
            return parts.add(value);
        }
        return false;
    }
}

