/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes.checksum;

import de.uniks.networkparser.bytes.checksum.CRCTable;

public class Crc32
extends CRCTable {
    @Override
    public int[] getGenTable() {
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        return crc_table;
    }

    @Override
    public void update(int bval) {
        super.update(bval);
        int c = (int)(this.value ^ 0xFFFFFFFFFFFFFFFFL);
        c = this.crc_table[(c ^ bval) & 0xFF] ^ c >>> 8;
        this.value = ~c;
    }

    @Override
    public int getPolynom() {
        return 0;
    }

    @Override
    public boolean isReflect() {
        return false;
    }

    @Override
    public int getOrder() {
        return 32;
    }
}

