/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.NetworkParserLog;
import de.uniks.networkparser.SimpleGrammar;
import de.uniks.networkparser.SimpleIdCounter;
import de.uniks.networkparser.TextItems;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.bytes.ByteEntity;
import de.uniks.networkparser.bytes.ByteTokener;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.event.ObjectMapEntry;
import de.uniks.networkparser.event.util.DateCreator;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphTokener;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.IdMapCounter;
import de.uniks.networkparser.interfaces.SendableEntity;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.interfaces.UpdateListener;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.json.UpdateJson;
import de.uniks.networkparser.json.util.JsonArrayCreator;
import de.uniks.networkparser.json.util.JsonObjectCreator;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.Deep;
import de.uniks.networkparser.sort.EntityComparator;
import de.uniks.networkparser.xml.EMFTokener;
import de.uniks.networkparser.xml.MapEntityStack;
import de.uniks.networkparser.xml.XMLEntity;
import de.uniks.networkparser.xml.XMLEntityCreator;
import de.uniks.networkparser.xml.XMLTokener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IdMap
implements Iterable<SendableEntityCreator> {
    public static final String CLASS = "class";
    public static final String VALUE = "value";
    public static final String ID = "id";
    public static final String REMOVE = "rem";
    public static final String UPDATE = "upd";
    public static final String NEW = "new";
    public static final char SPACE = ' ';
    public static final char EQUALS = '=';
    public static final String MAINITEM = "main";
    public static final char DOUBLEQUOTIONMARK = '\"';
    public static final String REMOVE_YOU = "REMOVE_YOU";
    public static final byte FLAG_ID = 1;
    public static final byte FLAG_TYPESAVE = 2;
    public static final byte FLAG_SEARCHFORSUPERCLASS = 4;
    private byte flag;
    private Grammar grammar = new SimpleGrammar();
    private IdMapCounter counter;
    protected SimpleKeyValueList<String, Object> keyValue = (SimpleKeyValueList)new SimpleKeyValueList().withFlag((byte)64);
    protected Filter filter = new Filter();
    private JsonTokener jsonTokener = new JsonTokener().withMap(this);
    private XMLTokener xmlTokener = new XMLTokener().withMap(this);
    private ByteTokener byteTokener = new ByteTokener().withMap(this);
    protected NetworkParserLog logger = new NetworkParserLog();
    protected UpdateListener updateListener;
    protected UpdateListener condition;
    protected PropertyChangeListener listener = new UpdateJson(this);
    public static final char ENTITYSPLITTER = '.';
    protected SimpleKeyValueList<String, SendableEntityCreator> creators = (SimpleKeyValueList)new SimpleKeyValueList().withAllowDuplicate(false);

    public IdMap() {
        this.with(new TextItems());
        this.with(new DateCreator());
        this.with(new JsonObjectCreator());
        this.with(new JsonArrayCreator());
        this.with(new ObjectMapEntry());
        this.with(new XMLEntityCreator());
    }

    public UpdateListener getCondition() {
        return this.condition;
    }

    public UpdateListener getListener() {
        return this.updateListener;
    }

    public SendableEntityCreator getCreatorClass(Object reference) {
        if (reference == null) {
            return null;
        }
        return this.getCreator(reference.getClass().getName(), true);
    }

    public SendableEntityCreator getCreator(String clazz, boolean fullName) {
        Object creator = this.creators.getValue(clazz);
        if (creator != null || fullName) {
            return (SendableEntityCreator)creator;
        }
        String endTag = clazz.lastIndexOf(46) >= 0 ? '.' + clazz.substring(clazz.lastIndexOf(46) + 1) : '.' + clazz;
        for (int i = 0; i < this.creators.size(); ++i) {
            String key = this.creators.getKeyByIndex(i);
            SendableEntityCreator value = this.creators.getValueByIndex(i);
            if (!key.endsWith(endTag)) continue;
            return value;
        }
        return null;
    }

    public IdMap with(Collection<SendableEntityCreator> creatorSet) {
        if (creatorSet == null) {
            return this;
        }
        for (SendableEntityCreator sendableEntityCreator : creatorSet) {
            this.with(sendableEntityCreator);
        }
        return this;
    }

    public IdMap with(Iterable<SendableEntityCreator> iterator) {
        if (iterator == null) {
            return null;
        }
        Iterator<SendableEntityCreator> i = iterator.iterator();
        while (i.hasNext()) {
            this.with(i.next());
        }
        return this;
    }

    public IdMap with(SendableEntityCreator ... createrClass) {
        if (createrClass == null) {
            return this;
        }
        for (SendableEntityCreator creator : createrClass) {
            if (creator == null) continue;
            try {
                Object reference = creator.getSendableInstance(true);
                if (reference == null) continue;
                if (reference instanceof Class) {
                    this.flag = (byte)4;
                    this.with(((Class)reference).getName(), creator);
                    continue;
                }
                this.with(reference.getClass().getName(), creator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public IdMap with(String className, SendableEntityCreator creator) {
        this.creators.add(className, creator);
        if (creator instanceof SendableEntityCreatorTag) {
            SendableEntityCreatorTag creatorTag = (SendableEntityCreatorTag)creator;
            this.creators.add(creatorTag.getTag(), creator);
        }
        return this;
    }

    public boolean removeCreator(String className) {
        return this.creators.remove(className) != null;
    }

    public IdMap with(IdMapCounter counter) {
        this.counter = counter;
        return this;
    }

    public IdMapCounter getCounter() {
        if (this.counter == null) {
            this.counter = new SimpleIdCounter();
        }
        return this.counter;
    }

    public String getKey(Object obj) {
        String result = null;
        try {
            int pos = this.keyValue.indexOfValue(obj);
            if (pos >= 0) {
                return this.keyValue.getKeyByIndex(pos);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return result;
    }

    public Object getObject(String key) {
        Object result = null;
        try {
            result = this.keyValue.getValue(key);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return result;
    }

    public String getId(Object obj) {
        String key = this.getKey(obj);
        if (key != null) {
            return key;
        }
        key = this.grammar.getId(obj, this.getCounter());
        if (key != null) {
            this.put(key, obj);
            return key;
        }
        key = this.getCounter().getId(obj);
        this.put(key, obj);
        return key;
    }

    public Object put(String jsonId, Object object) {
        this.keyValue.with(jsonId, object);
        this.addListener(object);
        return object;
    }

    protected boolean addListener(Object object) {
        if (object instanceof SendableEntity) {
            ((SendableEntity)object).addPropertyChangeListener(this.listener);
        }
        return false;
    }

    public boolean removeObj(Object oldValue, boolean destroy) {
        SendableEntityCreator creator;
        String key = this.getKey(oldValue);
        if (destroy && (creator = this.getCreatorClass(oldValue)) != null) {
            String[] props;
            for (String prop : props = creator.getProperties()) {
                Object reference = creator.getValue(oldValue, prop);
                if (reference instanceof Collection) {
                    Collection continee = (Collection)reference;
                    Iterator i = continee.iterator();
                    while (i.hasNext()) {
                        creator.setValue(oldValue, prop, i.next(), REMOVE);
                    }
                    continue;
                }
                creator.setValue(oldValue, prop, reference, REMOVE);
            }
        }
        if (key != null) {
            this.keyValue.without(key);
            return true;
        }
        return false;
    }

    public int size() {
        return this.keyValue.size();
    }

    public Object cloneObject(Object reference, Filter filter) {
        MapEntity map = new MapEntity(filter, this.grammar);
        map.withFlag(this.flag);
        return this.cloning(reference, map);
    }

    private Object cloning(Object reference, MapEntity map) {
        SendableEntityCreator creatorClass = this.getCreatorClass(reference);
        if (map.contains(reference)) {
            return null;
        }
        map.with(new Object[]{reference});
        Object newObject = null;
        if (creatorClass != null) {
            String[] properties;
            newObject = creatorClass.getSendableInstance(false);
            for (String property : properties = creatorClass.getProperties()) {
                Object value = creatorClass.getValue(reference, property);
                if (value instanceof Collection) {
                    if (!map.isFullSeriation() && !map.isPropertyRegard(reference, this, property, value)) continue;
                    Collection list = (Collection)value;
                    map.add();
                    for (Object item : list) {
                        Object refValue = map.getRefByEntity(item);
                        if (refValue != null) {
                            creatorClass.setValue(newObject, property, refValue, NEW);
                            continue;
                        }
                        SendableEntityCreator childCreatorClass = this.getCreatorClass(item);
                        if (childCreatorClass != null) {
                            if (!map.isConvertable(reference, this, property, item)) {
                                creatorClass.setValue(newObject, property, item, NEW);
                                continue;
                            }
                            Object clonedChild = this.cloning(item, map);
                            if (clonedChild == null) continue;
                            creatorClass.setValue(newObject, property, clonedChild, NEW);
                            continue;
                        }
                        creatorClass.setValue(newObject, property, item, NEW);
                    }
                    map.minus();
                    continue;
                }
                if (!map.isPropertyRegard(reference, this, property, value)) continue;
                Object refValue = map.getRefByEntity(value);
                if (refValue != null) {
                    creatorClass.setValue(newObject, property, refValue, NEW);
                    continue;
                }
                SendableEntityCreator childCreatorClass = this.getCreatorClass(value);
                if (childCreatorClass != null) {
                    Object clonedChild;
                    map.add();
                    if (!map.isConvertable(reference, this, property, value)) {
                        creatorClass.setValue(newObject, property, value, NEW);
                    } else if (map.isPropertyRegard(reference, this, property, value) && (clonedChild = this.cloning(value, map)) != null) {
                        creatorClass.setValue(newObject, property, clonedChild, NEW);
                    }
                    map.minus();
                    continue;
                }
                creatorClass.setValue(newObject, property, value, NEW);
            }
        }
        return newObject;
    }

    public SimpleList<Object> getTypList(SendableEntityCreator creator) {
        if (creator == null) {
            return null;
        }
        SimpleList<Object> result = new SimpleList<Object>();
        String clazzName = creator.getSendableInstance(true).getClass().getName();
        for (Object item : this.keyValue.valuesArrayIntern()) {
            if (item == null || !item.getClass().getName().equals(clazzName)) continue;
            result.add(item);
        }
        return result;
    }

    public boolean replaceObject(Object newObject) {
        String key = this.getKey(newObject);
        if (key != null) {
            return false;
        }
        if (!(newObject instanceof Comparable)) {
            return false;
        }
        SendableEntityCreator creator = this.getCreatorClass(newObject);
        if (creator == null) {
            return false;
        }
        boolean result = false;
        SimpleList<Object> oldValues = this.getTypList(creator);
        for (Object v : oldValues) {
            String oldKey;
            Comparable oldValue;
            if (!(v instanceof Comparable) || (oldValue = (Comparable)v).compareTo(newObject) != 0 || (oldKey = this.getKey(oldValue)) == null) continue;
            this.keyValue.remove(oldValue);
            this.put(oldKey, newObject);
        }
        return result;
    }

    public void clear() {
        this.keyValue.clear();
    }

    public IdMap with(Filter filter) {
        this.filter = filter;
        return this;
    }

    public boolean isCaseSensitive() {
        return this.keyValue.isCaseSensitive();
    }

    public IdMap withCaseSensitive(boolean value) {
        this.keyValue.withCaseSensitive(value);
        return this;
    }

    @Override
    public Iterator<SendableEntityCreator> iterator() {
        return this.creators.values().iterator();
    }

    public boolean notify(PropertyChangeEvent event) {
        if (this.listener != null) {
            this.listener.propertyChange(event);
            if (this.listener != null && this.listener instanceof UpdateListener) {
                return ((UpdateListener)((Object)this.listener)).update(event);
            }
            if (this.updateListener != null) {
                this.updateListener.update(event);
            }
            if (this.condition != null) {
                return this.condition.update(event);
            }
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + " (" + this.size() + ")";
    }

    public IdMap with(UpdateListener updateListener) {
        this.updateListener = updateListener;
        return this;
    }

    public IdMap withFilter(UpdateListener updateListener) {
        this.condition = updateListener;
        return this;
    }

    public void garbageCollection(Object root) {
        if (this.listener instanceof UpdateJson) {
            ((UpdateJson)this.listener).garbageCollection(root);
        }
    }

    public IdMap with(Grammar value) {
        this.grammar = value;
        return this;
    }

    public IdMap with(PropertyChangeListener listener) {
        this.listener = listener;
        return this;
    }

    public IdMap withSessionId(String value) {
        this.getCounter().withPrefixId(value);
        return this;
    }

    public boolean hasKey(Object element) {
        return this.keyValue.contains(element);
    }

    public Object decode(Buffer value) {
        char firstChar = value.nextClean(true);
        if (firstChar == '[') {
            return this.decode(this.jsonTokener.newInstanceList().withValue(value));
        }
        if (firstChar == '{') {
            return this.decode(this.jsonTokener.newInstance().withValue(value));
        }
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        if (firstChar == '<') {
            XMLTokener tokener = new XMLTokener().withMap(this);
            tokener.withBuffer(value);
            tokener.skipHeader();
            return this.decodingXMLEntity(tokener, map);
        }
        return this.byteTokener.decodeValue((byte)firstChar, value, map);
    }

    public Object decode(Tokener tokener) {
        char firstChar = tokener.nextClean(true);
        if (firstChar == '[') {
            return this.decode(new JsonArray().withValue(tokener));
        }
        if (firstChar == '<') {
            MapEntity map = new MapEntity(this.filter, this.grammar);
            map.withFlag(this.flag);
            if (tokener instanceof XMLTokener) {
                XMLTokener xmlTokener = (XMLTokener)tokener;
                xmlTokener.skipHeader();
                return this.decodingXMLEntity(xmlTokener, map);
            }
            if (tokener instanceof EMFTokener) {
                EMFTokener xmlTokener = (EMFTokener)tokener;
                xmlTokener.withMap(this);
                return xmlTokener.decode(map, null);
            }
            return null;
        }
        Entity item = tokener.newInstance();
        if (item == null) {
            return null;
        }
        tokener.parseToEntity(item);
        return this.decode(item);
    }

    public Object decode(String value) {
        if (value == null) {
            return null;
        }
        return this.decode(new CharacterBuffer().with(value.intern()));
    }

    public Object decodeEMF(String value) {
        return this.decodeEMF(value, null);
    }

    public Object decodeEMF(String value, Object root) {
        if (value == null) {
            return null;
        }
        EMFTokener tokener = new EMFTokener();
        MapEntity map = new MapEntity(this.filter, this.grammar);
        tokener.withMap(this);
        map.withFlag(this.flag);
        tokener.withBuffer(value);
        return tokener.decode(map, root);
    }

    public Object decode(String value, ByteConverter converter) {
        if (converter == null) {
            return null;
        }
        byte[] decodeBytes = converter.decode(value);
        if (decodeBytes == null) {
            return null;
        }
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        ByteBuffer buffer = new ByteBuffer().with(decodeBytes);
        return this.byteTokener.decodeValue((byte)buffer.getCurrentChar(), buffer, map);
    }

    public Object decode(BaseItem value) {
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        return this.decoding(value, map);
    }

    public Object decode(BaseItem value, Object target, Filter filter) {
        if (filter == null) {
            filter = this.filter;
        }
        MapEntity map = new MapEntity(filter, this.grammar);
        map.withFlag(this.flag);
        map.withTarget(target);
        return this.decoding(value, map);
    }

    private Object decoding(BaseItem value, MapEntity map) {
        if (value instanceof JsonArray) {
            return this.decodingJsonArray((JsonArray)value, map);
        }
        if (value instanceof XMLEntity) {
            return this.decodingXMLEntity(new XMLTokener().withMap(this).withBuffer(value.toString()), map);
        }
        if (value instanceof ByteEntity) {
            ByteEntity entity = (ByteEntity)value;
            return this.byteTokener.decodeValue(entity, map);
        }
        return this.decodingJsonObject((JsonObject)value, map);
    }

    private Object decodingXMLEntity(XMLTokener tokener, MapEntity map) {
        if (tokener.skipTo('<', false)) {
            map.withStack(new MapEntityStack());
            tokener.parseEntity(tokener, map);
            return tokener.parse(tokener, map);
        }
        return null;
    }

    private Object decodingJsonArray(JsonArray jsonArray, MapEntity map) {
        Object result = null;
        int len = jsonArray.size() - 1;
        for (int i = 0; i <= len; ++i) {
            JsonObject kidObject = jsonArray.getJSONObject(i);
            Object tmp = this.decodingJsonObject(kidObject, map);
            if (kidObject.has(MAINITEM)) {
                result = tmp;
                continue;
            }
            if (i != 0) continue;
            result = tmp;
        }
        return result;
    }

    private Object decodingJsonObject(JsonObject jsonObject, MapEntity map) {
        UpdateJson listener;
        Object result;
        if (this.listener instanceof UpdateJson && (result = (listener = (UpdateJson)this.listener).execute(jsonObject, this.filter)) != null) {
            return result;
        }
        return this.jsonTokener.decoding(jsonObject, map);
    }

    public JsonArray getJsonByIds(List<String> ids) {
        if (ids == null) {
            return null;
        }
        JsonArray items = new JsonArray();
        for (String childId : ids) {
            JsonObject jsonObject = this.toJsonObject(this.getObject(childId), new Filter().withConvertable(new Deep().withDeep(0)));
            if (jsonObject == null) continue;
            items.add(jsonObject);
        }
        return items;
    }

    public XMLEntity toXMLEntity(Object entity) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        return (XMLEntity)this.encode(entity, map, this.xmlTokener);
    }

    public XMLEntity toSimpleXML(Object entity) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        map.withoutFlag((byte)1);
        map.withStack(new MapEntityStack());
        return (XMLEntity)this.encode(entity, map, this.xmlTokener);
    }

    public JsonObject toJsonObject(Object entity) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        return (JsonObject)this.encode(entity, map, this.jsonTokener);
    }

    public JsonObject toJsonObject(Object entity, Filter filter) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(filter, this.grammar);
        map.withFlag(this.flag);
        return (JsonObject)this.encode(entity, map, this.jsonTokener);
    }

    public JsonArray toJsonArray(Object object) {
        return this.toJsonArray(object, null);
    }

    public JsonArray toJsonArray(Object object, Filter filter) {
        if (filter == null) {
            filter = this.filter;
        }
        MapEntity map = new MapEntity(filter, this.grammar);
        map.withFlag(this.flag);
        map.withTarget(this.jsonTokener.newInstanceList());
        return (JsonArray)this.encodeList(object, map, this.jsonTokener);
    }

    public JsonArray toJsonArray(Object object, JsonArray target, Filter filter) {
        if (filter == null) {
            filter = this.filter;
        }
        MapEntity map = new MapEntity(filter, this.grammar);
        map.withFlag(this.flag);
        if (target.isComparator() && target.comparator() instanceof EntityComparator) {
            ((EntityComparator)target.comparator()).withMap(this);
        }
        map.withTarget(target);
        return (JsonArray)this.encodeList(object, map, this.jsonTokener);
    }

    public ByteItem toByteItem(Object object) {
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        return this.byteTokener.encode(object, map);
    }

    public ByteItem toByteItem(Object object, Filter filter) {
        MapEntity map = new MapEntity(filter, this.grammar);
        map.withFlag(this.flag);
        return this.byteTokener.encode(object, map);
    }

    public GraphList toObjectDiagram(Object object) {
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        return new GraphTokener().withMap(this).encode(object, map);
    }

    public GraphList toClassDiagram(Object object) {
        MapEntity map = new MapEntity(this.filter, this.grammar);
        map.withFlag(this.flag);
        map.withTokenerFlag((byte)1);
        return new GraphTokener().withMap(this).encode(object, map);
    }

    public GraphList getDiffList(Object source, Object target) {
        GraphList sourceModel = this.toObjectDiagram(source);
        GraphList targetModel = this.toObjectDiagram(target);
        return new GraphTokener().withMap(this).diffModel(sourceModel, targetModel);
    }

    private EntityList encodeList(Object object, MapEntity map, Tokener tokener) {
        EntityList target = (EntityList)map.getTarget();
        if (object instanceof Collection) {
            Collection list = (Collection)object;
            for (Object item : list) {
                if (tokener.getKey(item) != null) continue;
                this.encode(item, map, tokener);
            }
            return target;
        }
        if (object.getClass().isArray()) {
            for (Object item : (Object[])object) {
                if (tokener.getKey(item) != null) continue;
                this.encode(item, map, tokener);
            }
            return target;
        }
        this.encode(object, map, tokener);
        if (!target.isComparator()) {
            SimpleIterator queueIterator = new SimpleIterator(target);
            if (queueIterator.hasNext()) {
                queueIterator.next();
            }
            while (queueIterator.hasNext()) {
                JsonObject json = (JsonObject)queueIterator.next();
                Object item = this.getObject(json.getString(ID));
                if (item == null) continue;
                String className = item.getClass().getName();
                this.encode(item, className, map, tokener, null);
            }
        }
        return target;
    }

    public BaseItem encode(Object model, Tokener tokener) {
        return this.encode(model, tokener, this.filter);
    }

    public BaseItem encode(Object model, Tokener tokener, Filter filter) {
        MapEntity map = new MapEntity(filter, this.grammar);
        map.withFlag(this.flag);
        if (tokener == null) {
            tokener = this.jsonTokener;
        }
        tokener.withMap(this);
        BaseItem item = this.grammar.encode(model, map, tokener);
        if (item != null) {
            return item;
        }
        return this.encode(model, map, tokener);
    }

    Entity encode(Object entity, MapEntity map, Tokener tokener) {
        if (entity == null) {
            return null;
        }
        String className = entity.getClass().getName();
        return this.encode(entity, className, map, tokener, null);
    }

    public boolean isError(Object owner, String method, String type, Object entity, String className) {
        return this.logger.error(owner, method, type, entity, className);
    }

    private Entity encode(Object entity, String className, MapEntity map, Tokener tokener, BaseItem parentNode) {
        String[] properties;
        SendableEntityCreator creator = map.getCreator("write", this, entity, className);
        if (creator == null) {
            return null;
        }
        EntityList targetList = (EntityList)map.getTarget();
        String id = null;
        if (!(creator instanceof SendableEntityCreatorNoIndex)) {
            id = map.getId(entity, this, className);
        }
        boolean isSimple = targetList != null && !targetList.isComparator();
        Entity item = null;
        if (isSimple) {
            if (parentNode != null) {
                item = map.writeBasicValue(creator, tokener.newInstance(), parentNode, className, id);
                targetList.with(item);
                return item;
            }
            if (targetList instanceof JsonArray) {
                JsonArray list = (JsonArray)targetList;
                item = list.get(id);
            }
        }
        if (!isSimple || item == null) {
            item = map.writeBasicValue(creator, tokener.newInstance(), parentNode, className, id);
            if (item == null) {
                return null;
            }
            if (isSimple) {
                targetList.with(item);
            }
        }
        if ((properties = map.getProperties(tokener, creator)) != null) {
            map.pushStack(className, entity, creator);
            item.setAllowEmptyValue(map.isFullSeriation());
            Object referenceObject = map.getNewEntity(creator, className, true);
            map.add();
            CharacterBuffer prop = map.getPrefixProperties(creator, tokener, entity, className);
            int pos = prop.length();
            for (String property : properties) {
                Object value = creator.getValue(entity, property);
                if (!map.isPropertyRegard(entity, tokener.getMap(), property, value)) continue;
                if (value != null) {
                    SendableEntityCreator childCreater;
                    Entity child;
                    boolean encoding = map.isFullSeriation();
                    if (referenceObject instanceof Class) {
                        encoding = true;
                    }
                    if (!encoding) {
                        Object refValue = creator.getValue(referenceObject, property);
                        boolean bl = encoding = !value.equals(refValue);
                    }
                    if (!encoding) continue;
                    prop.setNextString(property, pos);
                    Entity parent = map.convertProperty(prop, item);
                    if (parent.has(property) && this.isError(this, "Encode", "DUPPLICATE", entity, className)) {
                        throw new RuntimeException("Property duplicate:" + property + "(" + className + ")");
                    }
                    className = value.getClass().getName();
                    SendableEntityCreator valueCreater = map.getCreator("write", tokener.getMap(), value, className);
                    String fullProp = prop.toString();
                    String childClassName = value.getClass().getName();
                    Object key = value;
                    if (map.isId(value, tokener.getMap(), className)) {
                        key = tokener.getKey(value);
                    }
                    boolean contains = false;
                    if (key != null) {
                        contains = map.contains(key);
                    }
                    if (valueCreater != null && targetList != null) {
                        if (map.isConvertable(entity, tokener.getMap(), property, value) && !contains) {
                            this.encode(value, childClassName, map, tokener, item);
                        }
                        if ((child = tokener.createLink(item, fullProp, childClassName, tokener.getId(value))) == null) continue;
                        childCreater = map.getCreator("write", tokener.getMap(), child, child.getClass().getName());
                        this.parseValue(fullProp, child, null, childCreater, map, tokener, parent);
                        continue;
                    }
                    if (valueCreater != null && (contains || !map.isConvertable(entity, tokener.getMap(), property, value))) {
                        child = null;
                        if (map.isAddOwnerLink(value)) {
                            child = tokener.createLink(item, fullProp, childClassName, tokener.getId(value));
                        }
                        if (child == null) continue;
                        childCreater = map.getCreator("write", tokener.getMap(), child, child.getClass().getName());
                        this.parseValue(fullProp, child, null, childCreater, map, tokener, parent);
                        continue;
                    }
                    this.parseValue(fullProp, value, className, valueCreater, map, tokener, parent);
                    continue;
                }
                if (!map.isFullSeriation()) continue;
                prop.setNextString(property, pos);
                Entity parent = map.convertProperty(prop, item);
                parent.put(prop.toString(), value);
            }
            map.minus();
            map.popStack();
        }
        if (targetList != null && targetList.isComparator()) {
            targetList.with(item);
        }
        return item;
    }

    private void parseValue(String property, Object value, String className, SendableEntityCreator valueCreater, MapEntity map, Tokener tokener, BaseItem parent) {
        Object writeValue = null;
        if (value instanceof Collection && valueCreater == null) {
            boolean isArray = map.getTarget() != null;
            EntityList subValues = tokener.newInstanceList();
            for (Object child : (Collection)value) {
                if (child == null) continue;
                String childClassName = child.getClass().getName();
                SendableEntityCreator childCreater = map.getCreator("write", tokener.getMap(), child, childClassName);
                Object key = child;
                if (map.isId(child, tokener.getMap(), className)) {
                    key = tokener.getKey(child);
                }
                if (map.contains(key)) {
                    child = tokener.createLink((Entity)parent, property, childClassName, tokener.getKey(child));
                    childClassName = null;
                } else if (isArray) {
                    if (map.isConvertable(value, tokener.getMap(), property, child)) {
                        this.encode(child, childClassName, map, tokener, parent);
                    }
                    child = tokener.createLink((Entity)parent, property, childClassName, tokener.getId(child));
                    childClassName = null;
                } else if (childCreater != null && !map.isConvertable(value, tokener.getMap(), property, child)) {
                    child = tokener.createLink((Entity)parent, property, childClassName, tokener.getKey(child));
                    childClassName = null;
                }
                this.parseValue(property, child, childClassName, childCreater, map, tokener, subValues);
            }
            writeValue = subValues;
        } else if (value instanceof Map && valueCreater == null) {
            Map list = (Map)value;
            EntityList subValues = tokener.newInstanceList();
            String packageName = ObjectMapEntry.class.getName();
            for (Map.Entry mapEntry : list.entrySet()) {
                SendableEntityCreator childCreater = map.getCreator("write", tokener.getMap(), mapEntry, packageName);
                this.parseValue(property, mapEntry, packageName, childCreater, map, tokener, subValues);
            }
            writeValue = subValues;
        } else {
            writeValue = valueCreater != null && className != null ? this.encode(value, className, map, tokener, parent) : value;
        }
        if (!map.writeValue(parent, property, writeValue, tokener)) {
            if (parent instanceof EntityList && tokener.isChild(writeValue)) {
                ((EntityList)parent).with(tokener.transformValue(writeValue, parent));
            } else if (parent instanceof Entity) {
                if (property.length() == 1 && property.charAt(0) == '.') {
                    ((Entity)parent).setValueItem(tokener.transformValue(value, parent));
                } else if (map.isTypSave()) {
                    Entity child = tokener.newInstance();
                    if (child != null) {
                        child.put(CLASS, className);
                        child.put(VALUE, tokener.transformValue(writeValue, parent));
                        ((Entity)parent).put(property, child);
                    }
                } else {
                    ((Entity)parent).put(property, tokener.transformValue(writeValue, parent));
                }
            }
        }
    }

    public SimpleKeyValueList<String, Object> getKeyValue() {
        return this.keyValue;
    }

    public IdMap withKeyValue(SimpleKeyValueList<String, Object> parent) {
        if (parent != null) {
            this.keyValue = parent;
        }
        return this;
    }

    public SimpleKeyValueList<String, SendableEntityCreator> getCreators() {
        return this.creators;
    }
}

