/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.MapEntityStack;
import de.uniks.networkparser.xml.XMLEntity;
import de.uniks.networkparser.xml.XMLEntityCreator;
import java.util.ArrayList;

public class XMLTokener
extends Tokener {
    public static final String TOKEN = " >//<";
    private static final String TOKENSTOPWORDS = " >/<";
    public static final String CHILDREN = "<CHILDREN>";
    public static final char ENDTAG = '/';
    public static final char ITEMEND = '>';
    public static final char ITEMSTART = '<';
    private SendableEntityCreator defaultFactory;
    private ArrayList<String> stopwords = new ArrayList();
    public static final EntityStringConverter SIMPLECONVERTER = new EntityStringConverter();
    private boolean isAllowQuote;

    public XMLTokener() {
        this.stopwords.add("?xml");
        this.stopwords.add("!--");
        this.stopwords.add("!DOCTYPE");
    }

    @Override
    public Object nextValue(BaseItem creator, boolean allowQuote, boolean allowDuppleMarks, char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                this.skip();
                CharacterBuffer v = this.nextString(new CharacterBuffer(), allowQuote, true, c);
                String g = EntityUtil.unQuote(v);
                return g;
            }
            case '<': {
                BaseItem element = creator.getNewList(false);
                if (element instanceof Entity) {
                    this.parseToEntity((Entity)element);
                }
                return element;
            }
        }
        return super.nextValue(creator, allowQuote, allowDuppleMarks, c);
    }

    @Override
    public void parseToEntity(Entity entity) {
        char c = this.getCurrentChar();
        if (c != '<') {
            c = this.nextClean(false);
        }
        if (c != '<') {
            if (this.isError(this, "parseToEntity", "PARSING", entity)) {
                throw new RuntimeException("A XML text must begin with '<'");
            }
            return;
        }
        if (!(entity instanceof XMLEntity)) {
            if (this.isError(this, "parseToEntity", "PARSING", entity)) {
                throw new RuntimeException("Parse only XMLEntity");
            }
            return;
        }
        XMLEntity xmlEntity = (XMLEntity)entity;
        xmlEntity.setType(this.buffer.nextToken(",]}/\\\"[{;=#> ").toString());
        while ((c = this.nextClean(true)) != '\u0000') {
            if (c == '>') {
                c = this.nextClean(false);
                if (c == '\u0000') {
                    return;
                }
                if (c != '<') {
                    xmlEntity.setValueItem(this.nextString(new CharacterBuffer(), false, false, '<').toString());
                    continue;
                }
            }
            if (c == '<') {
                char nextChar = this.buffer.getChar();
                if (nextChar == '/') {
                    this.skipTo('>', false);
                    break;
                }
                this.buffer.withLookAHead(c);
                if (this.getCurrentChar() == '<') {
                    XMLEntity child = xmlEntity.getNewList(true);
                    this.parseToEntity(child);
                    xmlEntity.with(child);
                    this.skip();
                    continue;
                }
                xmlEntity.setValueItem(this.nextString(new CharacterBuffer(), false, false, '<').toString());
                continue;
            }
            if (c == '/') {
                this.skip();
                break;
            }
            String key = this.nextValue(xmlEntity, false, true, c).toString();
            if (key.length() <= 0) continue;
            xmlEntity.put(key, this.nextValue(xmlEntity, this.isAllowQuote, true, this.nextClean(false)));
        }
    }

    protected void skipEntity() {
        this.skipTo('>', false);
        this.nextClean(false);
    }

    public String skipHeader() {
        CharacterBuffer tag;
        boolean skip = false;
        do {
            if ((tag = this.getString(2)) == null) {
                tag = new CharacterBuffer();
                break;
            }
            if (tag.equals("<?")) {
                this.skipEntity();
                skip = true;
                continue;
            }
            if (tag.equals("<!")) {
                this.skipEntity();
                skip = true;
                continue;
            }
            skip = false;
        } while (skip);
        String item = tag.toString();
        this.buffer.withLookAHead(item);
        return item;
    }

    public XMLTokener withBuffer(String value) {
        super.withBuffer(value);
        return this;
    }

    public String toString() {
        if (this.buffer instanceof BufferedBuffer) {
            return "XMLTokener: " + ((BufferedBuffer)this.buffer).substring(-1);
        }
        return super.toString();
    }

    @Override
    public Entity newInstance() {
        return new XMLEntity();
    }

    @Override
    public EntityList newInstanceList() {
        return new XMLEntity();
    }

    public Object parse(XMLTokener tokener, MapEntity map) {
        this.parseAttribute(tokener, map);
        return this.parseChildren(tokener, map);
    }

    protected void parseAttribute(XMLTokener tokener, MapEntity map) {
        MapEntityStack stack = map.getStack();
        Object entity = stack.getCurrentItem();
        SendableEntityCreator creator = stack.getCurrentCreator();
        if (entity != null) {
            char myChar;
            CharacterBuffer token = new CharacterBuffer();
            do {
                if (tokener.getCurrentChar() == ' ') {
                    tokener.getChar();
                }
                tokener.nextString(token, true, false, ' ', '=', '>', '/');
                myChar = tokener.getCurrentChar();
                if (myChar != '=') continue;
                String key = token.toString();
                token.reset();
                tokener.skip(2);
                tokener.nextString(token, true, false, '\"');
                String value = token.toString();
                token.reset();
                tokener.skip();
                creator.setValue(entity, key, value, "new");
                stack.setValue(key, value);
                myChar = tokener.getCurrentChar();
            } while (myChar != '>' && myChar != '\u0000' && myChar != '/');
        }
    }

    protected Object parseChildren(XMLTokener tokener, MapEntity map) {
        MapEntityStack stack = map.getStack();
        Object entity = stack.getCurrentItem();
        SendableEntityCreator creator = stack.getCurrentCreator();
        if (creator == null) {
            return null;
        }
        if (tokener.skipTo("/>", false, false)) {
            if (tokener.getCurrentChar() == '/') {
                stack.popStack();
                tokener.getChar();
                tokener.nextToken(TOKENSTOPWORDS);
                return entity;
            }
            char quote = '<';
            tokener.skip();
            CharacterBuffer valueItem = new CharacterBuffer();
            tokener.nextString(valueItem, false, false, quote);
            if (!valueItem.isEmptyCharacter()) {
                CharacterBuffer test = new CharacterBuffer();
                while (!tokener.isEnd()) {
                    if (tokener.getCurrentChar() == '<') {
                        test.with(tokener.getCurrentChar());
                        test.with(tokener.getChar());
                    }
                    if (tokener.getCurrentChar() == '/') {
                        CharacterBuffer endTag = tokener.nextToken(TOKEN);
                        String currentTag = stack.getCurrentTag();
                        if (currentTag == null || currentTag.equals(endTag.toString())) break;
                        valueItem.with(test);
                        valueItem.with(endTag);
                        valueItem.with(tokener.getCurrentChar());
                    } else if (test.length() > 0) {
                        valueItem.with(test);
                    } else {
                        char currentChar = tokener.getChar();
                        if (currentChar != '<') {
                            valueItem.with(currentChar);
                        }
                    }
                    test.reset();
                }
                if (entity != null) {
                    creator.setValue(entity, "value", valueItem.toString(), "new");
                }
                stack.setValue(".", valueItem.toString());
                stack.popStack();
                tokener.skipEntity();
                return entity;
            }
            if (tokener.getCurrentChar() == '<') {
                Object child;
                do {
                    if ((valueItem = this.parseEntity(tokener, map)) == null) {
                        if (tokener.getCurrentChar() == '/' && (valueItem = tokener.nextToken(">")).equals(stack.getCurrentTag())) {
                            stack.popStack();
                            tokener.skip();
                        }
                        return entity;
                    }
                    if (!valueItem.isEmpty()) {
                        creator.setValue(entity, "value", valueItem.toString(), "new");
                        stack.setValue(".", valueItem.toString());
                        stack.popStack();
                        tokener.skipEntity();
                        return entity;
                    }
                    String childTag = stack.getCurrentTag();
                    child = this.parse(tokener, map);
                    if (child == null) continue;
                    creator.setValue(entity, childTag, child, CHILDREN);
                } while (child != null);
            }
        }
        return entity;
    }

    public CharacterBuffer parseEntity(XMLTokener tokener, MapEntity map) {
        IdMap idMap;
        SendableEntityCreator item;
        CharacterBuffer tag;
        CharacterBuffer valueItem = new CharacterBuffer();
        boolean isEmpty = true;
        block0: do {
            if (tokener.getCurrentChar() != '<') {
                tokener.nextString(valueItem, false, false, '<');
                if (!valueItem.isEmpty()) {
                    valueItem.trim();
                    isEmpty = valueItem.isEmpty();
                }
            }
            if ((tag = tokener.nextToken(TOKENSTOPWORDS)) == null) continue;
            for (String stopword : this.stopwords) {
                if (!tag.startsWith(stopword, 0, false)) continue;
                tokener.skipTo('>', false);
                tokener.skipTo('<', false);
                tag = null;
                continue block0;
            }
        } while (tag == null);
        if (tag.length() < 1) {
            return null;
        }
        if (tag.isEmpty() && isEmpty) {
            valueItem.reset();
        }
        if ((item = (idMap = this.getMap()).getCreator(tag.toString(), false)) != null && item instanceof SendableEntityCreatorTag) {
            this.addToStack((SendableEntityCreatorTag)item, tokener, tag, valueItem, map);
            return valueItem;
        }
        String startTag = tag.lastIndexOf('.') >= 0 ? tag.substring(0, tag.lastIndexOf('.')) : tag.toString();
        SimpleKeyValueList<String, SendableEntityCreatorTag> filter = new SimpleKeyValueList<String, SendableEntityCreatorTag>();
        for (int i = 0; i < idMap.getCreators().size(); ++i) {
            String key = idMap.getCreators().getKeyByIndex(i);
            SendableEntityCreator value = idMap.getCreators().getValueByIndex(i);
            if (!key.startsWith(startTag) || !(value instanceof SendableEntityCreatorTag)) continue;
            filter.put(key, (SendableEntityCreatorTag)value);
        }
        MapEntityStack stack = map.getStack();
        SendableEntityCreator defaultCreator = this.getDefaultFactory();
        SendableEntityCreatorTag creator = defaultCreator instanceof SendableEntityCreatorTag ? (SendableEntityCreatorTag)defaultCreator : new XMLEntityCreator();
        if (filter.size() < 1) {
            this.addToStack(creator, tokener, tag, valueItem, map);
            return valueItem;
        }
        StringBuilder sTag = new StringBuilder(startTag);
        while (filter.size() > 0) {
            this.addToStack(creator, tokener, tag, valueItem, map);
            this.parseAttribute(tokener, map);
            if (tokener.getCurrentChar() == '/') {
                stack.popStack();
                continue;
            }
            tokener.skip();
            if (tokener.getCurrentChar() != '<') {
                tokener.nextString(valueItem, false, false, '<');
                if (!valueItem.isEmpty()) {
                    valueItem.trim();
                    Object entity = stack.getCurrentItem();
                    creator.setValue(entity, "value", valueItem.toString(), "new");
                }
            }
            creator = (item = idMap.getCreator((tag = tokener.nextToken(TOKENSTOPWORDS)).toString(), false)) instanceof SendableEntityCreatorTag ? (SendableEntityCreatorTag)item : (SendableEntityCreatorTag)defaultCreator;
            sTag.append('.').append(tag.toString());
            for (int i = filter.size() - 1; i >= 0; ++i) {
                String key = (String)filter.getKeyByIndex(i);
                if (key.equals(sTag.toString())) {
                    creator = (SendableEntityCreatorTag)filter.getValueByIndex(i);
                    this.addToStack(creator, tokener, tag, valueItem, map);
                    return valueItem;
                }
                if (key.startsWith(sTag.toString())) continue;
                filter.removePos(i);
            }
            this.addToStack(creator, tokener, tag, valueItem, map);
        }
        return valueItem;
    }

    @Override
    public Entity createLink(Entity parent, String property, String className, String id) {
        parent.put(property, id);
        return null;
    }

    protected Object addToStack(SendableEntityCreatorTag creator, XMLTokener tokener, CharacterBuffer tag, CharacterBuffer value, MapEntity map) {
        Object entity = creator.getSendableInstance(false);
        if (entity instanceof EntityList) {
            creator.setValue(entity, "value", value.toString(), "new");
            creator.setValue(entity, "tag", tag.toString(), "new");
        }
        map.getStack().withStack(tag.toString(), entity, creator);
        return entity;
    }

    @Override
    public Object transformValue(Object value, BaseItem reference) {
        return EntityUtil.valueToString(value, true, reference, SIMPLECONVERTER);
    }

    @Override
    public BaseItem encode(Object entity, MapEntity map) {
        return null;
    }

    public SendableEntityCreator getDefaultFactory() {
        return this.defaultFactory;
    }

    public XMLTokener withDefaultFactory(SendableEntityCreator defaultFactory) {
        this.defaultFactory = defaultFactory;
        return this;
    }

    @Override
    public boolean isChild(Object writeValue) {
        return writeValue instanceof BaseItem;
    }

    public XMLTokener withAllowQuote(boolean value) {
        this.isAllowQuote = value;
        return this;
    }

    @Override
    public XMLTokener withMap(IdMap map) {
        super.withMap(map);
        return this;
    }
}

