/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.event.MapEntry;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.XMLTokener;

public class XMLEntity
extends SimpleKeyValueList<String, Object>
implements Entity,
EntityList {
    public static final String PROPERTY_TAG = "tag";
    public static final String PROPERTY_VALUE = "value";
    private SimpleList<EntityList> children;
    public static final String START = "<";
    public static final String END = ">";
    private String tag;
    private String valueItem;

    public XMLEntity() {
        this.withAllowDuplicate(false);
    }

    public XMLEntity withValue(String value) {
        XMLTokener tokener = new XMLTokener();
        tokener.withBuffer(value);
        tokener.skipHeader();
        this.withValue(tokener);
        return this;
    }

    public XMLEntity withValue(Tokener tokener) {
        if (tokener != null) {
            tokener.parseToEntity(this);
        }
        return this;
    }

    @Override
    public SimpleList<EntityList> getChildren() {
        if (this.children == null) {
            this.children = new SimpleList();
        }
        return this.children;
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public XMLEntity with(Object ... values) {
        if (values == null || values.length < 1) {
            return this;
        }
        if (values[0] instanceof String) {
            if (values.length == 1) {
                this.setValueItem((String)values[0]);
            }
        } else if (values.length % 2 == 1) {
            for (Object item : values) {
                if (!(item instanceof EntityList)) continue;
                this.getChildren().add((EntityList)item);
            }
            return this;
        }
        super.with(values);
        return this;
    }

    public XMLEntity withChild(EntityList value) {
        this.getChildren().add(value);
        return this;
    }

    @Override
    public EntityList getChild(String value, boolean recursiv) {
        if (value == null) {
            return null;
        }
        if (this.children != null) {
            for (EntityList entity : this.children) {
                EntityList child;
                if (!(entity instanceof XMLEntity)) continue;
                XMLEntity item = (XMLEntity)entity;
                if (value.equals(item.getTag())) {
                    return entity;
                }
                if (!recursiv || (child = item.getChild(value, recursiv)) == null) continue;
                return child;
            }
        }
        if (recursiv) {
            return null;
        }
        XMLEntity item = new XMLEntity().setType(value);
        this.with(item);
        return item;
    }

    public SimpleList<Entity> getChildren(String key, String value) {
        SimpleList<Entity> children = new SimpleList<Entity>();
        for (EntityList entity : this.getChildren()) {
            Entity item;
            if (entity instanceof Entity || !value.equalsIgnoreCase((item = (Entity)((Object)entity)).getString(key))) continue;
            children.add(item);
        }
        return children;
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        return this.valueItem;
    }

    @Override
    public boolean setValueItem(Object value) {
        this.valueItem = value instanceof String ? (String)value : "" + value;
        return true;
    }

    @Override
    public String toString() {
        return this.parseItem(new EntityStringConverter());
    }

    @Override
    public String toString(int indentFactor) {
        return this.parseItem(new EntityStringConverter(indentFactor));
    }

    @Override
    protected String parseItem(EntityStringConverter converter) {
        CharacterBuffer sb = new CharacterBuffer().with(converter.getPrefixFirst());
        if (this.getTag() != null) {
            sb.with(START, this.getTag());
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object value = this.getValueByIndex(i);
            if (value == null) continue;
            sb.with(" ", (CharSequence)this.get(i), "=", EntityUtil.quote(value.toString()));
        }
        this.toStringChildren(sb, converter);
        return sb.toString();
    }

    protected void toStringChildren(CharacterBuffer sb, EntityStringConverter converter) {
        if (this.children != null && this.children.size() > 0) {
            if (this.getTag() != null) {
                sb.with(END);
            }
            converter.add();
            for (EntityList child : this.children) {
                sb.with(child.toString(converter));
            }
            converter.minus();
            sb.with(converter.getPrefix());
            if (this.getTag() != null) {
                sb.with("</", this.getTag(), END);
            }
        } else if (this.valueItem != null) {
            if (this.getTag() != null) {
                sb.with(END);
            }
            sb.with(this.valueItem);
            if (this.getTag() != null) {
                sb.with("</", this.getTag(), END);
            }
        } else if (this.getTag() != null) {
            sb.with("/>");
        }
    }

    public XMLEntity withCloseTag() {
        if (this.valueItem == null) {
            this.valueItem = "";
        }
        return this;
    }

    public MapEntry getNewEntity() {
        return new MapEntry();
    }

    @Override
    public XMLEntity getNewList(boolean keyValue) {
        return new XMLEntity();
    }

    public static XMLEntity TAG(String tag) {
        return new XMLEntity().setType(tag);
    }

    public XMLEntity withKeyValue(Object key, Object value) {
        super.withKeyValue(key, value);
        return this;
    }

    @Override
    public XMLEntity without(String key) {
        this.remove(key);
        return this;
    }

    @Override
    public boolean has(String key) {
        return this.containsKey(key);
    }

    public XMLEntity withValueItem(String value) {
        this.setValueItem(value);
        return this;
    }

    @Override
    public BaseItem withValue(Buffer values) {
        new XMLTokener().withBuffer(values).parseToEntity(this);
        return this;
    }

    @Override
    public XMLEntity setType(String value) {
        this.tag = value;
        return this;
    }
}

