/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.sort;

import de.uniks.networkparser.EntityValueFactory;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.sort.SortingDirection;
import java.util.Comparator;

public class EntityComparator<V>
implements Comparator<V> {
    public static final String IDMAP = "%idmap%";
    public static final String HASHCODE = "%hashcode%";
    public static final String VALUES = "%values%";
    public static final String LIST = "%list%";
    private SortingDirection direction = SortingDirection.ASC;
    private String column = "%idmap%";
    private IdMap map;
    private EntityValueFactory cellCreator = new EntityValueFactory();
    private SimpleList<Object> owner;
    protected SendableEntityCreator creator;

    public EntityComparator<V> withTableList(SimpleList<Object> value) {
        this.owner = value;
        this.column = LIST;
        return this;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.direction.getDirection() * this.compareValue(o2, o1);
    }

    public int compareValue(Object o1, Object o2) {
        if (VALUES.equals(this.column)) {
            return this.checkValues(o1, o2);
        }
        if (this.map != null) {
            this.creator = this.map.getCreatorClass(o1);
            SendableEntityCreator c2 = this.map.getCreatorClass(o2);
            if (this.creator != c2) {
                this.creator = null;
            }
        }
        if (this.creator == null) {
            return this.checkIntern(o1, o2);
        }
        Object v1 = this.cellCreator.getCellValue(o1, this.creator, this.column);
        Object v2 = this.cellCreator.getCellValue(o2, this.creator, this.column);
        if (v1 == null) {
            if (v2 == null) {
                return this.checkIntern(o1, o2);
            }
            return this.checkValues(v1, v2);
        }
        return this.checkValues(v2, v1) * -1;
    }

    private int checkValues(Object v1, Object v2) {
        if (v1 instanceof String) {
            String valueA = (String)v1;
            if (v2 != null) {
                String valueB = (String)v2;
                return valueB.compareTo(valueA);
            }
        } else {
            if (v1 instanceof Integer) {
                Integer valueB;
                int value;
                Integer valueA = (Integer)v1;
                if (v2 != null && (value = (valueB = (Integer)v2).compareTo(valueA)) < 1) {
                    return -1;
                }
                return 1;
            }
            if (v1 instanceof Long) {
                Long valueB;
                int value;
                Long valueA = (Long)v1;
                if (v2 != null && (value = (valueB = (Long)v2).compareTo(valueA)) < 1) {
                    return -1;
                }
            } else if (v1 instanceof Boolean) {
                int value;
                Boolean valueA = (Boolean)v1;
                Boolean valueB = (Boolean)v2;
                if (valueB != null && (value = valueB.compareTo(valueA)) < 1) {
                    return -1;
                }
            }
        }
        return 1;
    }

    private int checkIntern(Object o1, Object o2) {
        if (o2 == null) {
            if (o1 == null) {
                return 0;
            }
            return -1;
        }
        if (o1 == null) {
            return -1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        if (LIST.equalsIgnoreCase(this.column) && this.owner != null) {
            return this.owner.indexOf(o1) - this.owner.indexOf(o2);
        }
        if (IDMAP.equalsIgnoreCase(this.column) && this.map != null) {
            String v1 = this.map.getId(o1);
            String v2 = this.map.getId(o2);
            return v1.compareTo(v2);
        }
        if (o1.hashCode() < o2.hashCode()) {
            return 1;
        }
        return -1;
    }

    public SortingDirection getDirection() {
        return this.direction;
    }

    public EntityComparator<V> withDirection(SortingDirection value) {
        this.direction = value;
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public EntityComparator<V> withColumn(String value) {
        this.column = value;
        return this;
    }

    public EntityComparator<V> withMap(IdMap value) {
        this.map = value;
        return this;
    }

    public IdMap getMap() {
        return this.map;
    }

    public EntityValueFactory getCellCreator() {
        return this.cellCreator;
    }

    public EntityComparator<V> withCellCreator(EntityValueFactory value) {
        this.cellCreator = value;
        return this;
    }

    public SortingDirection changeDirection() {
        this.direction = this.direction.changeDirection();
        return this.direction;
    }
}

