/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;
import java.beans.PropertyChangeEvent;

public class Between
implements UpdateListener,
SendableEntityCreator {
    public static final String FROM = "from";
    public static final String TO = "to";
    private double fromValue;
    private double toValue;

    public Between withRange(double from, double to) {
        this.fromValue = from;
        this.toValue = to;
        return this;
    }

    public Between withFrom(double from) {
        this.fromValue = from;
        return this;
    }

    public Between withTo(double to) {
        this.toValue = to;
        return this;
    }

    public double getFrom() {
        return this.fromValue;
    }

    public double getTo() {
        return this.toValue;
    }

    @Override
    public boolean update(Object evt) {
        PropertyChangeEvent event = (PropertyChangeEvent)evt;
        if (event.getSource() instanceof Double) {
            return (Double)event.getSource() >= this.fromValue && (Double)event.getSource() <= this.toValue;
        }
        if (event.getSource() instanceof Integer) {
            return (double)((Integer)event.getSource()).intValue() >= this.fromValue && (double)((Integer)event.getSource()).intValue() <= this.toValue;
        }
        return false;
    }

    @Override
    public String[] getProperties() {
        return new String[]{FROM, TO};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new Between();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (FROM.equalsIgnoreCase(attribute)) {
            return ((Between)entity).getFrom();
        }
        if (TO.equalsIgnoreCase(attribute)) {
            return ((Between)entity).getTo();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (FROM.equalsIgnoreCase(attribute)) {
            ((Between)entity).withFrom((Double)value);
            return true;
        }
        if (TO.equalsIgnoreCase(attribute)) {
            ((Between)entity).withTo((Double)value);
            return true;
        }
        return false;
    }
}

