/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes.checksum;

import de.uniks.networkparser.bytes.checksum.CRC;

public abstract class CRCTable
extends CRC {
    protected int[] crc_table = this.getGenTable();

    public int[] getGenTable() {
        int[] result = new int[256];
        int order = this.getOrder();
        long topBit = 1L << order - 1;
        long widthMask = (1 << order - 1) - 1 << 1 | 1;
        int polynom = this.getPolynom();
        boolean isReflect = this.isReflect();
        int i = 0;
        while (i < 256) {
            result[i] = i;
            if (isReflect) {
                result[i] = CRCTable.Reflect(i, 8);
            }
            result[i] = result[i] << order - 8;
            for (int j = 0; j < 8; ++j) {
                if (((long)result[i] & topBit) != 0L) {
                    result[i] = result[i] << 1 ^ polynom;
                    continue;
                }
                int n = i;
                result[n] = result[n] << 1;
            }
            if (isReflect) {
                result[i] = CRCTable.Reflect(result[i], order);
            }
            int n = i++;
            result[n] = (int)((long)result[n] & widthMask);
        }
        return result;
    }

    private static int Reflect(int data, int numBits) {
        int temp = data;
        for (int i = 0; i < numBits; ++i) {
            long bitMask = 1L << numBits - 1 - i;
            data = ((long)temp & 1L) != 0L ? (int)((long)data | bitMask) : (int)((long)data & (bitMask ^ 0xFFFFFFFFFFFFFFFFL));
            temp >>= 1;
        }
        return data;
    }
}

