/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.bytes.BitValue;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.list.SimpleList;

public class BitEntity
extends SimpleList<BitValue>
implements ByteItem {
    public static final byte BIT_STRING = 83;
    public static final byte BIT_NUMBER = 78;
    public static final byte BIT_BYTE = 66;
    public static final byte BIT_REFERENCE = 82;
    protected String property;
    protected byte typ = (byte)66;
    protected int orientation = 1;
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_TYP = "typ";
    public static final String PROPERTY_ORIENTATION = "orientation";

    public BitEntity with(String property, byte typ) {
        this.property = property;
        this.typ = typ;
        return this;
    }

    public BitEntity withStartLen(int start, int len) {
        this.add(new BitValue(start, len));
        return this;
    }

    public BitEntity withOrientation(int orientation) {
        this.orientation = orientation;
        return this;
    }

    public String getPropertyName() {
        return this.property;
    }

    @Override
    public byte getTyp() {
        return this.typ;
    }

    public boolean isTyp(byte ... referenceTyp) {
        if (referenceTyp == null) {
            return false;
        }
        for (byte typ : referenceTyp) {
            if (this.typ != typ) continue;
            return true;
        }
        return false;
    }

    public boolean set(String attribute, Object value) {
        if (PROPERTY_PROPERTY.equalsIgnoreCase(attribute)) {
            this.property = "" + value;
            return true;
        }
        if (PROPERTY_TYP.equalsIgnoreCase(attribute)) {
            this.typ = (Byte)value;
            return true;
        }
        if (PROPERTY_ORIENTATION.equalsIgnoreCase(attribute)) {
            this.orientation = Integer.parseInt("" + value);
            return true;
        }
        return false;
    }

    public Object get(String attrName) {
        if (attrName == null) {
            return null;
        }
        int pos = attrName.indexOf(".");
        if (pos > 0) {
            attrName = attrName.substring(0, pos);
        }
        if (PROPERTY_PROPERTY.equalsIgnoreCase(attrName)) {
            return this.property;
        }
        if (PROPERTY_TYP.equalsIgnoreCase(attrName)) {
            return this.typ;
        }
        if (PROPERTY_ORIENTATION.equalsIgnoreCase(attrName)) {
            return this.orientation;
        }
        return null;
    }

    @Override
    public ByteBuffer getBytes(boolean isDynamic) {
        return null;
    }

    @Override
    public void writeBytes(ByteBuffer buffer, boolean isDynamic, boolean last, boolean isPrimitive) {
    }

    @Override
    public int calcLength(boolean isDynamic, boolean isLast) {
        return 0;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public String toString(Converter converter) {
        return this.toString();
    }

    @Override
    public String toString(ByteConverter converter, boolean isDynamic) {
        return this.toString();
    }

    @Override
    public BitEntity with(Object ... values) {
        if (values == null) {
            return this;
        }
        for (Object value : values) {
            if (value instanceof Byte) {
                this.typ = (byte)66;
                this.property = "" + value;
                continue;
            }
            if (value instanceof Integer) {
                this.typ = (byte)78;
                this.property = "" + value;
                continue;
            }
            if (value instanceof BitValue) {
                this.add((BitValue)value);
                continue;
            }
            this.typ = (byte)83;
            this.property = "" + value;
        }
        return this;
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public BitEntity getNewList(boolean keyValue) {
        return new BitEntity();
    }

    @Override
    public boolean remove(Object value) {
        return this.removeByObject(value) >= 0;
    }
}

