/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.json;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.list.AbstractList;
import de.uniks.networkparser.list.SimpleKeyValueList;

public class JsonObject
extends SimpleKeyValueList<String, Object>
implements Entity {
    public static final String START = "{";
    public static final String END = "}";

    public JsonObject() {
        this.withAllowDuplicate(false);
    }

    public JsonArray getJsonArray(String key) {
        Object object = this.get(key);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        if (object instanceof String) {
            return new JsonArray().withValue("" + object);
        }
        throw new RuntimeException("JsonObject[" + EntityUtil.quote(key) + "] is not a JsonArray.");
    }

    public JsonObject getJsonObject(String key) {
        Object object = this.get(key);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        if (object instanceof String) {
            return new JsonObject().withValue("" + object);
        }
        throw new RuntimeException("JsonObject[" + EntityUtil.quote(key) + "] is not a JsonObject.");
    }

    @Override
    public long getLong(String key) {
        Object object = this.get(key);
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Integer) {
            return 0L + (long)((Integer)object).intValue();
        }
        throw new RuntimeException("JsonObject[" + EntityUtil.quote(key) + "] is not a JsonObject.");
    }

    @Override
    public String toString() {
        return this.parseItem(new EntityStringConverter());
    }

    @Override
    public String toString(int indentFactor) {
        return this.parseItem(new EntityStringConverter(indentFactor));
    }

    @Override
    protected String parseItem(EntityStringConverter converter) {
        int length = this.size();
        if (length == 0) {
            return "{}";
        }
        if (!this.isVisible()) {
            return START + this.size() + " values}";
        }
        converter.add();
        StringBuilder sb = new StringBuilder(START);
        if (length > 1) {
            sb.append(converter.getPrefix());
        }
        sb.append(EntityUtil.quote(((String)this.get(0)).toString()));
        sb.append(":");
        sb.append(EntityUtil.valueToString(this.getValueByIndex(0), false, this, converter));
        for (int i = 1; i < length; ++i) {
            sb.append(",");
            sb.append(converter.getPrefix());
            sb.append(EntityUtil.quote(((String)this.get(i)).toString()));
            sb.append(":");
            sb.append(EntityUtil.valueToString(this.getValueByIndex(i), false, this, converter));
        }
        converter.minus();
        if (length > 1) {
            sb.append(converter.getPrefix());
        }
        sb.append(END);
        return sb.toString();
    }

    public JsonObject withValue(String ... values) {
        if (values.length % 2 == 0) {
            for (int z = 0; z < values.length; z += 2) {
                if (values[z + 1] == null) continue;
                this.put(values[z], values[z + 1]);
            }
            return this;
        }
        if (values.length > 0) {
            new JsonTokener().withBuffer(values[0]).parseToEntity(this);
        }
        return this;
    }

    @Override
    public JsonObject withValue(Buffer values) {
        new JsonTokener().withBuffer(values).parseToEntity(this);
        return this;
    }

    public JsonObject withTokener(Tokener x) {
        x.parseToEntity(this);
        return this;
    }

    public JsonObject withEntity(SimpleKeyValueList<?, ?> entity) {
        new JsonTokener().parseToEntity(this, entity);
        return this;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        if (keyValue) {
            return new JsonObject();
        }
        return new JsonArray();
    }

    @Override
    public boolean has(String key) {
        return this.containsKey(key);
    }

    public JsonObject withKeyValue(Object key, Object value) {
        super.withKeyValue(key, value);
        return this;
    }

    public JsonObject addToList(String key, Object value) {
        Object object = this.get(key);
        if (object == null) {
            this.put(key, value instanceof AbstractList ? this.getNewList(true).with(value) : value);
        } else if (object instanceof AbstractList) {
            ((AbstractList)object).with(new Object[]{value});
        } else {
            this.put(key, this.getNewList(false).with(object, value));
        }
        return this;
    }

    public JsonObject withKeyValue(String key, Object value) {
        if (value != null) {
            int index = this.indexOf(key);
            if (index >= 0) {
                this.setValueItem(key, value);
                return this;
            }
            super.withKeyValue(key, value);
        }
        return this;
    }

    @Override
    public Entity without(String key) {
        this.remove(key);
        return this;
    }

    public static JsonObject create(String value) {
        return new JsonObject().withValue(value);
    }

    @Override
    public boolean setValueItem(Object value) {
        this.add("value", value);
        return true;
    }

    @Override
    public BaseItem getChild(String label, boolean recursiv) {
        JsonObject child;
        if (label == null || this.size() < 1) {
            return null;
        }
        Object item = this.get(label);
        if (item instanceof JsonObject) {
            child = (JsonObject)item;
        } else {
            child = new JsonObject();
            this.put(label, child);
        }
        return child;
    }

    @Override
    public JsonObject setType(String type) {
        this.add("class", type);
        return this;
    }
}

