/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.converter.ByteConverter;

public class ByteConverterBinary
extends ByteConverter {
    public static String toString(byte value) {
        ByteConverterBinary converter = new ByteConverterBinary();
        return converter.toString(new ByteBuffer().with(value));
    }

    public static String toString(int value) {
        return ByteConverterBinary.toString((byte)value);
    }

    @Override
    public String toString(ByteBuffer values) {
        StringBuilder sb = new StringBuilder();
        for (int z = 0; z < values.length(); ++z) {
            int number = values.byteAt(z);
            char[] bits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
            int i = 7;
            if (number < 0) {
                number += 256;
            }
            while (number != 0) {
                bits[i] = (char)(48 + number % 2);
                number = (byte)(number / 2);
                --i;
            }
            sb.append(new String(bits));
        }
        return sb.toString();
    }

    @Override
    public byte[] decode(String value) {
        byte[] out = new byte[value.length() / 8];
        int n = value.length();
        int i = 0;
        while (i < n) {
            int charText = 0;
            for (int z = 0; z < 8; ++z) {
                charText <<= (byte)(value.charAt(i++) - 48);
            }
            out[i / 8] = (byte)charText;
        }
        return out;
    }
}

