/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.util.ClazzSet;

public abstract class GraphModel
extends GraphEntity {
    private String defaultAuthorName;

    public ClazzSet getClazzes() {
        ClazzSet collection = new ClazzSet();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Clazz) {
            collection.add((Clazz)this.children);
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet items = (GraphSimpleSet)this.children;
            for (GraphMember child : items) {
                if (!(child instanceof Clazz)) continue;
                collection.add((Clazz)child);
            }
        }
        return collection;
    }

    public Clazz createClazz(String name) {
        Clazz clazz = new Clazz().with(name);
        clazz.setClassModel(this);
        return clazz;
    }

    public GraphModel with(Clazz ... values) {
        super.withChildren(values);
        return this;
    }

    public GraphModel without(Clazz ... values) {
        super.without(values);
        return this;
    }

    @Override
    public GraphModel with(Association ... values) {
        super.with(values);
        return this;
    }

    @Override
    public GraphModel with(String name) {
        super.with(name);
        return this;
    }

    public String getAuthorName() {
        return this.defaultAuthorName;
    }

    public boolean setAuthorName(String value) {
        if (value != null && !value.equals(this.defaultAuthorName) || value == null && this.defaultAuthorName != null) {
            this.defaultAuthorName = value;
            return true;
        }
        return false;
    }

    public GraphModel withAuthorName(String value) {
        this.setAuthorName(value);
        return this;
    }

    public GraphModel generate() {
        return this;
    }

    public GraphModel generate(String rootDir) {
        return this;
    }

    public boolean dumpHTML(String diagramName) {
        return false;
    }
}

