/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes.qr;

import de.uniks.networkparser.bytes.qr.BitArray;
import de.uniks.networkparser.bytes.qr.BitMatrix;
import de.uniks.networkparser.bytes.qr.BitMatrixParser;
import de.uniks.networkparser.bytes.qr.ByteMatrix;
import de.uniks.networkparser.bytes.qr.DataBlock;
import de.uniks.networkparser.bytes.qr.DecodedBitStreamParser;
import de.uniks.networkparser.bytes.qr.DecoderResult;
import de.uniks.networkparser.bytes.qr.ErrorCorrectionLevel;
import de.uniks.networkparser.bytes.qr.GenericGF;
import de.uniks.networkparser.bytes.qr.MaskUtil;
import de.uniks.networkparser.bytes.qr.MatrixUtil;
import de.uniks.networkparser.bytes.qr.Mode;
import de.uniks.networkparser.bytes.qr.QRCode;
import de.uniks.networkparser.bytes.qr.ReedSolomon;
import de.uniks.networkparser.bytes.qr.Version;
import java.io.UnsupportedEncodingException;

public class QRTokener {
    private final ReedSolomon rsDecoder = new ReedSolomon(GenericGF.QR_CODE_FIELD_256);
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    public DecoderResult decode(boolean[][] image) throws Exception {
        int dimension = image.length;
        BitMatrix bits = new BitMatrix(dimension);
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < dimension; ++j) {
                if (!image[i][j]) continue;
                bits.set(j, i);
            }
        }
        return this.decode(bits);
    }

    public DecoderResult decode(byte[][] bytes) throws Exception {
        int dimension = bytes.length;
        BitMatrix bits = new BitMatrix(dimension);
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < dimension; ++j) {
                if (bytes[i][j] <= 0) continue;
                bits.set(j, i);
            }
        }
        return this.decode(bits);
    }

    public DecoderResult decode(BitMatrix bits) throws Exception {
        BitMatrixParser parser = new BitMatrixParser(bits);
        RuntimeException exception = null;
        DecoderResult result = null;
        try {
            return this.decode(parser);
        }
        catch (RuntimeException e) {
            block4: {
                exception = e;
                try {
                    parser.remask();
                    parser.setMirror(true);
                    parser.readVersion();
                    parser.readFormatInformation();
                    parser.mirror();
                    result = this.decode(parser);
                }
                catch (Exception e2) {
                    if (exception == null) break block4;
                    throw exception;
                }
            }
            return result;
        }
    }

    private DecoderResult decode(BitMatrixParser parser) throws Exception {
        Version version = parser.readVersion();
        ErrorCorrectionLevel ecLevel = parser.readFormatInformation().getErrorCorrectionLevel();
        byte[] codewords = parser.readCodewords();
        DataBlock[] dataBlocks = DataBlock.getDataBlocks(codewords, version, ecLevel);
        if (dataBlocks == null) {
            return null;
        }
        int totalBytes = 0;
        for (DataBlock dataBlock : dataBlocks) {
            totalBytes += dataBlock.getNumDataCodewords();
        }
        byte[] resultBytes = new byte[totalBytes];
        int resultOffset = 0;
        for (DataBlock dataBlock : dataBlocks) {
            byte[] codewordBytes = dataBlock.getCodewords();
            int numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            for (int i = 0; i < numDataCodewords; ++i) {
                resultBytes[resultOffset++] = codewordBytes[i];
            }
        }
        return DecodedBitStreamParser.decode(resultBytes, version, ecLevel);
    }

    private void correctErrors(byte[] codewordBytes, int numDataCodewords) {
        int numCodewords = codewordBytes.length;
        int[] codewordsInts = new int[numCodewords];
        for (int i = 0; i < numCodewords; ++i) {
            codewordsInts[i] = codewordBytes[i] & 0xFF;
        }
        int numECCodewords = codewordBytes.length - numDataCodewords;
        try {
            this.rsDecoder.decode(codewordsInts, numECCodewords);
        }
        catch (Exception ignored) {
            throw new RuntimeException("ChecksumInstance");
        }
        for (int i = 0; i < numDataCodewords; ++i) {
            codewordBytes[i] = (byte)codewordsInts[i];
        }
    }

    private static int calculateMaskPenalty(ByteMatrix matrix) {
        return MaskUtil.applyMaskPenaltyRule1(matrix) + MaskUtil.applyMaskPenaltyRule2(matrix) + MaskUtil.applyMaskPenaltyRule3(matrix) + MaskUtil.applyMaskPenaltyRule4(matrix);
    }

    public QRCode encode(String content, ErrorCorrectionLevel ecLevel) {
        String encoding = DEFAULT_BYTE_MODE_ENCODING;
        Mode mode = QRTokener.chooseMode(content, encoding);
        BitArray headerBits = new BitArray();
        if (mode != Mode.BYTE || !DEFAULT_BYTE_MODE_ENCODING.equals(encoding)) {
            // empty if block
        }
        QRTokener.appendModeInfo(mode, headerBits);
        BitArray dataBits = new BitArray();
        QRTokener.appendBytes(content, mode, dataBits, encoding);
        int provisionalBitsNeeded = headerBits.getSize() + mode.getCharacterCountBits(Version.getVersionForNumber(1)) + dataBits.getSize();
        Version provisionalVersion = QRTokener.chooseVersion(provisionalBitsNeeded, ecLevel);
        int bitsNeeded = headerBits.getSize() + mode.getCharacterCountBits(provisionalVersion) + dataBits.getSize();
        Version version = QRTokener.chooseVersion(bitsNeeded, ecLevel);
        BitArray headerAndDataBits = new BitArray();
        headerAndDataBits.appendBitArray(headerBits);
        int numLetters = mode == Mode.BYTE ? dataBits.getSizeInBytes() : content.length();
        QRTokener.appendLengthInfo(numLetters, version, mode, headerAndDataBits);
        headerAndDataBits.appendBitArray(dataBits);
        Version.ECB ecBlock = version.getECBlocksForLevel(ecLevel);
        int numDataBytes = version.getTotalCodewords() - ecBlock.getTotalECCodewords();
        QRTokener.terminateBits(numDataBytes, headerAndDataBits);
        BitArray finalBits = QRTokener.interleaveWithECBytes(headerAndDataBits, version.getTotalCodewords(), numDataBytes, ecBlock.getNumBlocks());
        QRCode qrCode = new QRCode();
        qrCode.setECLevel(ecLevel);
        qrCode.setMode(mode);
        qrCode.setVersion(version);
        int dimension = version.getDimensionForVersion();
        ByteMatrix matrix = new ByteMatrix(dimension, dimension);
        int maskPattern = QRTokener.chooseMaskPattern(finalBits, ecLevel, version, matrix);
        qrCode.setMaskPattern(maskPattern);
        MatrixUtil.buildMatrix(finalBits, ecLevel, version, maskPattern, matrix);
        qrCode.setMatrix(matrix);
        return qrCode;
    }

    static int getAlphanumericCode(int code) {
        if (code < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[code];
        }
        return -1;
    }

    private static Mode chooseMode(String content, String encoding) {
        if ("Shift_JIS".equals(encoding) && QRTokener.isOnlyDoubleByteKanji(content)) {
            return Mode.KANJI;
        }
        boolean hasNumeric = false;
        boolean hasAlphanumeric = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c >= '0' && c <= '9') {
                hasNumeric = true;
                continue;
            }
            if (QRTokener.getAlphanumericCode(c) != -1) {
                hasAlphanumeric = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (hasAlphanumeric) {
            return Mode.ALPHANUMERIC;
        }
        if (hasNumeric) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String content) {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException ignored) {
            return false;
        }
        int length = bytes.length;
        if (length % 2 != 0) {
            return false;
        }
        for (int i = 0; i < length; i += 2) {
            int byte1 = bytes[i] & 0xFF;
            if (byte1 >= 129 && byte1 <= 159 || byte1 >= 224 && byte1 <= 235) continue;
            return false;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bits, ErrorCorrectionLevel ecLevel, Version version, ByteMatrix matrix) throws RuntimeException {
        int minPenalty = Integer.MAX_VALUE;
        int bestMaskPattern = -1;
        for (int maskPattern = 0; maskPattern < 8; ++maskPattern) {
            MatrixUtil.buildMatrix(bits, ecLevel, version, maskPattern, matrix);
            int penalty = QRTokener.calculateMaskPenalty(matrix);
            if (penalty >= minPenalty) continue;
            minPenalty = penalty;
            bestMaskPattern = maskPattern;
        }
        return bestMaskPattern;
    }

    private static Version chooseVersion(int numInputBits, ErrorCorrectionLevel ecLevel) {
        for (int versionNum = 1; versionNum <= 40; ++versionNum) {
            int totalInputBytes;
            int numEcBytes;
            int numDataBytes;
            Version version = Version.getVersionForNumber(versionNum);
            int numBytes = version.getTotalCodewords();
            Version.ECB ecBlocks = version.getECBlocksForLevel(ecLevel);
            if (ecBlocks == null || (numDataBytes = numBytes - (numEcBytes = ecBlocks.getTotalECCodewords())) < (totalInputBytes = (numInputBits + 7) / 8)) continue;
            return version;
        }
        throw new RuntimeException("Data too big");
    }

    static void terminateBits(int numDataBytes, BitArray bits) {
        int capacity = numDataBytes * 8;
        if (bits.getSize() > capacity) {
            throw new RuntimeException("data bits cannot fit in the QR Code" + bits.getSize() + " > " + capacity);
        }
        for (int i = 0; i < 4 && bits.getSize() < capacity; ++i) {
            bits.appendBit(false);
        }
        int numBitsInLastByte = bits.getSize() & 7;
        if (numBitsInLastByte > 0) {
            for (int i = numBitsInLastByte; i < 8; ++i) {
                bits.appendBit(false);
            }
        }
        int numPaddingBytes = numDataBytes - bits.getSizeInBytes();
        for (int i = 0; i < numPaddingBytes; ++i) {
            bits.appendBits((i & 1) == 0 ? 236 : 17, 8);
        }
        if (bits.getSize() != capacity) {
            throw new RuntimeException("Bits size does not equal capacity");
        }
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int numTotalBytes, int numDataBytes, int numRSBlocks, int blockID, int[] numDataBytesInBlock, int[] numECBytesInBlock) throws RuntimeException {
        if (blockID >= numRSBlocks) {
            throw new RuntimeException("Block ID too large");
        }
        int numRsBlocksInGroup2 = numTotalBytes % numRSBlocks;
        int numRsBlocksInGroup1 = numRSBlocks - numRsBlocksInGroup2;
        int numTotalBytesInGroup1 = numTotalBytes / numRSBlocks;
        int numDataBytesInGroup1 = numDataBytes / numRSBlocks;
        int numEcBytesInGroup1 = numTotalBytesInGroup1 - numDataBytesInGroup1;
        int numTotalBytesInGroup2 = numTotalBytesInGroup1 + 1;
        int numDataBytesInGroup2 = numDataBytesInGroup1 + 1;
        int numEcBytesInGroup2 = numTotalBytesInGroup2 - numDataBytesInGroup2;
        if (numEcBytesInGroup1 != numEcBytesInGroup2) {
            throw new RuntimeException("EC bytes mismatch");
        }
        if (numRSBlocks != numRsBlocksInGroup1 + numRsBlocksInGroup2) {
            throw new RuntimeException("RS blocks mismatch");
        }
        if (numTotalBytes != (numDataBytesInGroup1 + numEcBytesInGroup1) * numRsBlocksInGroup1 + (numDataBytesInGroup2 + numEcBytesInGroup2) * numRsBlocksInGroup2) {
            throw new RuntimeException("Total bytes mismatch");
        }
        if (blockID < numRsBlocksInGroup1) {
            numDataBytesInBlock[0] = numDataBytesInGroup1;
            numECBytesInBlock[0] = numEcBytesInGroup1;
        } else {
            numDataBytesInBlock[0] = numDataBytesInGroup2;
            numECBytesInBlock[0] = numEcBytesInGroup2;
        }
    }

    static BitArray interleaveWithECBytes(BitArray bits, int numTotalBytes, int numDataBytes, int numRSBlocks) throws RuntimeException {
        int i;
        if (bits.getSizeInBytes() != numDataBytes) {
            throw new RuntimeException("Number of bits and data bytes does not match");
        }
        int dataBytesOffset = 0;
        int maxNumDataBytes = 0;
        int maxNumEcBytes = 0;
        byte[][] datablocks = new byte[numRSBlocks][0];
        byte[][] errorblocks = new byte[numRSBlocks][0];
        for (int i2 = 0; i2 < numRSBlocks; ++i2) {
            int[] numDataBytesInBlock = new int[1];
            int[] numEcBytesInBlock = new int[1];
            QRTokener.getNumDataBytesAndNumECBytesForBlockID(numTotalBytes, numDataBytes, numRSBlocks, i2, numDataBytesInBlock, numEcBytesInBlock);
            int size = numDataBytesInBlock[0];
            byte[] dataBytes = new byte[size];
            bits.toBytes(8 * dataBytesOffset, dataBytes, 0, size);
            byte[] ecBytes = QRTokener.generateECBytes(dataBytes, numEcBytesInBlock[0]);
            datablocks[i2] = dataBytes;
            errorblocks[i2] = ecBytes;
            maxNumDataBytes = Math.max(maxNumDataBytes, size);
            maxNumEcBytes = Math.max(maxNumEcBytes, ecBytes.length);
            dataBytesOffset += numDataBytesInBlock[0];
        }
        if (numDataBytes != dataBytesOffset) {
            throw new RuntimeException("Data bytes does not match offset");
        }
        BitArray result = new BitArray();
        for (i = 0; i < maxNumDataBytes; ++i) {
            for (int z = 0; z < datablocks.length; ++z) {
                byte[] dataBytes = datablocks[z];
                if (i >= dataBytes.length) continue;
                result.appendBits(dataBytes[i], 8);
            }
        }
        for (i = 0; i < maxNumEcBytes; ++i) {
            for (int z = 0; z < errorblocks.length; ++z) {
                byte[] ecBytes = errorblocks[z];
                if (i >= ecBytes.length) continue;
                result.appendBits(ecBytes[i], 8);
            }
        }
        if (numTotalBytes != result.getSizeInBytes()) {
            throw new RuntimeException("Interleaving error: " + numTotalBytes + " and " + result.getSizeInBytes() + " differ.");
        }
        return result;
    }

    static byte[] generateECBytes(byte[] dataBytes, int numEcBytesInBlock) {
        int numDataBytes = dataBytes.length;
        int[] toEncode = new int[numDataBytes + numEcBytesInBlock];
        for (int i = 0; i < numDataBytes; ++i) {
            toEncode[i] = dataBytes[i] & 0xFF;
        }
        new ReedSolomon(GenericGF.QR_CODE_FIELD_256).encode(toEncode, numEcBytesInBlock);
        byte[] ecBytes = new byte[numEcBytesInBlock];
        for (int i = 0; i < numEcBytesInBlock; ++i) {
            ecBytes[i] = (byte)toEncode[numDataBytes + i];
        }
        return ecBytes;
    }

    static void appendModeInfo(Mode mode, BitArray bits) {
        bits.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int numLetters, Version version, Mode mode, BitArray bits) throws RuntimeException {
        int numBits = mode.getCharacterCountBits(version);
        if (numLetters >= 1 << numBits) {
            throw new RuntimeException(numLetters + " is bigger than " + ((1 << numBits) - 1));
        }
        bits.appendBits(numLetters, numBits);
    }

    static void appendBytes(String content, Mode mode, BitArray bits, String encoding) throws RuntimeException {
        if (mode == Mode.NUMERIC) {
            QRTokener.appendNumericBytes(content, bits);
        } else if (mode == Mode.ALPHANUMERIC) {
            QRTokener.appendAlphanumericBytes(content, bits);
        } else if (mode == Mode.BYTE) {
            QRTokener.append8BitBytes(content, bits, encoding);
        } else if (mode == Mode.KANJI) {
            QRTokener.appendKanjiBytes(content, bits);
        } else {
            throw new RuntimeException("Invalid mode: " + mode);
        }
    }

    static void appendNumericBytes(CharSequence content, BitArray bits) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int num2;
            int num1 = content.charAt(i) - 48;
            if (i + 2 < length) {
                num2 = content.charAt(i + 1) - 48;
                int num3 = content.charAt(i + 2) - 48;
                bits.appendBits(num1 * 100 + num2 * 10 + num3, 10);
                i += 3;
                continue;
            }
            if (i + 1 < length) {
                num2 = content.charAt(i + 1) - 48;
                bits.appendBits(num1 * 10 + num2, 7);
                i += 2;
                continue;
            }
            bits.appendBits(num1, 4);
            ++i;
        }
    }

    static void appendAlphanumericBytes(CharSequence content, BitArray bits) throws RuntimeException {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int code1 = QRTokener.getAlphanumericCode(content.charAt(i));
            if (code1 == -1) {
                throw new RuntimeException();
            }
            if (i + 1 < length) {
                int code2 = QRTokener.getAlphanumericCode(content.charAt(i + 1));
                if (code2 == -1) {
                    throw new RuntimeException();
                }
                bits.appendBits(code1 * 45 + code2, 11);
                i += 2;
                continue;
            }
            bits.appendBits(code1, 6);
            ++i;
        }
    }

    static void append8BitBytes(String content, BitArray bits, String encoding) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = content.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        for (byte b : bytes) {
            bits.appendBits(b, 8);
        }
    }

    static void appendKanjiBytes(String content, BitArray bits) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        int length = bytes.length;
        for (int i = 0; i < length; i += 2) {
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            int subtracted = -1;
            if (code >= 33088 && code <= 40956) {
                subtracted = code - 33088;
            } else if (code >= 57408 && code <= 60351) {
                subtracted = code - 49472;
            }
            if (subtracted == -1) {
                throw new RuntimeException("Invalid byte sequence");
            }
            int encoded = (subtracted >> 8) * 192 + (subtracted & 0xFF);
            bits.appendBits(encoded, 13);
        }
    }
}

