/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes.qr;

import de.uniks.networkparser.bytes.qr.BitMatrix;

abstract class DataMask {
    private static final DataMask[] DATA_MASKS = new DataMask[]{new DataMask000(), new DataMask001(), new DataMask010(), new DataMask011(), new DataMask100(), new DataMask101(), new DataMask110(), new DataMask111()};

    private DataMask() {
    }

    final void unmaskBitMatrix(BitMatrix bits, int dimension) {
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < dimension; ++j) {
                if (!this.isMasked(i, j)) continue;
                bits.flip(j, i);
            }
        }
    }

    abstract boolean isMasked(int var1, int var2);

    static DataMask forReference(int reference) {
        if (reference < 0 || reference > 7) {
            throw new IllegalArgumentException();
        }
        return DATA_MASKS[reference];
    }

    private static final class DataMask111
    extends DataMask {
        private DataMask111() {
        }

        @Override
        boolean isMasked(int i, int j) {
            return ((i + j & 1) + i * j % 3 & 1) == 0;
        }
    }

    private static final class DataMask110
    extends DataMask {
        private DataMask110() {
        }

        @Override
        boolean isMasked(int i, int j) {
            int temp = i * j;
            return ((temp & 1) + temp % 3 & 1) == 0;
        }
    }

    private static final class DataMask101
    extends DataMask {
        private DataMask101() {
        }

        @Override
        boolean isMasked(int i, int j) {
            int temp = i * j;
            return (temp & 1) + temp % 3 == 0;
        }
    }

    private static final class DataMask100
    extends DataMask {
        private DataMask100() {
        }

        @Override
        boolean isMasked(int i, int j) {
            return (i / 2 + j / 3 & 1) == 0;
        }
    }

    private static final class DataMask011
    extends DataMask {
        private DataMask011() {
        }

        @Override
        boolean isMasked(int i, int j) {
            return (i + j) % 3 == 0;
        }
    }

    private static final class DataMask010
    extends DataMask {
        private DataMask010() {
        }

        @Override
        boolean isMasked(int i, int j) {
            return j % 3 == 0;
        }
    }

    private static final class DataMask001
    extends DataMask {
        private DataMask001() {
        }

        @Override
        boolean isMasked(int i, int j) {
            return (i & 1) == 0;
        }
    }

    private static final class DataMask000
    extends DataMask {
        private DataMask000() {
        }

        @Override
        boolean isMasked(int i, int j) {
            return (i + j & 1) == 0;
        }
    }
}

