/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;

public abstract class BufferedBuffer
extends Buffer {
    protected int length;
    int start;

    public boolean back() {
        if (this.position > 0) {
            --this.position;
            return true;
        }
        return false;
    }

    public BufferedBuffer withPosition(int value) {
        this.position = value;
        return this;
    }

    @Override
    public int length() {
        return this.length;
    }

    public BufferedBuffer withLength(int value) {
        this.length = value;
        return this;
    }

    public abstract byte byteAt(int var1);

    public abstract char charAt(int var1);

    @Override
    public char getCurrentChar() {
        return this.charAt(this.position());
    }

    public abstract CharacterBuffer subSequence(int var1, int var2);

    @Override
    public BufferedBuffer withLookAHead(CharSequence lookahead) {
        if (lookahead == null) {
            return this;
        }
        this.withPosition(this.position() - lookahead.length() + 1);
        return this;
    }

    @Override
    public BufferedBuffer withLookAHead(char lookahead) {
        if (lookahead < '\u0000') {
            return this;
        }
        this.withPosition(this.position() - 1);
        return this;
    }

    @Override
    protected CharacterBuffer parseString(CharacterBuffer sc, boolean allowQuote, boolean nextStep, char ... quotes) {
        char c;
        if (quotes == null) {
            sc.with(this.getCurrentChar());
            return sc;
        }
        int startpos = this.position();
        char b = this.getCurrentChar();
        int quoteLen = quotes.length;
        block4: do {
            c = this.getChar();
            switch (c) {
                case '\u0000': {
                    c = '\u0000';
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (b != '\\') break;
                    if (c == '\\' && allowQuote) {
                        c = '\u0000';
                    }
                    if (!allowQuote) break;
                    b = c;
                    c = '\u0001';
                    continue block4;
                }
            }
            b = c;
            for (int i = 0; i < quoteLen; ++i) {
                if (c != quotes[i]) continue;
                c = '\u0000';
                continue block4;
            }
        } while (c != '\u0000');
        int endPos = this.position();
        if (nextStep) {
            this.skip();
        }
        sc.with(this.subSequence(startpos, endPos));
        return sc;
    }

    public String getNextString(int n) {
        int pos = 0;
        if (n < -1) {
            char[] chars = new char[n *= -1];
            while (pos < n) {
                chars[pos] = this.charAt(this.position() - (n - pos++));
            }
            return new String(chars);
        }
        if (n == -1) {
            n = this.length() - this.position();
        } else {
            if (n == 0) {
                return "";
            }
            if (this.position() + n > this.length()) {
                n = this.length() - this.position();
            }
        }
        char[] chars = new char[n];
        while (pos < n) {
            chars[pos] = this.charAt(this.position() + pos++);
        }
        return new String(chars);
    }

    @Override
    protected CharacterBuffer nextValue(char c, boolean allowDuppleMark) {
        int start = this.position();
        if (allowDuppleMark) {
            while (c >= ' ' && ",]}/\\\"[{;=# ".indexOf(c) < 0) {
                c = this.getChar();
            }
        } else {
            while (c >= ' ' && ",:]}/\\\"[{;=# ".indexOf(c) < 0) {
                c = this.getChar();
            }
        }
        CharacterBuffer sb = this.subSequence(start, this.position()).trim();
        return sb;
    }

    public String substring(int ... positions) {
        int start = positions[0];
        int end = -1;
        if (positions.length < 2) {
            end = this.length();
            if (start == -1) {
                start = this.position();
            }
        } else {
            end = positions[1];
        }
        if (end == -1) {
            end = this.position();
        } else if (end == 0) {
            if (start < 0) {
                end = this.position();
                start = this.position() + start;
            } else {
                end = this.position() + start;
                if (this.position() + end > this.length()) {
                    end = this.length();
                }
                start = this.position();
            }
        }
        if (start < 0 || end <= 0 || start > end) {
            return "";
        }
        return this.subSequence(start, end).toString();
    }
}

