/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.AbstractList;
import de.uniks.networkparser.list.SimpleEntrySet;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleKeyValueList<K, V>
extends AbstractArray<K>
implements Map<K, V> {
    public SimpleKeyValueList() {
        this.withFlag((byte)32);
    }

    public SimpleKeyValueList<K, V> setValueItem(Object key, Object value) {
        V child;
        int len;
        int pos = this.indexOf(key);
        if (pos >= 0) {
            this.setValue(pos, value);
            return this;
        }
        if (!(key instanceof String)) {
            return this;
        }
        String keyString = "" + key;
        int end = 0;
        int id = 0;
        for (len = 0; len < keyString.length(); ++len) {
            char temp = keyString.charAt(len);
            if (temp == '[') {
                for (end = len + 1; end < keyString.length(); ++end) {
                    temp = keyString.charAt(end);
                    if (keyString.charAt(end) == ']') {
                        ++end;
                        break;
                    }
                    if (temp > '/' && temp < ':' && id >= 0) {
                        id = id * 10 + temp - 48;
                        continue;
                    }
                    if (temp != 'L') continue;
                    id = -2;
                }
                if (end != keyString.length()) break;
                end = 0;
                break;
            }
            if (temp != '.') continue;
            end = len;
            id = -1;
            break;
        }
        if (end == 0 && len == keyString.length()) {
            id = -1;
        }
        if ((child = this.get(keyString.substring(0, len))) != null) {
            if (end == 0) {
                if (id >= 0 || id == -2) {
                    if (child instanceof AbstractArray) {
                        AbstractList list = (AbstractList)child;
                        if (id == -2) {
                            id = list.size() - 1;
                        }
                        if (list.size() >= id) {
                            if (value == null) {
                                list.remove(id);
                            } else {
                                list.set(id, value);
                            }
                        }
                    }
                } else if (value == null) {
                    this.remove(keyString.substring(0, len));
                } else {
                    this.put(keyString.substring(0, len), value);
                }
            } else if (id >= 0 || id == -2) {
                if (child instanceof AbstractArray) {
                    AbstractList list = (AbstractList)child;
                    if (id == -2) {
                        id = list.size() - 1;
                    }
                    if (list.size() >= id) {
                        ((SimpleKeyValueList)list.get(id)).setValueItem(keyString.substring(end + 1), value);
                    }
                }
            } else {
                ((SimpleKeyValueList)child).setValueItem(keyString.substring(end + 1), value);
            }
        } else {
            this.put(keyString.substring(0, len), value);
        }
        return this;
    }

    public void setValue(int pos, V value) {
        super.setValue(pos, value, 3);
    }

    public void copyEntity(SimpleKeyValueList<K, V> target, int pos) {
        if (target != null) {
            target.withKeyValue(this.get(pos), this.getValueByIndex(pos));
        }
    }

    @Override
    public Set<K> keySet() {
        SimpleSet item = new SimpleSet();
        if (this.isComplex(this.size) && this.elements != null) {
            item.init((Object[])this.elements[0], this.size, this.index);
        } else if (this.elements != null) {
            item.init(this.elements, this.size, this.index);
        }
        return item;
    }

    public Iterator<K> keyIterator() {
        return this.keySet().iterator();
    }

    public boolean getBoolean(K key) throws RuntimeException {
        V value = this.get(key);
        if (Boolean.FALSE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("false")) {
            return false;
        }
        if (Boolean.TRUE.equals(value) || value instanceof String && ((String)value).equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("SimpleKeyValueList is not a boolean.");
    }

    public double getDouble(K key) throws RuntimeException {
        V object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception e) {
            throw new RuntimeException("SimpleKeyValueList is not a number.");
        }
    }

    public int getInt(K key) throws RuntimeException {
        V object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception e) {
            throw new RuntimeException("SimpleKeyValueList is not a number.");
        }
    }

    public long getLong(K key) throws RuntimeException {
        V object = this.get(key);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception e) {
            throw new RuntimeException("SimpleKeyValueList is not a number.");
        }
    }

    public String getString(K key) throws RuntimeException {
        V object = this.get(key);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public String getString(K key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        int pos = this.indexOf(key);
        if (pos < 0) {
            return defaultValue;
        }
        return this.getValueByIndex(pos).toString();
    }

    public SimpleKeyValueList<K, V> increment(K key) throws RuntimeException {
        V value = this.get(key);
        if (value == null) {
            this.setValueItem(key, 1);
            return this;
        }
        if (value instanceof Integer) {
            this.setValueItem(key, (Integer)value + 1);
            return this;
        }
        if (value instanceof Long) {
            this.setValueItem(key, (Long)value + 1L);
            return this;
        }
        if (value instanceof Double) {
            this.setValueItem(key, (Double)value + 1.0);
            return this;
        }
        if (value instanceof Float) {
            this.setValueItem(key, Float.valueOf(((Float)value).floatValue() + 1.0f));
            return this;
        }
        if (value instanceof String) {
            try {
                this.setValueItem(key, "" + (this.getInt(key) + 1));
                return this;
            }
            catch (Exception exception) {
                try {
                    this.setValueItem(key, "" + (this.getDouble(key) + 1.0));
                    return this;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to increment [" + EntityUtil.quote("" + key) + "].");
                }
            }
        }
        throw new RuntimeException("Unable to increment [" + EntityUtil.quote("" + key) + "].");
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new SimpleKeyValueList<K, V>();
    }

    public SimpleKeyValueList<K, V> withList(Collection<?> values) {
        super.withList(values);
        return this;
    }

    @Override
    public SimpleKeyValueList<K, V> with(Object ... values) {
        if (values == null) {
            return this;
        }
        if (values.length % 2 == 0) {
            for (int i = 0; i < values.length; i += 2) {
                this.withKeyValue(values[i], values[i + 1]);
            }
            return this;
        }
        super.with(values);
        return this;
    }

    public <ST extends SimpleKeyValueList<K, V>> ST with(K key, V value) {
        this.add(key, value);
        return (ST)this;
    }

    public boolean add(K key, V value) {
        int pos = this.hasKey(key);
        if (pos >= 0) {
            this.grow(this.size + 1);
            super.addKeyValue(pos, key, value);
            return true;
        }
        return false;
    }

    public boolean add(int pos, K key, V value) {
        if (this.hasKey(key) >= 0) {
            this.grow(this.size + 1);
            super.addKeyValue(pos, key, value);
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        int pos = this.hasKeyAndPos(key);
        if (pos < 0) {
            return null;
        }
        if (pos == this.size || this.getByIndex(0, pos, this.size) != key) {
            this.grow(this.size + 1);
            super.addKeyValue(pos, key, value);
        } else {
            super.setValue(pos, value, 3);
        }
        return value;
    }

    @Override
    public boolean containsKey(Object key) {
        return super.contains(key);
    }

    public int getPositionValue(Object o) {
        return this.getPosition(o, 3, false);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        if (this.isComplex(this.size)) {
            return this.getPositionValue(value) >= 0;
        }
        Object[] items = (Object[])this.elements[3];
        for (int i = 0; i < this.size; ++i) {
            if (!value.equals(items[i])) continue;
            return true;
        }
        return false;
    }

    public int indexOfValue(Object value) {
        if (this.elements == null || value == null) {
            return -1;
        }
        if ((this.flag & 0x40) != 64 || this.size <= 420) {
            return this.search((Object[])this.elements[3], value);
        }
        return this.getPositionValue(value);
    }

    @Override
    public Iterator<K> iterator() {
        return new SimpleIterator(this);
    }

    @Override
    public K getKeyByIndex(int index) {
        return (K)super.getKeyByIndex(index);
    }

    public V getValueByIndex(int index) {
        return (V)super.getByIndex(3, index + this.index, this.size);
    }

    @Override
    public V remove(Object key) {
        int index = this.indexOf(key);
        if (index < 0) {
            return null;
        }
        int oldIndex = this.index;
        this.removeItem(index, 0, oldIndex);
        return (V)this.removeByIndex(index, 3, oldIndex);
    }

    public V removePos(int pos) {
        if (pos < 0) {
            return null;
        }
        int oldIndex = this.index;
        this.removeItem(pos, 0, oldIndex);
        return (V)this.removeByIndex(pos, 3, oldIndex);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> values) {
        if (values == null) {
            return;
        }
        for (Map.Entry<K, V> entry : values.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public SimpleKeyValueList<K, V> withMap(Map<?, ?> value) {
        if (value == null) {
            return this;
        }
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            this.withKeyValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public V get(Object key) {
        int pos = this.indexOf(key);
        if (pos >= 0) {
            return (V)super.getByIndex(3, pos + this.index, this.size);
        }
        return null;
    }

    @Override
    public Collection<V> values() {
        SimpleList item = new SimpleList();
        if (this.elements == null) {
            return item;
        }
        item.init((Object[])this.elements[3], this.size, this.index);
        return item;
    }

    public Object[] valuesArrayIntern() {
        if (this.elements == null) {
            return new Object[0];
        }
        return (Object[])this.elements[3];
    }

    public SimpleKeyValueList<K, V> withKeyValue(Object key, Object value) {
        int pos = this.hasKeyAndPos(key);
        if (pos < 0) {
            return this;
        }
        if (pos == this.size || this.getByIndex(0, pos, this.size) != key) {
            this.grow(this.size + 1);
            super.addKeyValue(pos, key, value);
        } else {
            super.setValue(pos, value, 3);
        }
        return this;
    }

    public SimpleKeyValueList<K, V> addToKeyValue(Object key, Number value) {
        int pos = this.hasKeyAndPos(key);
        if (pos < 0) {
            return this;
        }
        if (pos == this.size || this.getByIndex(0, pos, this.size) != key) {
            this.grow(this.size + 1);
            super.addKeyValue(pos, key, value);
        } else {
            Object oldValue = this.getByIndex(3, pos, this.size);
            if (oldValue instanceof Integer) {
                super.setValue(pos, (Integer)oldValue + (Integer)value, 3);
            }
        }
        return this;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SimpleEntrySet(this);
    }

    public K getKey(V value) {
        int pos = this.indexOfValue(value);
        if (pos < 0) {
            return null;
        }
        return this.getKeyByIndex(pos);
    }

    public SimpleKeyValueList<K, V> withKeyValueString(String keyValue, Class<?> valueType) {
        int pos = 0;
        do {
            char item;
            int start = pos;
            while (pos < keyValue.length() && (item = keyValue.charAt(pos)) != ':') {
                ++pos;
            }
            String key = keyValue.substring(start, pos);
            start = ++pos;
            while (pos < keyValue.length() && (item = keyValue.charAt(pos)) != ',') {
                ++pos;
            }
            String value = keyValue.substring(start, pos);
            ++pos;
            if (valueType == Integer.class) {
                this.withKeyValue(key, Integer.valueOf(value));
                continue;
            }
            this.withKeyValue(key, value);
        } while (pos < keyValue.length());
        return this;
    }

    @Override
    public AbstractArray<K> without(Object ... values) {
        if (values == null) {
            return this;
        }
        for (Object item : values) {
            this.remove(item);
        }
        return this;
    }
}

