/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.interfaces.Condition;

public abstract class GraphEntity
extends GraphMember {
    protected Object associations;
    private boolean external;
    private String id;

    public String getName(boolean shortName) {
        if (this.name == null) {
            return null;
        }
        if (!shortName) {
            String parentName;
            if (this.name.indexOf(46) < 0 && this.parentNode != null && (parentName = ((GraphMember)this.parentNode).getName()) != null) {
                return parentName + "." + this.name.replace("$", ".");
            }
            return this.name.replace("$", ".");
        }
        if (this.name.endsWith("...")) {
            String realName = this.name.substring(0, this.name.length() - 3);
            int pos = realName.lastIndexOf(".");
            return this.name.substring(pos + 1);
        }
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    public GraphEntity withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    String getTyp(String typ, boolean shortName) {
        if (typ.equals("objectdiagram")) {
            return this.getId();
        }
        if (typ.equals("classdiagram")) {
            return this.getName(shortName);
        }
        return "";
    }

    public AssociationSet getAssociations(Condition<?> ... filters) {
        AssociationSet collection = new AssociationSet();
        if (this.associations == null) {
            return collection;
        }
        if (this.associations instanceof Association) {
            if (this.check((Association)this.associations, filters)) {
                collection.add((Association)this.associations);
            }
        } else if (this.associations instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.associations;
            for (GraphMember item : list) {
                Association assoc;
                if (!(item instanceof Association) || !AssociationTypes.isEdge((assoc = (Association)item).getType().getValue()) || !this.check(assoc, filters)) continue;
                collection.add((Association)item);
            }
        }
        return collection;
    }

    AssociationSet getEdges(Condition<?> ... filters) {
        AssociationSet collection = new AssociationSet();
        if (this.associations == null) {
            return collection;
        }
        if (this.associations instanceof Association) {
            if (this.check((Association)this.associations, filters)) {
                collection.add((Association)this.associations);
            }
        } else if (this.associations instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.associations;
            for (GraphMember item : list) {
                Association assoc;
                if (!(item instanceof Association) || !this.check(assoc = (Association)item, filters)) continue;
                collection.add((Association)item);
            }
        }
        return collection;
    }

    GraphMember getByObject(String clazz, boolean fullName) {
        String id;
        if (clazz == null || this.children == null) {
            return null;
        }
        String sub = clazz;
        if (clazz.lastIndexOf(".") >= 0) {
            sub = clazz.substring(clazz.lastIndexOf(".") + 1);
        }
        GraphSimpleSet collection = this.getChildren();
        for (GraphMember item : collection) {
            id = item.getFullId();
            if (!clazz.equalsIgnoreCase(id) && !sub.equalsIgnoreCase(id)) continue;
            return item;
        }
        if (fullName || clazz.lastIndexOf(".") < 0) {
            return null;
        }
        for (GraphMember item : collection) {
            id = item instanceof Clazz ? ((Clazz)item).getId() : item.getName();
            if (!id.endsWith(clazz)) continue;
            return item;
        }
        return null;
    }

    public boolean isExternal() {
        return this.external;
    }

    public GraphEntity withExternal(boolean value) {
        if (this.external != value) {
            this.external = value;
        }
        return this;
    }

    protected GraphEntity with(Association ... values) {
        if (values != null) {
            for (Association value : values) {
                this.addAssoc(value);
            }
        }
        return this;
    }

    public GraphEntity without(Association ... values) {
        if (values == null || this.associations == null) {
            return this;
        }
        if (this.associations instanceof GraphMember) {
            for (Association value : values) {
                if (this.associations != value) continue;
                this.associations = null;
            }
            return this;
        }
        GraphSimpleSet collection = (GraphSimpleSet)this.associations;
        for (Association value : values) {
            if (value == null) continue;
            collection.remove(value);
        }
        return this;
    }

    boolean addAssoc(Association assoc) {
        if (assoc == null || this.associations == assoc) {
            return false;
        }
        boolean add = true;
        if (assoc.getOther() != null && this.associations != null) {
            for (Association item : this.getAssociations(new Condition[0])) {
                if (!this.has(item, assoc.getOther()) || !this.has(item.getOther(), assoc)) continue;
                if (item.isSame(assoc.getOther()) && item.getOther().isSame(assoc)) {
                    if (GraphUtil.isUndirectional(item)) {
                        item.getOther().with(AssociationTypes.ASSOCIATION);
                        item.with(AssociationTypes.ASSOCIATION);
                    }
                    add = false;
                    break;
                }
                if (!item.containsAll(assoc.getOther(), false) || item.getOther().name() != null || assoc.name() == null) continue;
                item.getOther().with(assoc.getCardinality());
                item.getOther().with(assoc.getName());
                item.getOther().with(AssociationTypes.ASSOCIATION);
                item.with(AssociationTypes.ASSOCIATION);
                add = false;
                break;
            }
        }
        if (add) {
            GraphSimpleSet list;
            if (this.associations == null) {
                this.associations = assoc;
            } else if (this.associations instanceof GraphSimpleSet) {
                list = (GraphSimpleSet)this.associations;
                add = list.add(assoc);
            } else {
                list = (GraphSimpleSet)new GraphSimpleSet().withAllowDuplicate(true);
                list.with(new Object[]{(GraphMember)this.associations});
                this.associations = list;
                add = list.add(assoc);
            }
        }
        return add;
    }

    private boolean has(Association o1, Association o2) {
        return o1.getClazz() == o2.getClazz();
    }

    @Override
    public Annotation getAnnotation() {
        return super.getAnnotation();
    }

    public GraphEntity with(Annotation value) {
        this.withAnnotaion(value);
        return this;
    }
}

