/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.ClazzImport;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphImage;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.Literal;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.Parameter;
import de.uniks.networkparser.graph.StringFilter;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.graph.util.AttributeSet;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.graph.util.MethodSet;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.SimpleSet;
import java.util.Collection;

public class Clazz
extends GraphEntity {
    public static final StringFilter<Clazz> NAME = new StringFilter("name");
    private ClazzType type = ClazzType.CLAZZ;

    @Override
    public Clazz with(String name) {
        super.with(name);
        return this;
    }

    @Override
    public Clazz withId(String id) {
        super.withId(id);
        return this;
    }

    public Clazz with(ClazzType clazzType) {
        this.type = clazzType;
        return this;
    }

    public Clazz enableInterface() {
        this.with(ClazzType.INTERFACE);
        return this;
    }

    public Clazz enableEnumeration() {
        this.with(ClazzType.ENUMERATION);
        return this;
    }

    public Clazz enableEnumeration(String ... literals) {
        this.with(ClazzType.ENUMERATION);
        if (literals == null) {
            return this;
        }
        for (String item : literals) {
            this.with(new Literal(item));
        }
        return this;
    }

    public Clazz enableEnumeration(Literal ... literals) {
        this.with(ClazzType.ENUMERATION);
        if (literals == null) {
            return this;
        }
        for (Literal item : literals) {
            this.with(item);
        }
        return this;
    }

    public ClazzType getType() {
        return this.type;
    }

    @Override
    String getFullId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return super.getFullId();
    }

    @Override
    public Clazz withExternal(boolean value) {
        super.withExternal(value);
        return this;
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = super.getModifier();
        if (modifier == null) {
            modifier = new Modifier(Modifier.PUBLIC.getName());
            super.withChildren(modifier);
        }
        return modifier;
    }

    @Override
    public Clazz with(Association ... values) {
        super.with(values);
        return this;
    }

    public Clazz with(Modifier ... values) {
        super.withModifier(values);
        return this;
    }

    public Clazz with(Attribute ... values) {
        super.withChildren(values);
        return this;
    }

    public Clazz with(Method ... values) {
        super.withChildren(values);
        return this;
    }

    @Override
    public Clazz with(Annotation value) {
        super.with(value);
        return this;
    }

    public Clazz with(GraphImage ... values) {
        super.withChildren(values);
        return this;
    }

    public Clazz with(Literal ... values) {
        super.withChildren(values);
        return this;
    }

    public SimpleSet<Literal> getValues() {
        SimpleSet<Literal> collection = new SimpleSet<Literal>();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Literal) {
            collection.add((Literal)this.children);
            return collection;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                if (!(item instanceof Literal)) continue;
                collection.add((Literal)item);
            }
        }
        return collection;
    }

    @Override
    public Clazz without(Association ... values) {
        super.without(values);
        return this;
    }

    public Clazz without(Modifier ... values) {
        super.without(values);
        return this;
    }

    public Clazz without(Attribute ... values) {
        super.without(values);
        return this;
    }

    public Clazz without(Method ... values) {
        super.without(values);
        return this;
    }

    public Clazz without(Annotation value) {
        super.without(value);
        return this;
    }

    public Clazz without(GraphImage ... values) {
        super.without(values);
        return this;
    }

    public Clazz without(Literal ... values) {
        super.without(values);
        return this;
    }

    public Clazz withBidirectional(Clazz tgtClass, String tgtRoleName, Cardinality tgtCardinality, String srcRoleName, Cardinality srcCardinality) {
        Association assocTarget = new Association(tgtClass).with(tgtCardinality).with(tgtRoleName);
        tgtClass.with(assocTarget);
        Association assocSource = new Association(this).with(srcCardinality).with(srcRoleName);
        assocSource.with(assocTarget);
        this.with(assocSource);
        return this;
    }

    public Clazz withUniDirectional(Clazz tgtClass, String tgtRoleName, Cardinality tgtCardinality) {
        Association assocTarget = new Association(tgtClass).with(tgtCardinality);
        tgtClass.with(assocTarget);
        assocTarget.with(AssociationTypes.UNDIRECTIONAL).with(tgtRoleName);
        Association assocSource = new Association(this);
        assocSource.with(AssociationTypes.EDGE);
        assocSource.with(assocTarget);
        this.with(assocSource);
        return this;
    }

    public Clazz getSuperClass() {
        if (this.associations == null) {
            return null;
        }
        ClazzSet clazzSet = this.getEdges(AssociationTypes.GENERALISATION, AssociationTypes.EDGE);
        return (Clazz)clazzSet.first();
    }

    public ClazzSet getInterfaces(boolean transitive) {
        ClazzSet clazzSet;
        ClazzSet interfaces = new ClazzSet();
        if (this.associations == null) {
            return interfaces;
        }
        if (this.getType() == ClazzType.INTERFACE) {
            clazzSet = this.getEdges(AssociationTypes.GENERALISATION, AssociationTypes.EDGE);
            for (Clazz clazz : clazzSet) {
                if (!GraphUtil.isInterface(clazz)) continue;
                interfaces.with(new Object[]{clazz});
            }
        }
        clazzSet = this.getEdges(AssociationTypes.IMPLEMENTS, AssociationTypes.EDGE);
        for (Clazz clazz : clazzSet) {
            if (!GraphUtil.isInterface(clazz)) continue;
            interfaces.with(new Object[]{clazz});
        }
        if (!transitive) {
            return interfaces;
        }
        int size = interfaces.size();
        for (int i = 0; i < size; ++i) {
            interfaces.withList((Collection)((Clazz)interfaces.get(i)).getInterfaces(transitive));
        }
        return interfaces;
    }

    public Clazz withSuperClazz(Clazz ... values) {
        this.createAssociation(AssociationTypes.GENERALISATION, AssociationTypes.EDGE, values);
        return this;
    }

    public Clazz withImplements(Clazz ... values) {
        this.createAssociation(AssociationTypes.IMPLEMENTS, AssociationTypes.EDGE, values);
        return this;
    }

    public ClazzSet getSuperClazzes(boolean transitive) {
        ClazzSet collection = this.getEdges(AssociationTypes.GENERALISATION);
        if (!transitive) {
            return collection;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            collection.withList((Collection)((Clazz)collection.get(i)).getSuperClazzes(transitive));
        }
        return collection;
    }

    public ClazzSet getKidClazzes(boolean transitive) {
        ClazzSet kidClazzes = this.getEdges(AssociationTypes.EDGE, AssociationTypes.GENERALISATION);
        if (!transitive) {
            return kidClazzes;
        }
        int size = kidClazzes.size();
        for (int i = 0; i < size; ++i) {
            kidClazzes.withList((Collection)((Clazz)kidClazzes.get(i)).getKidClazzes(transitive));
        }
        return kidClazzes;
    }

    ClazzSet getEdges(AssociationTypes typ) {
        return this.getEdges(typ, null);
    }

    ClazzSet getEdges(AssociationTypes typ, AssociationTypes otherTyp) {
        ClazzSet kidClazzes = new ClazzSet();
        if (this.associations == null || typ == null) {
            return kidClazzes;
        }
        for (Association assoc : this.getEdges(new Condition[0])) {
            if (typ != assoc.getType() || otherTyp != null && assoc.getOtherType() != otherTyp) continue;
            Clazz clazz = assoc.getOtherClazz();
            kidClazzes.with(new Object[]{clazz});
        }
        return kidClazzes;
    }

    void createAssociation(AssociationTypes direction, AssociationTypes backDirection, Clazz ... values) {
        if (values == null) {
            return;
        }
        AssociationSet associations = this.getAssociations(new Condition[0]);
        for (Clazz item : values) {
            if (item == null) continue;
            boolean found = false;
            for (Association assoc : associations) {
                if (assoc.getType() != direction || assoc.getOtherType() != backDirection || assoc.contains(item, true, false)) continue;
                if (assoc.getType() == AssociationTypes.GENERALISATION) {
                    found = true;
                    for (GraphMember member : assoc.getOther().getParents()) {
                        if (!(member instanceof Clazz) || member == item) continue;
                        assoc.getOther().withoutParent(member);
                    }
                }
                assoc.getOther().setParent(item);
                break;
            }
            if (found) continue;
            Association childAssoc = new Association(this).with(direction);
            Association superAssoc = new Association(item).with(backDirection);
            childAssoc.with(superAssoc);
            this.with(childAssoc);
            item.with(superAssoc);
        }
    }

    public Clazz withKidClazzes(Clazz ... values) {
        this.createAssociation(AssociationTypes.EDGE, AssociationTypes.GENERALISATION, values);
        return this;
    }

    public GraphModel getClassModel() {
        return (GraphModel)this.parentNode;
    }

    public boolean setClassModel(GraphModel value) {
        return super.setParent(value);
    }

    public AttributeSet getAttributes(Condition<?> ... filters) {
        AttributeSet collection = new AttributeSet();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Attribute) {
            if (this.check((Attribute)this.children, filters)) {
                collection.add((Attribute)this.children);
            }
            return collection;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                if (!(item instanceof Attribute) || !this.check(item, filters)) continue;
                collection.add((Attribute)item);
            }
        }
        return collection;
    }

    @Override
    public AssociationSet getAssociations(Condition<?> ... filters) {
        if (this.associations == null) {
            return AssociationSet.EMPTY_SET;
        }
        AssociationSet result = new AssociationSet();
        if (this.associations instanceof Association) {
            if (this.check((Association)this.associations, filters)) {
                result.add((Association)this.associations);
            }
            return result;
        }
        if (this.associations instanceof Collection) {
            Collection list = (Collection)this.associations;
            for (Object item : list) {
                if (!(item instanceof Association) || !this.check((Association)item, filters)) continue;
                result.add((Association)item);
            }
        }
        return result;
    }

    public MethodSet getMethods(Condition<?> ... filters) {
        MethodSet collection = new MethodSet();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Method) {
            if (this.check((Method)this.children, filters)) {
                collection.add((Method)this.children);
            }
            return collection;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                if (!(item instanceof Method) || !this.check(item, filters)) continue;
                collection.add((Method)item);
            }
        }
        return collection;
    }

    public Clazz withoutKidClazz(Clazz ... values) {
        if (this.associations == null || values == null) {
            return this;
        }
        block0: for (Clazz item : values) {
            if (item == null) continue;
            for (Association assoc : this.getAssociations(new Condition[0])) {
                if (assoc.getOther().getType() != AssociationTypes.GENERALISATION || !assoc.contains(item, false, true)) continue;
                super.without(assoc);
                continue block0;
            }
        }
        return this;
    }

    public Clazz withoutSuperClazz(Clazz ... values) {
        if (this.associations == null || values == null) {
            return this;
        }
        block0: for (Clazz item : values) {
            if (item == null) continue;
            for (Association assoc : this.getAssociations(new Condition[0])) {
                if (assoc.getType() != AssociationTypes.GENERALISATION || !assoc.contains(item, true, false)) continue;
                this.without(assoc);
                continue block0;
            }
        }
        return this;
    }

    public Clazz with(ClazzImport ... value) {
        super.withChildren(value);
        return this;
    }

    public SimpleSet<ClazzImport> getImports() {
        SimpleSet<ClazzImport> collection = new SimpleSet<ClazzImport>();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof ClazzImport) {
            collection.add((ClazzImport)this.children);
            return collection;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                if (!(item instanceof ClazzImport)) continue;
                collection.add((ClazzImport)item);
            }
        }
        return collection;
    }

    public Method createMethod(String name, Parameter ... parameters) {
        Method method = new Method().with(name);
        method.with(parameters);
        method.setParent(this);
        return method;
    }

    public Attribute createAttribute(String name, DataType type) {
        Attribute attribute = new Attribute(name, type);
        this.with(attribute);
        return attribute;
    }

    public Clazz withAttribute(String name, DataType type) {
        Attribute attribute = new Attribute(name, type);
        this.with(attribute);
        return this;
    }

    public Clazz withMethod(String name, DataType returnType, Parameter ... parameters) {
        Method method = this.createMethod(name, parameters);
        method.with(returnType);
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public static enum ClazzType {
        CLAZZ,
        ENUMERATION,
        INTERFACE;

    }
}

