/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.StringFilter;
import de.uniks.networkparser.interfaces.BufferItem;
import de.uniks.networkparser.list.SimpleList;

public class Annotation
extends GraphMember {
    public static final StringFilter<Annotation> NAME = new StringFilter("name");
    public static final Annotation DEPRECATED = new Annotation("Deprecated");
    public static final Annotation OVERRIDE = new Annotation("Override");
    public static final Annotation SAFE_VARGARGS = new Annotation("SafeVarargs");
    public static final Annotation SUPPRESS_WARNINGS = new Annotation("SuppressWarnings");
    private SimpleList<Annotation> value;
    private boolean keyValue;
    private Annotation nextAnnotaton;

    Annotation() {
    }

    public Annotation(String name) {
        super.with(name);
    }

    public static Annotation create(String value) {
        Annotation annotation = new Annotation();
        annotation.decode(value);
        return annotation;
    }

    @Override
    public Annotation with(String name) {
        super.with(name);
        return this;
    }

    public Annotation decode(String value) {
        CharacterBuffer tokener = new CharacterBuffer();
        tokener.with(value);
        this.decode(tokener, '\u0000', null);
        return this;
    }

    Annotation addValue(Annotation ... values) {
        if (values == null) {
            return this;
        }
        if (this.value == null) {
            this.value = new SimpleList();
        }
        for (Annotation item : values) {
            if (item == null) continue;
            this.value.add(item);
        }
        return this;
    }

    public Annotation decode(BufferItem tokener, char endTag, Annotation parent) {
        char item = tokener.getCurrentChar();
        CharacterBuffer token = new CharacterBuffer();
        boolean charCount = false;
        while (item != '\u0000' && item != endTag) {
            Annotation child;
            if (item == '\"') {
                boolean bl = charCount = !charCount;
            }
            if (charCount) {
                token.with(item);
                item = tokener.getChar();
                continue;
            }
            if (item == ' ') {
                item = tokener.getChar();
                continue;
            }
            if (item == '(') {
                this.name = token.toString();
                tokener.skip();
                child = new Annotation();
                this.addValue(child);
                child.decode(tokener, ')', this);
                return this;
            }
            if (item == '{') {
                this.name = token.toString();
                tokener.skip();
                this.decode(tokener, '}', parent);
                return this;
            }
            if (item == '=') {
                this.name = token.toString();
                this.keyValue = true;
                tokener.skip();
                child = new Annotation();
                this.addValue(child);
                child.decode(tokener, endTag, parent);
                item = tokener.getCurrentChar();
                if (item != ',') break;
            }
            if (item == ',') {
                this.name = token.toString();
                tokener.skip();
                if (parent == null) break;
                child = new Annotation();
                parent.addValue(child);
                child.decode(tokener, endTag, parent);
                break;
            }
            token.with(item);
            item = tokener.getChar();
            if (item != '@') continue;
            this.name = token.toString();
            this.nextAnnotaton = new Annotation().decode(tokener, '\u0000', null);
            return this;
        }
        if (item == '\u0000' || item == endTag) {
            this.name = token.toString();
        }
        return this;
    }

    public SimpleList<Annotation> getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.value == null) {
            return sb.toString();
        }
        if (this.keyValue && this.value.size() == 1) {
            sb.append("=");
            sb.append(((Annotation)this.value.first()).toString());
            return sb.toString();
        }
        sb.append("(");
        if (this.value.size() > 0) {
            sb.append(this.value.first());
        }
        for (int i = 1; i < this.value.size(); ++i) {
            sb.append(",");
            sb.append(this.value.get(i));
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean hasNext() {
        return this.nextAnnotaton != null;
    }

    public Annotation next() {
        return this.nextAnnotaton;
    }

    public String getValue(String key, String defaultText) {
        if (key == null || this.value == null) {
            return defaultText;
        }
        if (this.keyValue && this.value.size() == 1) {
            if (key.equalsIgnoreCase(this.getName())) {
                return ((Annotation)this.value.first()).getName();
            }
            return defaultText;
        }
        for (Annotation item : this.value) {
            String result = item.getValue(key, defaultText);
            if ((result == null || result.equals(defaultText)) && (result != null || defaultText == null)) continue;
            return result;
        }
        return defaultText;
    }

    public Annotation getAnnotation(String key) {
        if (key == null) {
            return null;
        }
        if (key.equalsIgnoreCase(this.getName())) {
            return this;
        }
        if (this.nextAnnotaton == null) {
            return null;
        }
        return this.nextAnnotaton.getAnnotation(key);
    }

    public GraphMember getParent() {
        return (GraphMember)this.parentNode;
    }
}

