/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.bytes.ByteList;
import de.uniks.networkparser.bytes.ByteUtil;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.converter.ByteConverterHTTP;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.Converter;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class ByteEntity
implements ByteItem {
    public static final int BITOFBYTE = 8;
    public static final int TYPBYTE = 1;
    public static final String TYP = "TYP";
    public static final String VALUE = "VALUE";
    protected byte typ;
    protected byte[] values;

    public byte[] getValue() {
        if (this.values == null) {
            return null;
        }
        return ByteUtil.clone(this.values);
    }

    public ByteEntity withValue(byte typ, byte[] value) {
        this.typ = typ;
        if (value != null) {
            this.values = ByteUtil.clone(value);
        }
        return this;
    }

    public ByteEntity withValue(byte typ, byte value) {
        this.typ = typ;
        this.values = new byte[]{value};
        return this;
    }

    public ByteEntity withValue(byte typ, int value) {
        this.typ = typ;
        ByteBuffer msgValue = new ByteBuffer().withBufferLength(4);
        msgValue.put(value);
        this.values = msgValue.flip(true).array();
        return this;
    }

    public byte byteToUnsignedByte(int n) {
        if (n < 128) {
            return (byte)n;
        }
        return (byte)(n - 256);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Converter converter) {
        if (converter instanceof ByteConverter) {
            return this.toString((ByteConverter)converter, false);
        }
        return null;
    }

    @Override
    public String toString(ByteConverter converter, boolean dynamic) {
        if (converter == null) {
            converter = new ByteConverterHTTP();
        }
        return converter.toString(this.getBytes(dynamic));
    }

    @Override
    public void writeBytes(ByteBuffer buffer, boolean isDynamic, boolean isLast, boolean isPrimitive) {
        byte[] value = this.values;
        int typ = this.getTyp();
        if (value == null) {
            typ = ByteUtil.getTyp((byte)typ, 0, isLast);
            ByteUtil.writeByteHeader(buffer, (byte)typ, 0);
            return;
        }
        if (isDynamic) {
            if (typ == 48) {
                short bufferValue = new ByteBuffer().with(value).flip(true).getShort();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    typ = 54;
                    value = new byte[]{(byte)bufferValue};
                }
            } else if (typ == 49 || typ == 50) {
                int bufferValue = new ByteBuffer().with(value).flip(true).getInt();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    typ = 54;
                    value = new byte[]{(byte)bufferValue};
                } else if (bufferValue >= Short.MIN_VALUE && bufferValue <= Short.MAX_VALUE) {
                    typ = 54;
                    ByteBuffer bbShort = ByteBuffer.allocate(2);
                    bbShort.put((short)bufferValue);
                    bbShort.flip(true);
                    value = bbShort.array();
                }
            }
        }
        if (!isPrimitive || typ == 68 || typ == 69) {
            typ = ByteUtil.getTyp((byte)typ, value.length, isLast);
            ByteUtil.writeByteHeader(buffer, (byte)typ, value.length);
        }
        buffer.put(value);
    }

    @Override
    public ByteBuffer getBytes(boolean isDynamic) {
        int len = this.calcLength(isDynamic, true);
        ByteBuffer buffer = ByteUtil.getBuffer(len);
        this.writeBytes(buffer, isDynamic, true, false);
        buffer.flip(true);
        return buffer;
    }

    public boolean setValues(Object value) {
        int typ = 0;
        ByteBuffer msgValue = new ByteBuffer();
        if (value == null) {
            typ = 34;
        }
        if (value instanceof Short) {
            typ = 48;
            msgValue.withBufferLength(2);
            msgValue.put((Short)value);
        } else if (value instanceof Integer) {
            typ = 49;
            msgValue.withBufferLength(4);
            msgValue.put((Integer)value);
        } else if (value instanceof Long) {
            typ = 50;
            msgValue.withBufferLength(8);
            msgValue.put((Long)value);
        } else if (value instanceof Float) {
            typ = 51;
            msgValue.withBufferLength(4);
            msgValue.put(((Float)value).floatValue());
        } else if (value instanceof Double) {
            typ = 52;
            msgValue.withBufferLength(8);
            msgValue.put((Double)value);
        } else if (value instanceof Byte) {
            typ = 54;
            msgValue.withBufferLength(1);
            msgValue.put((Byte)value);
        } else if (value instanceof Character) {
            typ = 64;
            msgValue.withBufferLength(2);
            msgValue.put(((Character)value).charValue());
        } else if (value instanceof String) {
            typ = 74;
            String newValue = (String)value;
            msgValue.withBufferLength(newValue.length());
            try {
                msgValue.put(newValue.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (value instanceof Date) {
            typ = 53;
            msgValue.withBufferLength(4);
            Date newValue = (Date)value;
            msgValue.put((int)newValue.getTime());
        } else if (value instanceof Byte[] || value instanceof byte[]) {
            typ = 58;
            if (value != null) {
                byte[] newValue = (byte[])value;
                msgValue.withBufferLength(newValue.length);
                msgValue.put(newValue);
            }
        }
        if (typ != 0) {
            this.typ = (byte)typ;
            msgValue.flip(true);
            this.values = msgValue.array();
            return true;
        }
        return false;
    }

    @Override
    public byte getTyp() {
        return this.typ;
    }

    @Override
    public int calcLength(boolean isDynamic, boolean isLast) {
        if (this.values == null) {
            return 1;
        }
        if (isDynamic) {
            if (this.typ == 48) {
                Short bufferValue = new ByteBuffer().with(this.values).flip(true).getShort();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    return 2;
                }
            } else if (this.typ == 49 || this.typ == 50) {
                Integer bufferValue = new ByteBuffer().with(this.values).flip(true).getInt();
                if (bufferValue >= -128 && bufferValue <= 127) {
                    return 2;
                }
                if (bufferValue >= Short.MIN_VALUE && bufferValue <= Short.MAX_VALUE) {
                    return 3;
                }
            }
        }
        return 1 + ByteUtil.getTypLen(this.typ, this.values.length, isLast) + this.values.length;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        if (keyValue) {
            return new ByteEntity();
        }
        return new ByteList();
    }

    @Override
    public boolean isEmpty() {
        return this.getTyp() == 34;
    }

    @Override
    public int size() {
        if (this.values == null) {
            return 0;
        }
        return this.values.length;
    }

    public static ByteEntity create(Object value) {
        ByteEntity item = new ByteEntity();
        item.setValues(value);
        return item;
    }

    @Override
    public ByteEntity with(Object ... values) {
        if (values == null) {
            return this;
        }
        if (values.length > 1) {
            byte[] value = new byte[values.length - 1];
            for (int i = 1; i < values.length; ++i) {
                value[i - 1] = (Byte)values[i];
            }
            this.withValue((byte)((Byte)values[0]), value);
        }
        return this;
    }

    public ByteEntity withValue(byte[] values) {
        if (values == null) {
            return this;
        }
        if (values.length > 1) {
            byte[] value = new byte[values.length - 1];
            for (int i = 1; i < values.length; ++i) {
                value[i - 1] = values[i];
            }
            this.typ = values[0];
            this.values = value;
        }
        return this;
    }

    public Object getValue(Object key) {
        if (TYP.equals(key)) {
            return this.typ;
        }
        if (VALUE.equals(key)) {
            return this.values;
        }
        return null;
    }
}

