/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.web.assessment;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.unibonn.iai.eis.luzzu.semantics.utilities.Commons;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.LMI;
import java.io.File;

public class MetricConfiguration {
    public static Model getAllMetrics() {
        File externalsFolder = new File("externals/metrics/");
        File[] listOfFiles = externalsFolder.listFiles();
        Model returnModel = ModelFactory.createDefaultModel();
        for (File metrics : listOfFiles) {
            if (metrics.isHidden() || !metrics.isDirectory()) continue;
            Model m = ModelFactory.createDefaultModel();
            m.read(metrics + "/metrics.trig");
            ResIterator res = m.listSubjectsWithProperty(RDF.type, (RDFNode)LMI.LuzzuMetricJavaImplementation);
            while (res.hasNext()) {
                Resource r = (Resource)res.next();
                String jpn = m.listObjectsOfProperty(r, LMI.javaPackageName).next().asLiteral().toString();
                NodeIterator n = m.listObjectsOfProperty(r, RDFS.label);
                String label = "";
                if (n.hasNext()) {
                    label = n.next().asLiteral().toString();
                }
                Resource bn = Commons.generateRDFBlankNode().asResource();
                returnModel.add(bn, LMI.javaPackageName, (RDFNode)returnModel.createLiteral(jpn));
                returnModel.add(bn, RDFS.label, (RDFNode)returnModel.createLiteral(label));
            }
        }
        return returnModel;
    }
}

