/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.properties;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PropertyManager {
    private static PropertyManager instance = null;
    private ConcurrentMap<String, Properties> propMap = new ConcurrentHashMap<String, Properties>();
    protected ConcurrentMap<String, String> environmentVars = new ConcurrentHashMap<String, String>();

    protected PropertyManager() {
        try {
            Properties prop = new Properties();
            prop.load(this.getClass().getResourceAsStream("/properties/cache.properties"));
            this.propMap.put("cache.properties", prop);
            prop = new Properties();
            prop.load(this.getClass().getResourceAsStream("/properties/webservice.properties"));
            this.propMap.put("webservice.properties", prop);
            prop = new Properties();
            prop.load(this.getClass().getResourceAsStream("/properties/spark.properties"));
            this.propMap.put("spark.properties", prop);
            prop = new Properties();
            prop.load(this.getClass().getResourceAsStream("/properties/directories.properties"));
            this.propMap.put("directories.properties", prop);
            prop = new Properties();
            prop.load(this.getClass().getResourceAsStream("/properties/luzzu.properties"));
            this.propMap.put("luzzu.properties", prop);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static PropertyManager getInstance() {
        if (instance == null) {
            instance = new PropertyManager();
        }
        return instance;
    }

    public Properties getProperties(String propertiesRequired) {
        return (Properties)this.propMap.get(propertiesRequired);
    }

    public void addToEnvironmentVars(String key, String value) {
        this.environmentVars.put(key, value);
    }
}

