/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.cache.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.Quad;
import de.unibonn.iai.eis.luzzu.cache.CacheObject;
import de.unibonn.iai.eis.luzzu.semantics.utilities.Commons;

public class TemporaryGraphMetadataCacheObject
implements CacheObject {
    private static final long serialVersionUID = -286271367636630291L;
    private transient Resource graphURI = null;
    private transient Model metadataModel = null;

    public TemporaryGraphMetadataCacheObject(Resource graphURI) {
        this.graphURI = graphURI;
        this.metadataModel = ModelFactory.createDefaultModel();
    }

    public void addTriplesToMetadata(Quad quad) {
        Property p = this.metadataModel.createProperty(quad.getPredicate().getURI());
        this.metadataModel.add(Commons.asRDFNode((Node)quad.getSubject()).asResource(), p, Commons.asRDFNode((Node)quad.getObject()));
    }

    public void addModelToMetadata(Model model) {
        this.metadataModel.add(model);
    }

    public Resource getGraphURI() {
        return this.graphURI;
    }

    public Model getMetadataModel() {
        return this.metadataModel;
    }
}

