/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.operations.ranking;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import de.unibonn.iai.eis.luzzu.operations.ranking.DatasetLoader;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankBy;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankedObject;
import de.unibonn.iai.eis.luzzu.operations.ranking.RankingConfiguration;
import de.unibonn.iai.eis.luzzu.semantics.configuration.InternalModelConf;
import de.unibonn.iai.eis.luzzu.semantics.datatypes.Observation;
import de.unibonn.iai.eis.luzzu.semantics.utilities.ObservationHelper;
import de.unibonn.iai.eis.luzzu.semantics.utilities.SPARQLHelper;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ranking {
    static final Logger logger = LoggerFactory.getLogger(Ranking.class);
    private static Dataset d = DatasetLoader.getInstance().getInternalDataset();
    private Model currentQualityMetadata;

    public List<RankedObject> rank(List<RankingConfiguration> rankingConfig) {
        ArrayList<RankedObject> rankedObjects = new ArrayList<RankedObject>();
        Map<String, String> graphs = DatasetLoader.getInstance().getAllGraphs();
        for (String base : graphs.keySet()) {
            String graph = graphs.get(base);
            this.currentQualityMetadata = d.getNamedModel(graph);
            Double rankedValue = 0.0;
            for (RankingConfiguration rc : rankingConfig) {
                if (rc.getType() == RankBy.CATEGORY) {
                    rankedValue = rankedValue + this.categoryValue(rc.getUriResource(), rc.getWeight());
                }
                if (rc.getType() == RankBy.DIMENSION) {
                    rankedValue = rankedValue + this.dimensionValue(rc.getUriResource(), rc.getWeight());
                }
                if (rc.getType() != RankBy.METRIC) continue;
                rankedValue = rankedValue + this.metricValue(rc.getUriResource(), rc.getWeight());
            }
            if (rankedValue.isNaN()) continue;
            RankedObject ro = new RankedObject(base, rankedValue);
            rankedObjects.add(ro);
        }
        Collections.sort(rankedObjects);
        Collections.reverse(rankedObjects);
        return rankedObjects;
    }

    private double metricValue(Resource metric, double weight) {
        double rankingValue = 0.0;
        logger.info("Ranking by Metric {}, with the weight of {}", (Object)metric.getURI(), (Object)weight);
        List lst = ObservationHelper.extractObservations((Model)this.currentQualityMetadata, (Resource)metric);
        if (lst.size() > 0) {
            Observation obs = ObservationHelper.getLatestObservation((List)lst);
            rankingValue = obs.getValue() * weight;
        }
        return rankingValue;
    }

    private double dimensionValue(Resource dimension, double weight) {
        logger.info("Ranking by Dimension {}, with the weight of {}", (Object)dimension.getURI(), (Object)weight);
        String selectQuery = this.getSelectQuery("sparql/GetDimensionMetrics.sparql").replace("%dimension%", SPARQLHelper.toSPARQL((Resource)dimension));
        double totalNumberOfMetrics = 0.0;
        double summation = 0.0;
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery), (Model)InternalModelConf.getFlatModel());
        ResultSet set = exec.execSelect();
        while (set.hasNext()) {
            totalNumberOfMetrics += 1.0;
            Resource res = set.next().get("metric").asResource();
            summation += this.metricValue(res, weight);
        }
        if (totalNumberOfMetrics == 0.0) {
            logger.info("No dimensions available for the {} Dimension", (Object)dimension.getURI());
            return 0.0;
        }
        double dimensionRanking = summation / totalNumberOfMetrics;
        logger.info("Ranking value for {} computed: {}", (Object)dimension.getURI(), (Object)dimensionRanking);
        return dimensionRanking;
    }

    private double categoryValue(Resource category, double weight) {
        logger.info("Ranking by Category {}, with the weight of {}", (Object)category.getURI(), (Object)weight);
        String selectQuery = this.getSelectQuery("sparql/GetCategoryDimensions.sparql").replace("%category%", SPARQLHelper.toSPARQL((Resource)category));
        double totalNumberOfDimensions = 0.0;
        double summation = 0.0;
        QueryExecution exec = QueryExecutionFactory.create((Query)QueryFactory.create((String)selectQuery), (Model)InternalModelConf.getFlatModel());
        ResultSet set = exec.execSelect();
        while (set.hasNext()) {
            totalNumberOfDimensions += 1.0;
            Resource res = set.next().get("dimension").asResource();
            summation += this.dimensionValue(res, weight);
        }
        if (totalNumberOfDimensions == 0.0) {
            logger.info("No dimensions available for the {} Category", (Object)category.getURI());
            return 0.0;
        }
        double categoryRanking = summation / totalNumberOfDimensions;
        logger.info("Ranking value for {} computed: {}", (Object)category.getURI(), (Object)categoryRanking);
        return categoryRanking;
    }

    private String getSelectQuery(String fileName) {
        String selectQuery = "";
        URL url = Resources.getResource((String)fileName);
        try {
            selectQuery = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("Error: {}", (Object)e.getMessage());
        }
        return selectQuery;
    }
}

