/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.cache;

import de.unibonn.iai.eis.luzzu.cache.Cache;
import de.unibonn.iai.eis.luzzu.cache.CacheObject;
import java.util.concurrent.ConcurrentHashMap;

public class CacheManager {
    private ConcurrentHashMap<String, Cache> registeredCache = new ConcurrentHashMap();
    private static CacheManager instance = null;

    protected CacheManager() {
    }

    public static CacheManager getInstance() {
        if (instance == null) {
            instance = new CacheManager();
        }
        return instance;
    }

    public void createNewCache(String cacheName, int maxItems) {
        this.registeredCache.put(cacheName, new Cache(cacheName, maxItems));
    }

    public void addToCache(String cacheName, Object key, CacheObject value) {
        this.registeredCache.get(cacheName).addToCache(key, value);
    }

    public CacheObject getFromCache(String cacheName, Object key) {
        return this.registeredCache.get(cacheName).getFromCache(key);
    }

    public boolean cacheExists(String cacheName) {
        return this.registeredCache.containsKey(cacheName);
    }

    public boolean existsInCache(String cacheName, Object key) {
        return this.registeredCache.get(cacheName).existsInCache(key);
    }

    public void cleanup() {
        for (String key : this.registeredCache.keySet()) {
            this.registeredCache.get(key).cleanup();
        }
        this.registeredCache.clear();
    }
}

