/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.communications.resources;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import de.unibonn.iai.eis.luzzu.io.impl.StreamProcessor;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class QualityResource {
    static final Logger logger = LoggerFactory.getLogger(QualityResource.class);

    @POST
    @Path(value="compute_quality")
    @Produces(value={"application/json"})
    public String computeQuality(MultivaluedMap<String, String> formParams) {
        String jsonResponse = null;
        String datasetURI = null;
        String jsonStrMetricsConfig = null;
        String baseURI = "";
        boolean genQualityReport = false;
        try {
            StreamProcessor strmProc;
            logger.info("Quality computation request received for dataset: {}", formParams.get((Object)"Dataset"));
            List lstDatasetURI = (List)formParams.get((Object)"Dataset");
            List lstQualityReportReq = (List)formParams.get((Object)"QualityReportRequired");
            List lstMetricsConfig = (List)formParams.get((Object)"MetricsConfiguration");
            List lstBaseUri = (List)formParams.get((Object)"BaseUri");
            logger.debug("Processing request parameters. DatasetURI: {}; QualityReportRequired: {}; MetricsConfiguration: {}; BaseUri: {}", new Object[]{lstDatasetURI, lstQualityReportReq, lstMetricsConfig, lstBaseUri});
            if (lstDatasetURI == null || lstDatasetURI.size() <= 0) {
                throw new IllegalArgumentException("Dataset URI parameter was not provided");
            }
            if (lstQualityReportReq == null || lstQualityReportReq.size() <= 0) {
                throw new IllegalArgumentException("Generate Quality Report parameter was not provided");
            }
            if (lstMetricsConfig == null || lstMetricsConfig.size() <= 0) {
                throw new IllegalArgumentException("Metrics configuration parameter was not provided");
            }
            jsonStrMetricsConfig = (String)lstMetricsConfig.get(0);
            genQualityReport = Boolean.parseBoolean((String)lstQualityReportReq.get(0));
            Model modelConfig = ModelFactory.createDefaultModel();
            RDFDataMgr.read((Model)modelConfig, (StringReader)new StringReader(jsonStrMetricsConfig), null, (Lang)Lang.JSONLD);
            String[] expandedListDatasetURI = ((String)lstDatasetURI.get(0)).split(",");
            if (expandedListDatasetURI.length == 1) {
                datasetURI = expandedListDatasetURI[0];
                strmProc = new StreamProcessor(datasetURI, genQualityReport, modelConfig);
            } else {
                if (lstBaseUri != null) {
                    baseURI = (String)lstBaseUri.get(0);
                }
                strmProc = new StreamProcessor(baseURI, Arrays.asList(expandedListDatasetURI), genQualityReport, modelConfig);
            }
            strmProc.processorWorkFlow();
            strmProc.cleanUp();
            Model modelQualityRep = null;
            if (genQualityReport) {
                modelQualityRep = strmProc.retreiveQualityReport();
            }
            jsonResponse = this.buildJsonResponse(datasetURI == null ? baseURI : datasetURI, modelQualityRep);
            logger.debug("Quality computation request completed. Output: {}", (Object)jsonResponse);
        }
        catch (Exception ex) {
            String errorTimeStamp = Long.toString(new Date().getTime());
            logger.error("Error processing quality computation request [" + errorTimeStamp + "]", (Throwable)ex);
            jsonResponse = this.buildJsonErrorResponse(datasetURI, errorTimeStamp, "The request caused an exception");
        }
        return jsonResponse;
    }

    private String buildJsonResponse(String datasetURI, Model qualityReport) {
        StringBuilder sbJsonResponse = new StringBuilder();
        sbJsonResponse.append("{ \"Dataset\": \"" + datasetURI + "\", ");
        sbJsonResponse.append("\"Outcome\": \"SUCCESS\"");
        if (qualityReport != null && !qualityReport.isEmpty()) {
            StringWriter strWriter = new StringWriter();
            RDFDataMgr.write((StringWriter)strWriter, (Model)qualityReport, (RDFFormat)RDFFormat.JSONLD);
            sbJsonResponse.append(", \"QualityReport\": ");
            sbJsonResponse.append(strWriter.toString());
        }
        sbJsonResponse.append(" }");
        return sbJsonResponse.toString();
    }

    private String buildJsonErrorResponse(String datasetURI, String errorCode, String errorMessage) {
        StringBuilder sbJsonResponse = new StringBuilder();
        sbJsonResponse.append("{ \"Dataset\": \"" + datasetURI + "\", ");
        sbJsonResponse.append("\"Outcome\": \"ERROR\", ");
        sbJsonResponse.append("\"ErrorMessage\": \"" + errorMessage + "\", ");
        sbJsonResponse.append("\"ErrorCode\": \"" + errorCode + "\" }");
        return sbJsonResponse.toString();
    }
}

