/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.annotations;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import de.unibonn.iai.eis.luzzu.cache.JenaCacheObject;
import de.unibonn.iai.eis.luzzu.datatypes.ProblemList;
import de.unibonn.iai.eis.luzzu.properties.PropertyManager;
import de.unibonn.iai.eis.luzzu.semantics.utilities.Commons;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.QPRO;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public class QualityReport {
    protected String TDB_DIRECTORY = PropertyManager.getInstance().getProperties("directories.properties").getProperty("TDB_TEMP_BASE_DIR") + "tdb_" + UUID.randomUUID().toString() + "/";
    protected Dataset dataset = TDBFactory.createDataset((String)this.TDB_DIRECTORY);

    public QualityReport() {
        TDB.sync((Dataset)this.dataset);
        this.dataset.begin(ReadWrite.WRITE);
        this.dataset.getDefaultModel().removeAll();
    }

    public String createQualityProblem(Resource metricURI, ProblemList<?> problemList) {
        Model m = ModelFactory.createDefaultModel();
        String genGraph = Commons.generateURI().toString();
        Object oneObject = problemList.getProblemList().iterator().next();
        if (problemList != null && problemList.getProblemList().size() > 0 && oneObject instanceof Quad) {
            for (Object obj : problemList.getProblemList()) {
                Resource problemURI = Commons.generateURI();
                m.add((Statement)new StatementImpl(problemURI, RDF.type, (RDFNode)QPRO.QualityProblem));
                m.add((Statement)new StatementImpl(problemURI, QPRO.isDescribedBy, (RDFNode)metricURI));
                Resource bNode = Commons.generateRDFBlankNode().asResource();
                m.add((Statement)new StatementImpl(problemURI, QPRO.problematicThing, (RDFNode)bNode));
                Object _obj = obj;
                if (obj instanceof JenaCacheObject) {
                    _obj = ((JenaCacheObject)obj).deserialise();
                }
                Quad q = (Quad)_obj;
                m.add((Statement)new StatementImpl(bNode, RDF.type, (RDFNode)RDF.Statement));
                m.add((Statement)new StatementImpl(bNode, RDF.subject, Commons.asRDFNode((Node)q.getSubject())));
                m.add((Statement)new StatementImpl(bNode, RDF.predicate, Commons.asRDFNode((Node)q.getPredicate())));
                m.add((Statement)new StatementImpl(bNode, RDF.object, Commons.asRDFNode((Node)q.getObject())));
                if (q.getGraph() == null) continue;
                m.add((Statement)new StatementImpl(bNode, QPRO.inGraph, Commons.asRDFNode((Node)q.getGraph())));
            }
        } else if (problemList != null && problemList.getProblemList().size() > 0 && oneObject instanceof Model) {
            for (Object obj : problemList.getProblemList()) {
                Resource problemURI = Commons.generateURI();
                m.add((Statement)new StatementImpl(problemURI, RDF.type, (RDFNode)QPRO.QualityProblem));
                m.add((Statement)new StatementImpl(problemURI, QPRO.isDescribedBy, (RDFNode)metricURI));
                Object _obj = obj;
                if (obj instanceof JenaCacheObject) {
                    _obj = ((JenaCacheObject)obj).deserialise();
                }
                Model qpModel = (Model)_obj;
                Resource sNode = (Resource)qpModel.listSubjects().next();
                m.add((Statement)new StatementImpl(problemURI, QPRO.problematicThing, (RDFNode)sNode));
                m.add(qpModel);
            }
        } else {
            Seq problemSeq = m.createSeq();
            int i = 1;
            Iterator i$ = problemList.getProblemList().iterator();
            while (i$.hasNext()) {
                Object obj;
                Object _obj = obj = i$.next();
                if (obj instanceof JenaCacheObject) {
                    _obj = ((JenaCacheObject)obj).deserialise();
                }
                Resource r = (Resource)_obj;
                problemSeq.add(i, (RDFNode)r);
                ++i;
            }
            Resource problemURI = Commons.generateURI();
            m.add((Statement)new StatementImpl(problemURI, RDF.type, (RDFNode)QPRO.QualityProblem));
            m.add((Statement)new StatementImpl(problemURI, QPRO.isDescribedBy, (RDFNode)metricURI));
            m.add((Statement)new StatementImpl(problemURI, QPRO.problematicThing, (RDFNode)problemSeq));
        }
        this.dataset.addNamedModel(genGraph, m);
        return genGraph;
    }

    public Model createQualityReport(Resource computedOn, List<String> problemReportModels) {
        Model m = this.dataset.getDefaultModel();
        Resource reportURI = Commons.generateURI();
        m.add((Statement)new StatementImpl(reportURI, RDF.type, (RDFNode)QPRO.QualityReport));
        m.add((Statement)new StatementImpl(reportURI, QPRO.computedOn, (RDFNode)computedOn));
        for (String prModelURI : problemReportModels) {
            Model prModel = this.getProblemReportFromTBD(prModelURI);
            for (Resource r : this.getProblemURI(prModel)) {
                m.add((Statement)new StatementImpl(reportURI, QPRO.hasProblem, (RDFNode)r));
                m.add(prModel);
            }
            this.dataset.removeNamedModel(prModelURI);
        }
        return m;
    }

    public List<Resource> getProblemURI(Model problemReport) {
        return problemReport.listSubjectsWithProperty(RDF.type, (RDFNode)QPRO.QualityProblem).toList();
    }

    public Model getProblemReportFromTBD(String problemModelURI) {
        return this.dataset.getNamedModel(problemModelURI);
    }

    public void flush() {
        this.dataset.commit();
        this.dataset.close();
        File f = new File(this.TDB_DIRECTORY);
        f.delete();
    }
}

