/*
 * Decompiled with CFR 0.152.
 */
package de.unibonn.iai.eis.luzzu.annotations;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.vocabulary.RDF;
import de.unibonn.iai.eis.luzzu.assessment.QualityMetric;
import de.unibonn.iai.eis.luzzu.cache.CacheManager;
import de.unibonn.iai.eis.luzzu.cache.impl.TemporaryGraphMetadataCacheObject;
import de.unibonn.iai.eis.luzzu.exceptions.MetadataException;
import de.unibonn.iai.eis.luzzu.properties.PropertyManager;
import de.unibonn.iai.eis.luzzu.semantics.utilities.Commons;
import de.unibonn.iai.eis.luzzu.semantics.utilities.DAQHelper;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.CUBE;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.DAQ;
import de.unibonn.iai.eis.luzzu.semantics.vocabularies.SDMXDIMENSION;

public class QualityMetadata {
    private final CacheManager cacheMgr = CacheManager.getInstance();
    private final String cacheName = PropertyManager.getInstance().getProperties("cache.properties").getProperty("GRAPH_METADATA_CACHE");
    private Model metadata = ModelFactory.createDefaultModel();
    private Resource qualityGraph;
    boolean metadataPresent = false;
    private TemporaryGraphMetadataCacheObject _temp = null;
    private Resource computedOn;
    private static final Property timePeriod = ModelFactory.createDefaultModel().createProperty("http://purl.org/linked-data/sdmx/2009/dimension#timePeriod");

    public QualityMetadata(Resource datasetURI, boolean sparqlEndpoint) {
        this.computedOn = datasetURI;
        if (sparqlEndpoint) {
            // empty if block
        }
        if (this.cacheMgr.existsInCache(this.cacheName, (Object)datasetURI)) {
            this._temp = (TemporaryGraphMetadataCacheObject)this.cacheMgr.getFromCache(this.cacheName, (Object)datasetURI);
            this.qualityGraph = this._temp.getGraphURI();
            this.metadata.add(this._temp.getMetadataModel());
            this.metadataPresent = true;
        } else {
            this.qualityGraph = Commons.generateURI();
        }
    }

    public QualityMetadata(Dataset dataset, Resource computedOn) {
        this.computedOn = computedOn;
        ResIterator qualityGraphRes = dataset.getDefaultModel().listSubjectsWithProperty(RDF.type, (RDFNode)DAQ.QualityGraph);
        if (qualityGraphRes.hasNext()) {
            this.qualityGraph = (Resource)qualityGraphRes.next();
            this.metadata.add(dataset.getNamedModel(this.qualityGraph.getURI()));
            this.metadataPresent = true;
        } else {
            this.qualityGraph = Commons.generateURI();
        }
    }

    public void addMetricData(QualityMetric metric) {
        Resource metricType;
        Resource metricURI;
        Resource dimensionType;
        Resource dimensionURI;
        Resource categoryType = DAQHelper.getCategoryResource((Resource)metric.getMetricURI());
        Resource categoryURI = this.categoryExists(categoryType);
        if (categoryURI == null) {
            categoryURI = Commons.generateURI();
            this.metadata.add(categoryURI, RDF.type, (RDFNode)categoryType);
        }
        if ((dimensionURI = this.dimensionExists(dimensionType = DAQHelper.getDimensionResource((Resource)metric.getMetricURI()))) == null) {
            dimensionURI = Commons.generateURI();
            Property dimensionProperty = this.metadata.createProperty(DAQHelper.getPropertyResource((Resource)dimensionType).getURI());
            this.metadata.add(categoryURI, dimensionProperty, (RDFNode)dimensionURI);
            this.metadata.add(dimensionURI, RDF.type, (RDFNode)dimensionType);
        }
        if ((metricURI = this.metricExists(metricType = metric.getMetricURI())) == null) {
            metricURI = Commons.generateURI();
            Property metricProperty = this.metadata.createProperty(DAQHelper.getPropertyResource((Resource)metricType).getURI());
            this.metadata.add(dimensionURI, metricProperty, (RDFNode)metricURI);
            this.metadata.add(metricURI, RDF.type, (RDFNode)metricType);
        }
        Resource observationURI = Commons.generateURI();
        this.metadata.add(metricURI, DAQ.hasObservation, (RDFNode)observationURI);
        this.metadata.add(observationURI, RDF.type, (RDFNode)CUBE.Observation);
        this.metadata.add(observationURI, SDMXDIMENSION.timePeriod, (RDFNode)Commons.generateCurrentTime());
        this.metadata.add(observationURI, DAQ.metric, (RDFNode)metricURI);
        this.metadata.add(observationURI, DAQ.computedOn, (RDFNode)this.computedOn);
        this.metadata.add(observationURI, DAQ.value, (RDFNode)Commons.generateDoubleTypeLiteral((double)metric.metricValue()));
        this.metadata.add(observationURI, DAQ.isEstimate, (RDFNode)Commons.generateBooleanTypeLiteral((boolean)metric.isEstimate()));
        this.metadata.add(observationURI, CUBE.dataSet, (RDFNode)this.qualityGraph);
    }

    public Dataset createQualityMetadata() throws MetadataException {
        Model defaultModel = ModelFactory.createDefaultModel();
        DatasetImpl dataset = null;
        if (this.metadata.size() == 0L) {
            throw new MetadataException("No Metric Observations Recorded");
        }
        defaultModel.add(this.qualityGraph, RDF.type, (RDFNode)DAQ.QualityGraph);
        defaultModel.add(this.qualityGraph, CUBE.structure, (RDFNode)DAQ.dsd);
        dataset = new DatasetImpl(defaultModel);
        dataset.addNamedModel(this.qualityGraph.getURI(), this.metadata);
        return dataset;
    }

    private Resource categoryExists(Resource categoryType) {
        ResIterator resIte = this.metadata.listSubjectsWithProperty(RDF.type, (RDFNode)categoryType);
        if (resIte.hasNext()) {
            return (Resource)resIte.next();
        }
        return null;
    }

    private Resource dimensionExists(Resource dimensionType) {
        ResIterator resIte = this.metadata.listSubjectsWithProperty(RDF.type, (RDFNode)dimensionType);
        if (resIte.hasNext()) {
            return (Resource)resIte.next();
        }
        return null;
    }

    private Resource metricExists(Resource metricType) {
        ResIterator resIte = this.metadata.listSubjectsWithProperty(RDF.type, (RDFNode)metricType);
        if (resIte.hasNext()) {
            return (Resource)resIte.next();
        }
        return null;
    }
}

