/*
 * Decompiled with CFR 0.152.
 */
package xcsf.listener;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import xcsf.MatchSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;

public class ProgressGUI
extends JPanel
implements XCSFListener {
    private static final long serialVersionUID = 4032546909186449011L;
    private JProgressBar progressBar = new JProgressBar(0, 100);

    public ProgressGUI(boolean createJFrame) {
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        super.add(this.progressBar);
        if (createJFrame) {
            JFrame f = new JFrame("Progress");
            f.setDefaultCloseOperation(3);
            f.setContentPane(this);
            f.pack();
            f.setResizable(false);
            f.setLocation(200, 300);
            f.setVisible(true);
        }
    }

    public void nextExperiment(int experiment, String functionName) {
        this.progressBar.setValue(0);
    }

    public void stateChanged(int iteration, Population population, MatchSet matchSet, StateDescriptor state, double[][] performance) {
        int progress = (int)(100.0 * (double)iteration / (double)XCSFConstants.maxLearningIterations);
        if (progress == this.progressBar.getValue()) {
            return;
        }
        this.progressBar.setValue(progress);
    }
}

