/*
 * Decompiled with CFR 0.152.
 */
package xcsf.listener;

import java.io.File;
import java.io.FileNotFoundException;
import xcsf.MatchSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;
import xcsf.XCSFUtils;

public class PopulationWriter
implements XCSFListener {
    private int interval;
    private int exp;
    private String path;
    private String name;

    public PopulationWriter(String path) {
        this(path, -1);
    }

    public PopulationWriter(String path, int interval) {
        this.path = XCSFUtils.checkPath(path);
        this.interval = interval;
    }

    public void nextExperiment(int experiment, String functionName) {
        this.exp = experiment;
        this.name = functionName;
    }

    public void stateChanged(int iteration, Population population, MatchSet matchSet, StateDescriptor state, double[][] performance) {
        if (this.interval == -1 && iteration != XCSFConstants.maxLearningIterations) {
            return;
        }
        if (iteration % this.interval != 0) {
            return;
        }
        String itString = String.valueOf(iteration / 1000);
        String expString = this.exp < 10 ? "0" + this.exp : "" + this.exp;
        while (itString.length() < String.valueOf(XCSFConstants.maxLearningIterations / 1000).length()) {
            itString = "0" + itString;
        }
        String filename = this.path + this.name + "-exp" + expString + "-it" + itString + "k";
        try {
            population.writePopulation(new File(filename + ".population"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

