/*
 * Decompiled with CFR 0.152.
 */
package xcsf.listener;

import xcsf.MatchSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSF;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;
import xcsf.XCSFUtils;

public class PerformanceWriter
implements XCSFListener {
    private XCSF xcsfLink;
    private int exp;
    private String path;
    private String name;

    public PerformanceWriter(String path, XCSF xcsfLink) {
        this.path = XCSFUtils.checkPath(path);
        this.xcsfLink = xcsfLink;
    }

    public void nextExperiment(int experiment, String functionName) {
        this.exp = experiment;
        this.name = functionName;
    }

    public void stateChanged(int iteration, Population population, MatchSet matchSet, StateDescriptor state, double[][] performance) {
        if (this.exp != XCSFConstants.numberOfExperiments - 1 || iteration != XCSFConstants.maxLearningIterations) {
            return;
        }
        String performanceFilename = this.path + this.name + "-performance";
        this.xcsfLink.writePerformance(performanceFilename);
    }
}

