/*
 * Decompiled with CFR 0.152.
 */
package xcsf.listener;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import xcsf.MatchSet;
import xcsf.PerformanceEvaluator;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;

public class PerformanceGUI
extends JPanel
implements XCSFListener,
ActionListener {
    private static final long serialVersionUID = -4733325521262879112L;
    static final Color[] COLORS = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA, Color.CYAN, Color.ORANGE, Color.PINK, Color.YELLOW};
    private PerformancePanel panel;
    private JCheckBoxMenuItem[] checkBoxes;
    private JLabel[] checkBoxLabels;
    private GraphIcon[] checkBoxGraphs;
    private JPopupMenu menu = new JPopupMenu("Graphs");

    public PerformanceGUI(boolean createJFrame) {
        super(new BorderLayout());
        this.panel = new PerformancePanel();
        super.add((Component)this.panel, "Center");
        JButton showButton = new JButton("show");
        showButton.addActionListener(this);
        JPanel keyPanel = new JPanel();
        keyPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipadx = 5;
        gbc.ipady = 0;
        gbc.fill = 1;
        this.checkBoxes = new JCheckBoxMenuItem[PerformanceEvaluator.HEADER.length - 1];
        this.checkBoxLabels = new JLabel[PerformanceEvaluator.HEADER.length - 1];
        this.checkBoxGraphs = new GraphIcon[PerformanceEvaluator.HEADER.length - 1];
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            boolean selected = i < 2 || i == 3 || i == 7;
            this.checkBoxes[i] = new JCheckBoxMenuItem(PerformanceEvaluator.HEADER[i + 1], selected);
            this.checkBoxes[i].addActionListener(this);
            this.menu.add(this.checkBoxes[i]);
            ++gbc.gridy;
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.checkBoxLabels[i] = new JLabel(PerformanceEvaluator.HEADER[i + 1]);
            this.checkBoxLabels[i].setHorizontalAlignment(4);
            keyPanel.add((Component)this.checkBoxLabels[i], gbc);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.checkBoxGraphs[i] = new GraphIcon();
            keyPanel.add((Component)this.checkBoxGraphs[i], gbc);
            gbc.gridx = 0;
        }
        JPanel east = new JPanel(new BorderLayout());
        east.setBackground(Color.WHITE);
        keyPanel.setBackground(Color.WHITE);
        east.add((Component)keyPanel, "North");
        east.add((Component)showButton, "South");
        super.add((Component)east, "East");
        super.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        this.actionPerformed(null);
        if (createJFrame) {
            JFrame f = new JFrame("Performance");
            f.setDefaultCloseOperation(3);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int xSize = (int)(0.5 * screen.getWidth());
            int ySize = (int)(0.5 * screen.getHeight());
            f.setPreferredSize(new Dimension(xSize, ySize));
            f.setLocation(0, 0);
            f.setContentPane(this);
            f.pack();
            f.setVisible(true);
        }
    }

    public void nextExperiment(int experiment, String functionName) {
    }

    public void stateChanged(int iteration, Population population, MatchSet matchSet, StateDescriptor state, double[][] performance) {
        if (iteration % XCSFConstants.averageExploitTrials != 0) {
            return;
        }
        double[][] p = new double[iteration / XCSFConstants.averageExploitTrials][];
        for (int i = 0; i < performance.length && performance[i] != null; ++i) {
            p[i] = new double[performance[i].length + 1];
            p[i][0] = i * XCSFConstants.averageExploitTrials;
            for (int k = 0; k < performance[i].length; ++k) {
                p[i][k + 1] = performance[i][k];
            }
        }
        this.panel.setValues(p);
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (e != null && e.getActionCommand().equals("show")) {
            JButton source = (JButton)e.getSource();
            this.menu.show(source, ((Component)source).getX(), ((Component)source).getY());
        }
        int labelIndex = 0;
        int colorIndex = 0;
        boolean[] paint = new boolean[this.checkBoxes.length];
        for (int i = 0; i < PerformanceEvaluator.HEADER.length - 1; ++i) {
            if (this.checkBoxes[i].isSelected()) {
                paint[i] = true;
                this.checkBoxLabels[labelIndex].setText(PerformanceEvaluator.HEADER[i + 1]);
                this.checkBoxGraphs[labelIndex].setGraphColor(COLORS[colorIndex]);
                ++labelIndex;
                colorIndex = (colorIndex + 1) % COLORS.length;
                continue;
            }
            paint[i] = false;
        }
        while (labelIndex < this.checkBoxLabels.length) {
            this.checkBoxLabels[labelIndex].setText("");
            this.checkBoxGraphs[labelIndex].unsetGraphColor();
            ++labelIndex;
        }
        this.panel.setPaint(paint);
        this.repaint();
    }

    protected static class GraphIcon
    extends JLabel {
        private static final long serialVersionUID = -5886509743106152982L;
        private Color graphColor;

        public GraphIcon() {
            super.setPreferredSize(new Dimension(30, 3));
            super.setOpaque(false);
            super.setBackground(Color.WHITE);
            this.graphColor = null;
        }

        void setGraphColor(Color c) {
            this.graphColor = c;
        }

        void unsetGraphColor() {
            this.graphColor = null;
        }

        public void paint(Graphics g) {
            if (this.graphColor == null) {
                return;
            }
            g.setColor(this.graphColor);
            int h = this.getHeight() / 2;
            g.drawLine((int)((double)this.getWidth() * 0.1), h, (int)((double)this.getWidth() * 0.9), h);
        }
    }

    protected static class PerformancePanel
    extends JPanel {
        private static final long serialVersionUID = 5812972979641014423L;
        private static final int[] X_OFFSET = new int[]{50, 20};
        private static final int[] Y_OFFSET = new int[]{30, 10};
        private static final int X_TICS = 10;
        private double xMinValue;
        private double xMaxValue;
        private double yMinValue;
        private double yMaxValue;
        private int xMin;
        private int xMax;
        private int yMin;
        private int yMax;
        private boolean[] paint;
        private double[][] values;

        protected PerformancePanel() {
        }

        void setValues(double[][] values) {
            int length1 = values.length;
            int length2 = values[0].length - 1;
            this.values = new double[length1][];
            for (int i = 0; i < length1; ++i) {
                this.values[i] = new double[length2 + 1];
                this.values[i][0] = values[i][0];
                for (int k = 1; k <= length2; ++k) {
                    this.values[i][k] = Math.log10(values[i][k]);
                }
            }
            this.initMinMaxValues();
        }

        void setPaint(boolean[] paint) {
            this.paint = paint;
            if (this.values != null) {
                this.initMinMaxValues();
            }
        }

        public void paint(Graphics g) {
            this.xMax = this.getWidth() - X_OFFSET[1];
            this.yMax = this.getHeight() - Y_OFFSET[0];
            this.xMin = X_OFFSET[0];
            this.yMin = Y_OFFSET[1];
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.values == null) {
                return;
            }
            g.setColor(Color.BLACK);
            this.drawAxis(g);
            int colorIndex = 0;
            for (int i = 0; i < this.paint.length; ++i) {
                if (!this.paint[i]) continue;
                g.setColor(COLORS[colorIndex]);
                colorIndex = (colorIndex + 1) % COLORS.length;
                this.drawValues(i + 1, g);
                if (i != PerformanceEvaluator.HEADER.length - 2) continue;
                for (int k = i + 2; k < this.values[0].length; ++k) {
                    this.drawValues(k, g);
                }
            }
        }

        private void drawAxis(Graphics g) {
            int xLow = this.translateX(this.xMinValue);
            int yLow = this.translateY(this.yMinValue);
            int xHigh = this.translateX(this.xMaxValue);
            int yHigh = this.translateY(this.yMaxValue);
            for (int i = 0; i <= 10; ++i) {
                double percent = (double)i / 10.0;
                int x = xLow + (int)(percent * (double)(xHigh - xLow));
                int it = (int)(percent * (double)XCSFConstants.maxLearningIterations);
                String text = it <= 1000 ? it + "" : it / 1000 + "k";
                g.drawString(text, x - text.length() * 4, yLow + Y_OFFSET[0] - 5);
                g.drawLine(x, yLow, x, yLow - 5);
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(x, yLow - 5, x, yHigh);
                g.setColor(Color.BLACK);
            }
            g.drawLine(xLow, yLow, xHigh, yLow);
            int exp = (int)this.yMaxValue + 1;
            while ((double)exp > this.yMinValue) {
                --exp;
                for (int i = 9; i > 0; --i) {
                    int y = this.translateY((double)exp + Math.log10(i));
                    if (y < this.yMin || y > this.yMax) continue;
                    if (i == 1) {
                        y = this.translateY(exp);
                        String text = "";
                        if (exp >= 0 && exp <= 3) {
                            text = "" + (int)Math.pow(10.0, exp);
                        } else if (exp > -4 && exp < 0) {
                            text = "" + Math.pow(10.0, exp);
                            while (text.endsWith("0")) {
                                text = text.substring(0, text.length() - 1);
                            }
                        } else {
                            text = "10^" + exp;
                        }
                        g.drawString(text, xLow - X_OFFSET[0] + 5, y + 5);
                        if (y == yLow) continue;
                        g.drawLine(xLow, y, xLow + 10, y);
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(xLow + 10, y, xHigh, y);
                        g.setColor(Color.BLACK);
                        continue;
                    }
                    g.drawLine(xLow, y, xLow + 5, y);
                }
            }
            g.drawLine(xLow, yLow, xLow, yHigh);
            g.setColor(Color.ORANGE);
            int epsilon = this.translateY(Math.log10(XCSFConstants.epsilon_0));
            g.drawLine(xLow, epsilon, xHigh, epsilon);
        }

        private void drawValues(int index, Graphics g) {
            int x1 = this.translateX(this.values[0][0]);
            int y1 = this.translateY(this.values[0][index]);
            for (int i = 1; i < this.values.length; ++i) {
                if (this.values == null || this.values[i] == null) {
                    return;
                }
                int x2 = this.translateX(this.values[i][0]);
                int y2 = this.translateY(this.values[i][index]);
                if (x1 < x2) {
                    g.drawLine(x1, y1, x2, y2);
                }
                x1 = x2;
                y1 = y2;
            }
        }

        private void initMinMaxValues() {
            this.xMinValue = 0.0;
            this.xMaxValue = XCSFConstants.maxLearningIterations;
            this.yMinValue = XCSFConstants.epsilon_0;
            this.yMaxValue = Double.MIN_VALUE;
            for (double[] row : this.values) {
                for (int i = 0; i < this.paint.length; ++i) {
                    if (!this.paint[i]) continue;
                    if (row[i + 1] > this.yMaxValue) {
                        this.yMaxValue = row[i + 1];
                    }
                    if (!(row[i + 1] < this.yMinValue)) continue;
                    this.yMinValue = row[i + 1];
                }
            }
            this.yMaxValue = (int)this.yMaxValue + 1;
            this.yMinValue = (int)this.yMinValue - 1;
        }

        private int translateX(double x) {
            double tmp = (x - this.xMinValue) / (this.xMaxValue - this.xMinValue);
            return (int)((double)this.xMin + (double)(this.xMax - this.xMin) * tmp);
        }

        private int translateY(double y) {
            double tmp = 1.0 - (y - this.yMinValue) / (this.yMaxValue - this.yMinValue);
            return (int)((double)this.yMin + (double)(this.yMax - this.yMin) * tmp);
        }
    }
}

