/*
 * Decompiled with CFR 0.152.
 */
package xcsf.listener;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import xcsf.MatchSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;
import xcsf.XCSFUtils;
import xcsf.listener.ConditionsGUI2D3D;
import xcsf.listener.PredictionPlot;

public class OutputWriter2D
implements XCSFListener {
    private static final int IMAGE_SIZE = 800;
    private static final String EXTENSION = "png";
    private boolean onlyFirstExp;
    private int interval;
    private double relativeConditionSize;
    private double transparency;
    private int exp;
    private String path;
    private String name;
    private String tmpFilename;

    public OutputWriter2D(String path, boolean onlyFirstExperiment, int interval, double relativeConditionSize, double transparency) {
        this.path = XCSFUtils.checkPath(path);
        this.onlyFirstExp = onlyFirstExperiment;
        this.interval = interval > 0 ? interval : XCSFConstants.maxLearningIterations;
        this.relativeConditionSize = relativeConditionSize;
        this.transparency = transparency;
        try {
            File tmpfile = File.createTempFile(this.getClass().getSimpleName(), "gnuplot");
            tmpfile.deleteOnExit();
            this.tmpFilename = tmpfile.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void nextExperiment(int experiment, String functionName) {
        this.exp = experiment;
        this.name = functionName;
    }

    public void stateChanged(int iteration, Population population, MatchSet matchSet, StateDescriptor state, double[][] performance) {
        if (iteration % this.interval != 0) {
            return;
        }
        if (this.onlyFirstExp && this.exp != 0) {
            return;
        }
        int dim = population.get(0).getCondition().getCenter().length;
        if (dim != 2) {
            return;
        }
        String filename = this.path + this.name;
        if (!this.onlyFirstExp) {
            String expString = this.exp < 10 ? "0" + this.exp : "" + this.exp;
            filename = filename + expString;
        }
        if (this.interval != XCSFConstants.maxLearningIterations) {
            filename = filename + "-" + iteration;
        }
        this.createConditionImage2D(population, matchSet, state, filename);
        this.createPredictionPlot(population, iteration, filename);
    }

    private void createConditionImage2D(Population population, MatchSet matchSet, StateDescriptor state, String filename) {
        float guiTransparency = ConditionsGUI2D3D.visualizationTransparency;
        float guiSize = ConditionsGUI2D3D.visualizedConditionSize;
        ConditionsGUI2D3D.visualizationTransparency = Math.max(Math.min((float)this.transparency, 1.0f), 0.0f);
        ConditionsGUI2D3D.visualizedConditionSize = Math.max(Math.min((float)this.relativeConditionSize, 1.0f), 0.0f);
        BufferedImage img = ConditionsGUI2D3D.Visualization2D.createImage2D(population, matchSet, state, false, 800);
        filename = filename + "-pop";
        try {
            ImageIO.write((RenderedImage)img, EXTENSION, new File(filename + "." + EXTENSION));
        }
        catch (IOException e) {
            System.err.println(this.getClass().getSimpleName() + ": " + e.getMessage());
        }
        ConditionsGUI2D3D.visualizationTransparency = guiTransparency;
        ConditionsGUI2D3D.visualizedConditionSize = guiSize;
    }

    private void createPredictionPlot(Population population, int iteration, String filename) {
        filename = filename + "-pred";
        try {
            XCSFUtils.Gnuplot gnuplot = new XCSFUtils.Gnuplot();
            for (String cmd : PredictionPlot.GNUPLOT_CMD) {
                gnuplot.execute(cmd);
            }
            PredictionPlot.createIsoamples(population, this.tmpFilename);
            gnuplot.execute("set term postscript eps enhanced color");
            gnuplot.execute("set out '" + filename + ".eps'");
            gnuplot.execute("set title 'iteration " + iteration + "'");
            gnuplot.execute("splot '" + this.tmpFilename + "' title 'prediction'");
            gnuplot.execute("save '" + filename + ".plt'");
            gnuplot.close();
            XCSFUtils.FileIO.fileCopy(new File(this.tmpFilename), new File(filename + ".dat"));
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

