/*
 * Decompiled with CFR 0.152.
 */
package xcsf.listener;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xcsf.MatchSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSF;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;
import xcsf.classifier.Classifier;
import xcsf.classifier.Condition;
import xcsf.classifier.ConditionEllipsoid;
import xcsf.classifier.ConditionRectangle;
import xcsf.classifier.ConditionRotatingEllipsoid;
import xcsf.classifier.ConditionRotatingRectangle;
import xcsf.listener.ConditionVisualization3D;

public class ConditionsGUI2D3D
extends JFrame
implements XCSFListener,
ChangeListener,
ActionListener,
ComponentListener,
WindowStateListener {
    private static final long serialVersionUID = 2272880085308642254L;
    private static final int MIN_STEPS = 1;
    private static final int MAX_STEPS = 1000;
    private static final int MIN_DELAY = 0;
    private static final int MAX_DELAY = 5000;
    public static int visualizationSteps = XCSFConstants.averageExploitTrials;
    public static int visualizationDelay = 0;
    public static float visualizedConditionSize = 0.2f;
    public static float visualizationTransparency = 0.2f;
    public static boolean slowMotion = false;
    private JSlider slider1;
    private JSlider slider2;
    private JSlider slider3;
    private JSlider slider4;
    private JToggleButton slowModeButton;
    private int fastMotionSteps;
    private JLabel bottomLabel;
    private ConditionVisualization conditionVis;

    public ConditionsGUI2D3D() {
        super("Condition Visualization");
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int xSize = (int)(0.5 * screen.getWidth());
        int ySize = (int)(1.0 * screen.getHeight());
        this.setBounds(0, 0, xSize, ySize);
        this.setLocation((int)screen.getWidth() - xSize, 0);
    }

    public void nextExperiment(int experiment, String functionName) {
    }

    public void stateChanged(int iteration, Population population, MatchSet matchSet, StateDescriptor state, double[][] performance) {
        if (this.conditionVis == null) {
            int dim = population.get(0).getCondition().getCenter().length;
            if (dim < 2 || dim > 3) {
                System.err.println(ConditionsGUI2D3D.class.getName() + ": illegal dimension (" + dim + ")");
                return;
            }
            JPanel contentPane = new JPanel(new BorderLayout());
            if (this.init(dim, contentPane)) {
                super.setContentPane(contentPane);
                super.setVisible(true);
            } else {
                System.err.println(ConditionsGUI2D3D.class.getName() + ": Dimension==3, but Java3d is not installed.");
            }
        } else {
            if (iteration % visualizationSteps != 0 && !slowMotion) {
                return;
            }
            if (this.getExtendedState() == 1 || !this.conditionVis.isShowing()) {
                return;
            }
        }
        this.bottomLabel.setText("Iteration: " + iteration + ", MacroClassifiers: " + population.size());
        this.conditionVis.repaintNow(population, matchSet, state);
        try {
            Thread.sleep(visualizationDelay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        slowMotion = this.slowModeButton.isSelected();
        if (slowMotion) {
            this.fastMotionSteps = visualizationSteps;
            this.slider1.setValue(1);
        } else if (this.fastMotionSteps > 1) {
            visualizationSteps = this.fastMotionSteps;
            this.slider1.setValue(this.fastMotionSteps);
        }
        this.slider1.setEnabled(!slowMotion);
        this.repaint();
        this.conditionVis.repaintSoon();
    }

    public void stateChanged(ChangeEvent e) {
        if (!((JSlider)e.getSource()).getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.slider1)) {
            visualizationSteps = this.slider1.getValue();
        } else if (e.getSource().equals(this.slider2)) {
            visualizationDelay = this.slider2.getValue();
        } else if (e.getSource().equals(this.slider3)) {
            visualizedConditionSize = (float)this.slider3.getValue() / 100.0f;
        } else if (e.getSource().equals(this.slider4)) {
            visualizationTransparency = (float)this.slider4.getValue() / 100.0f;
        }
        this.repaint();
        this.conditionVis.repaintSoon();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.conditionVis.repaintSoon();
    }

    public void componentShown(ComponentEvent e) {
        this.conditionVis.repaintSoon();
    }

    public void windowStateChanged(WindowEvent e) {
        this.conditionVis.repaintSoon();
    }

    private boolean init(int dimension, JPanel contentpane) {
        JPanel top = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.slowModeButton = new JToggleButton("Show Matchset", slowMotion);
        this.slowModeButton.addActionListener(this);
        c.gridheight = 2;
        top.add((Component)this.slowModeButton, c);
        c.gridheight = 1;
        ++c.gridx;
        if (visualizationSteps > 1000) {
            visualizationSteps = 1000;
        } else if (visualizationSteps < 1) {
            visualizationSteps = 1;
        }
        this.slider1 = new JSlider(1, 1000, visualizationSteps);
        this.slider1.setMajorTickSpacing(999);
        this.slider1.setMinorTickSpacing(100);
        this.slider1.setPaintTicks(true);
        this.slider1.setPaintLabels(true);
        this.slider1.setEnabled(!slowMotion);
        this.slider1.addChangeListener(this);
        top.add((Component)new JLabel("Visualization Steps", 0), c);
        ++c.gridy;
        top.add((Component)this.slider1, c);
        c.gridy = 0;
        ++c.gridx;
        if (visualizationDelay > 5000) {
            visualizationDelay = 5000;
        } else if (visualizationDelay < 0) {
            visualizationDelay = 0;
        }
        this.slider2 = new JSlider(0, 5000, visualizationDelay);
        this.slider2.setMajorTickSpacing(2500);
        this.slider2.setMinorTickSpacing(500);
        this.slider2.setPaintLabels(true);
        this.slider2.setPaintTicks(true);
        this.slider2.addChangeListener(this);
        top.add((Component)new JLabel("Visualization Delay (ms)", 0), c);
        ++c.gridy;
        top.add((Component)this.slider2, c);
        c.gridy = 0;
        ++c.gridx;
        if (visualizedConditionSize > 1.0f) {
            visualizedConditionSize = 1.0f;
        } else if (visualizedConditionSize < 0.0f) {
            visualizedConditionSize = 0.0f;
        }
        this.slider3 = new JSlider(0, 100, (int)(visualizedConditionSize * 100.0f));
        this.slider3.setMajorTickSpacing(50);
        this.slider3.setMinorTickSpacing(10);
        this.slider3.setPaintLabels(true);
        this.slider3.setPaintTicks(true);
        this.slider3.addChangeListener(this);
        top.add((Component)new JLabel("Condition Size (%)", 0), c);
        ++c.gridy;
        top.add((Component)this.slider3, c);
        c.gridy = 0;
        ++c.gridx;
        if (visualizationTransparency > 1.0f) {
            visualizationTransparency = 1.0f;
        } else if (visualizationTransparency < 0.0f) {
            visualizationTransparency = 0.0f;
        }
        this.slider4 = new JSlider(0, 100, (int)(visualizationTransparency * 100.0f));
        this.slider4.setMajorTickSpacing(50);
        this.slider4.setMinorTickSpacing(10);
        this.slider4.setPaintLabels(true);
        this.slider4.setPaintTicks(true);
        this.slider4.addChangeListener(this);
        top.add((Component)new JLabel("Transparency (%)", 0), c);
        ++c.gridy;
        top.add((Component)this.slider4, c);
        top.setBorder(BorderFactory.createEtchedBorder());
        contentpane.add((Component)top, "North");
        if (dimension == 2) {
            this.conditionVis = new Visualization2D();
        } else if (dimension == 3) {
            try {
                XCSF.class.getClassLoader().loadClass("com.sun.j3d.utils.universe.SimpleUniverse");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            this.conditionVis = new ConditionVisualization3D();
        } else {
            throw new IllegalArgumentException("Illegal ConditionVisualization dimension: " + dimension);
        }
        contentpane.add((Component)this.conditionVis, "Center");
        this.bottomLabel = new JLabel("Initializing..", 0);
        this.bottomLabel.setBorder(BorderFactory.createEtchedBorder());
        contentpane.add((Component)this.bottomLabel, "South");
        this.addComponentListener(this);
        this.addWindowStateListener(this);
        return true;
    }

    static class Visualization2D
    extends ConditionVisualization {
        private static final long serialVersionUID = 6199970283187565576L;
        private RepaintTimer repaintTimer;
        private JLabel visLabel = new JLabel();
        Population populationLink;
        MatchSet matchSetLink;
        StateDescriptor stateLink;

        Visualization2D() {
            this.visLabel.setHorizontalAlignment(0);
            this.visLabel.setVerticalAlignment(1);
            super.add(this.visLabel);
            this.repaintTimer = new RepaintTimer();
        }

        void repaintNow(Population population, MatchSet matchSet, StateDescriptor state) {
            this.populationLink = population;
            this.matchSetLink = matchSet;
            this.stateLink = state;
            this.redrawImage();
        }

        void repaintSoon() {
            this.repaintTimer.requestRepaint();
        }

        void redrawImage() {
            if (this.populationLink != null && this.matchSetLink != null && this.stateLink != null) {
                BufferedImage image = Visualization2D.createImage2D(this.populationLink, this.matchSetLink, this.stateLink, slowMotion, Math.min(this.getWidth(), this.getHeight()));
                this.visLabel.setIcon(new ImageIcon(image));
                this.repaint();
                this.repaintTimer.repaintDoneElsewhere();
            }
        }

        static BufferedImage createImage2D(Population population, MatchSet matchSet, StateDescriptor state, boolean showMatchSet, int width) {
            BufferedImage image = new BufferedImage(width, width, 1);
            int margin = (int)(0.05 * (double)width);
            int range = (int)(0.9 * (double)width);
            Graphics g = image.getGraphics();
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.WHITE);
            g2.fillRect(margin, margin, range, range);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f - visualizationTransparency));
            if (!showMatchSet) {
                for (Classifier cl : population) {
                    double fit = cl.getFitness();
                    fit = Math.pow(fit, 0.3);
                    g2.setColor(new Color((int)(255.0 * (0.8 - 0.8 * fit)), (int)(255.0 * (0.8 - 0.8 * fit)), 255));
                    g2.fill(Visualization2D.createShape2D(cl.getCondition(), range, margin));
                }
            } else {
                for (Classifier cl : population) {
                    if (cl.doesMatch(state)) continue;
                    double fit = cl.getFitness();
                    fit = Math.pow(fit, 0.3);
                    g2.setColor(new Color((int)(255.0 * (0.8 - 0.8 * fit)), (int)(255.0 * (0.8 - 0.8 * fit)), 255));
                    g2.fill(Visualization2D.createShape2D(cl.getCondition(), range, margin));
                }
                for (Classifier cl : matchSet) {
                    float act = (float)cl.getActivity(state);
                    g2.setColor(new Color(0.0f, 1.0f, 0.0f, act));
                    Shape shape = Visualization2D.createShape2D(cl.getCondition(), range, margin);
                    g2.fill(shape);
                    g2.setColor(new Color(0.0f, 0.0f, 0.0f, act));
                    g2.draw(shape);
                }
                int x = (int)((double)margin + state.getConditionInput()[0] * (double)range);
                int y = (int)((double)margin + (1.0 - state.getConditionInput()[1]) * (double)range);
                g2.setColor(Color.RED);
                g2.drawLine(x - 5, y - 5, x + 5, y + 5);
                g2.drawLine(x + 5, y - 5, x - 5, y + 5);
            }
            return image;
        }

        private static Shape createShape2D(Condition condition, int range, int offset) {
            if (condition instanceof ConditionEllipsoid) {
                ConditionEllipsoid con = (ConditionEllipsoid)condition;
                double stretchX = (double)visualizedConditionSize * con.getStretch()[0] * 2.0 * (double)range;
                double stretchY = (double)visualizedConditionSize * con.getStretch()[1] * 2.0 * (double)range;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(-0.5 * stretchX, -0.5 * stretchY, stretchX, stretchY);
                AffineTransform at = AffineTransform.getRotateInstance(0.0);
                Shape ellRot = at.createTransformedShape(ellipse);
                at.setToTranslation((double)offset + con.getCenter()[0] * (double)range, (double)offset + (1.0 - con.getCenter()[1]) * (double)range);
                return at.createTransformedShape(ellRot);
            }
            if (condition instanceof ConditionRotatingEllipsoid) {
                ConditionRotatingEllipsoid con = (ConditionRotatingEllipsoid)condition;
                double stretchX = (double)visualizedConditionSize * con.getStretch()[0] * 2.0 * (double)range;
                double stretchY = (double)visualizedConditionSize * con.getStretch()[1] * 2.0 * (double)range;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(-0.5 * stretchX, -0.5 * stretchY, stretchX, stretchY);
                AffineTransform at = AffineTransform.getRotateInstance(-con.getAngles()[0]);
                Shape ellRot = at.createTransformedShape(ellipse);
                at.setToTranslation((double)offset + con.getCenter()[0] * (double)range, (double)offset + (1.0 - con.getCenter()[1]) * (double)range);
                return at.createTransformedShape(ellRot);
            }
            if (condition instanceof ConditionRectangle) {
                ConditionRectangle con = (ConditionRectangle)condition;
                double stretchX = (double)visualizedConditionSize * con.getStretch()[0] * 2.0 * (double)range;
                double stretchY = (double)visualizedConditionSize * con.getStretch()[1] * 2.0 * (double)range;
                Rectangle2D.Double rectangle = new Rectangle2D.Double(-0.5 * stretchX, -0.5 * stretchY, stretchX, stretchY);
                AffineTransform at = AffineTransform.getRotateInstance(0.0);
                Shape rotatedRectanlge = at.createTransformedShape(rectangle);
                at.setToTranslation((double)offset + con.getCenter()[0] * (double)range, (double)offset + (1.0 - con.getCenter()[1]) * (double)range);
                return at.createTransformedShape(rotatedRectanlge);
            }
            if (condition instanceof ConditionRotatingRectangle) {
                ConditionRotatingRectangle con = (ConditionRotatingRectangle)condition;
                double stretchX = (double)visualizedConditionSize * con.getStretch()[0] * 2.0 * (double)range;
                double stretchY = (double)visualizedConditionSize * con.getStretch()[1] * 2.0 * (double)range;
                Rectangle2D.Double rectangle = new Rectangle2D.Double(-0.5 * stretchX, -0.5 * stretchY, stretchX, stretchY);
                AffineTransform at = AffineTransform.getRotateInstance(-con.getAngles()[0]);
                Shape rotatedRectanlge = at.createTransformedShape(rectangle);
                at.setToTranslation((double)offset + con.getCenter()[0] * (double)range, (double)offset + (1.0 - con.getCenter()[1]) * (double)range);
                return at.createTransformedShape(rotatedRectanlge);
            }
            throw new IllegalArgumentException("The condition type '" + condition.getClass().getName() + "' is not supported.");
        }

        class RepaintTimer
        extends RepaintManager {
            RepaintTimer() {
            }

            protected void doPaint() {
                Visualization2D.this.redrawImage();
            }
        }
    }

    static abstract class RepaintManager {
        private static final long PERIOD = 250L;
        private static final int DELAY = 2;
        private Timer timer;
        private RepaintTask delayTask;

        RepaintManager() {
        }

        public synchronized void requestRepaint() {
            this.assertTimer();
            if (this.delayTask.counter < 0) {
                this.delayTask.counter = 2;
            }
        }

        public synchronized void repaintDoneElsewhere() {
            this.assertTimer();
            this.delayTask.counter = -1;
        }

        protected abstract void doPaint();

        private void assertTimer() {
            if (this.timer == null) {
                this.timer = new Timer("XCSFRepaintManager");
                this.delayTask = new RepaintTask();
                this.timer.schedule((TimerTask)this.delayTask, 0L, 250L);
            }
        }

        class RepaintTask
        extends TimerTask {
            protected int counter = -1;

            RepaintTask() {
            }

            public synchronized void run() {
                if (this.counter == 0) {
                    --this.counter;
                    RepaintManager.this.doPaint();
                } else if (this.counter > 0) {
                    --this.counter;
                }
            }
        }
    }

    static abstract class ConditionVisualization
    extends JPanel {
        private static final long serialVersionUID = -5612110860381297504L;

        ConditionVisualization() {
        }

        abstract void repaintNow(Population var1, MatchSet var2, StateDescriptor var3);

        abstract void repaintSoon();
    }
}

