/*
 * Decompiled with CFR 0.152.
 */
package xcsf.listener;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import xcsf.MatchSet;
import xcsf.Population;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.classifier.Classifier;
import xcsf.classifier.Condition;
import xcsf.classifier.ConditionEllipsoid;
import xcsf.classifier.ConditionRectangle;
import xcsf.classifier.ConditionRotatingEllipsoid;
import xcsf.classifier.ConditionRotatingRectangle;
import xcsf.listener.ConditionsGUI2D3D;

class ConditionVisualization3D
extends ConditionsGUI2D3D.ConditionVisualization {
    private static final long serialVersionUID = 2976135848759208115L;
    private static final Color3f BLACK = new Color3f(0.0f, 0.0f, 0.0f);
    private static final float SHININESS = 1.0f;
    private static final Transform3D ZERO_TRANSFORM = new Transform3D(new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    private static double[] array = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private static double[][] matrix = new double[4][4];
    private static Transform3D t3d = new Transform3D();
    private Population populationLink;
    private StateDescriptor stateLink;
    private TransformGroup tgContent;
    private Vector<BranchGroup> conditionBGs = new Vector();
    private Vector<TransformGroup> conditionTGs = new Vector();
    private Vector<Appearance> conditionAps = new Vector();

    ConditionVisualization3D() {
        Canvas3D canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        super.setLayout(new GridLayout(1, 1));
        super.add((Component)canvas3D);
        SimpleUniverse universe = new SimpleUniverse(canvas3D);
        universe.getViewingPlatform().setNominalViewingTransform();
        BranchGroup scene = this.createSceneGraph();
        universe.addBranchGraph(scene);
    }

    void repaintNow(Population population, MatchSet machtSet, StateDescriptor state) {
        this.populationLink = population;
        this.stateLink = state;
        this.repaintSoon();
    }

    void repaintSoon() {
        int index;
        this.adaptSize();
        if (!ConditionsGUI2D3D.slowMotion) {
            for (index = 0; index < this.populationLink.size(); ++index) {
                this.setConditionProperties(index, this.populationLink.get(index), false);
            }
        } else {
            for (index = 0; index < this.populationLink.size(); ++index) {
                Classifier cl = this.populationLink.get(index);
                this.setConditionProperties(index, cl, cl.doesMatch(this.stateLink));
            }
        }
        for (index = this.conditionTGs.size() - 1; index >= this.populationLink.size(); --index) {
            this.conditionTGs.get(index).setTransform(ZERO_TRANSFORM);
        }
    }

    private void adaptSize() {
        int i;
        int num = (int)Math.ceil((double)XCSFConstants.maxPopSize * 0.1);
        while (this.populationLink.size() > this.conditionTGs.size()) {
            Condition con = this.populationLink.get(0).getCondition();
            BranchGroup bg = new BranchGroup();
            bg.setCapability(17);
            for (i = 0; i < num; ++i) {
                TransformGroup tg = new TransformGroup(ZERO_TRANSFORM);
                tg.setCapability(18);
                bg.addChild((Node)tg);
                Appearance ap = new Appearance();
                ap.setCapability(1);
                ap.setCapability(11);
                Box primitive = null;
                if (con instanceof ConditionRectangle) {
                    primitive = new Box(1.0f, 1.0f, 1.0f, 1, ap);
                } else if (con instanceof ConditionRotatingRectangle) {
                    primitive = new Box(1.0f, 1.0f, 1.0f, 1, ap);
                } else if (con instanceof ConditionEllipsoid) {
                    primitive = new Sphere(1.0f, 1, ap);
                } else if (con instanceof ConditionRotatingEllipsoid) {
                    primitive = new Sphere(1.0f, 1, ap);
                } else {
                    throw new IllegalArgumentException("Unkown Condition: " + con);
                }
                tg.addChild((Node)primitive);
                this.conditionTGs.add(tg);
                this.conditionAps.add(ap);
            }
            this.conditionBGs.add(bg);
            bg.compile();
            this.tgContent.addChild((Node)bg);
        }
        while ((double)(this.conditionTGs.size() - this.populationLink.size()) > (double)XCSFConstants.maxPopSize * 0.2) {
            BranchGroup bg = this.conditionBGs.lastElement();
            this.tgContent.removeChild((Node)bg);
            this.conditionBGs.remove(bg);
            int index = this.conditionTGs.size() - 1;
            for (i = 0; i < num; ++i) {
                this.conditionTGs.remove(index);
                this.conditionAps.remove(index);
                --index;
            }
        }
    }

    private void setConditionProperties(int index, Classifier cl, boolean showActivity) {
        if (this.conditionTGs.size() <= index) {
            return;
        }
        this.transformationMatrix2Array(cl.getCondition());
        t3d.set(array);
        Color3f col = null;
        Color3f specular = null;
        if (showActivity) {
            col = new Color3f(0.2f, 1.0f, 1.0f);
            specular = new Color3f(0.8f, 1.0f, 1.0f);
        } else {
            double fit = Math.pow(cl.getFitness(), 0.1);
            col = new Color3f((float)(0.8 - 0.8 * fit), (float)(0.8 - 0.8 * fit), 0.9f);
            specular = new Color3f((float)(0.9 - 0.6 * fit), (float)(0.9 - 0.6 * fit), 1.0f);
        }
        this.conditionTGs.get(index).setTransform(t3d);
        this.conditionAps.get(index).setMaterial(new Material(col, BLACK, col, specular, 1.0f));
        this.conditionAps.get(index).setTransparencyAttributes(new TransparencyAttributes(0, ConditionsGUI2D3D.visualizationTransparency));
    }

    private BranchGroup createSceneGraph() {
        BranchGroup root = new BranchGroup();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
        Background background = new Background(new Color3f(0.5f, 0.5f, 0.5f));
        background.setApplicationBounds((Bounds)boundingSphere);
        root.addChild((Node)background);
        TransformGroup tgMouse = new TransformGroup();
        tgMouse.setCapability(18);
        tgMouse.setCapability(17);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(tgMouse);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        root.addChild((Node)myMouseRotate);
        MouseTranslate myMouseTranslate = new MouseTranslate();
        myMouseTranslate.setTransformGroup(tgMouse);
        myMouseTranslate.setSchedulingBounds((Bounds)new BoundingSphere());
        root.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = new MouseZoom();
        myMouseZoom.setTransformGroup(tgMouse);
        myMouseZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        root.addChild((Node)myMouseZoom);
        root.addChild((Node)tgMouse);
        Transform3D transl = new Transform3D();
        transl.setTranslation(new Vector3d(-0.5, -0.5, -0.5));
        this.tgContent = new TransformGroup(transl);
        this.tgContent.setCapability(14);
        this.tgContent.setCapability(13);
        tgMouse.addChild((Node)this.tgContent);
        Color3f lightColor = new Color3f(0.6f, 0.6f, 0.6f);
        Vector3f lightDirection = new Vector3f(4.0f, -7.0f, -12.0f);
        DirectionalLight light = new DirectionalLight(lightColor, lightDirection);
        light.setInfluencingBounds((Bounds)boundingSphere);
        root.addChild((Node)light);
        Color3f ambientColor = new Color3f(1.0f, 1.0f, 1.0f);
        AmbientLight ambientLight = new AmbientLight(ambientColor);
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        this.tgContent.addChild((Node)ambientLight);
        this.tgContent.addChild((Node)new Axis());
        Appearance cubeAp = new Appearance();
        cubeAp.setTransparencyAttributes(new TransparencyAttributes(0, 0.8f));
        cubeAp.setMaterial(new Material(BLACK, BLACK, BLACK, new Color3f(1.0f, 1.0f, 1.0f), 1.0f));
        Box cube = new Box(0.5f, 0.5f, 0.5f, 1, cubeAp);
        transl.setTranslation(new Vector3d(0.5, 0.5, 0.5));
        TransformGroup cubeTG = new TransformGroup(transl);
        cubeTG.addChild((Node)cube);
        this.tgContent.addChild((Node)cubeTG);
        root.compile();
        return root;
    }

    private void transformationMatrix2Array(Condition con) {
        double[] stretch;
        if (con instanceof ConditionRectangle) {
            stretch = ((ConditionRectangle)con).getStretch();
            double[] center = ((ConditionRectangle)con).getCenter();
            for (int i = 0; i < 3; ++i) {
                ConditionVisualization3D.matrix[i][i] = stretch[i];
                ConditionVisualization3D.matrix[i][3] = center[i];
            }
            ConditionVisualization3D.matrix[2][1] = 0.0;
            ConditionVisualization3D.matrix[2][0] = 0.0;
            ConditionVisualization3D.matrix[1][2] = 0.0;
            ConditionVisualization3D.matrix[1][0] = 0.0;
            ConditionVisualization3D.matrix[0][2] = 0.0;
            ConditionVisualization3D.matrix[0][1] = 0.0;
        } else if (con instanceof ConditionEllipsoid) {
            stretch = ((ConditionEllipsoid)con).getStretch();
            double[] center = ((ConditionEllipsoid)con).getCenter();
            for (int i = 0; i < 3; ++i) {
                ConditionVisualization3D.matrix[i][i] = stretch[i];
                ConditionVisualization3D.matrix[i][3] = center[i];
            }
            ConditionVisualization3D.matrix[2][1] = 0.0;
            ConditionVisualization3D.matrix[2][0] = 0.0;
            ConditionVisualization3D.matrix[1][2] = 0.0;
            ConditionVisualization3D.matrix[1][0] = 0.0;
            ConditionVisualization3D.matrix[0][2] = 0.0;
            ConditionVisualization3D.matrix[0][1] = 0.0;
        } else if (con instanceof ConditionRotatingRectangle) {
            matrix = ((ConditionRotatingRectangle)con).getTransform();
        } else if (con instanceof ConditionRotatingEllipsoid) {
            matrix = ((ConditionRotatingEllipsoid)con).getTransform();
        } else {
            throw new IllegalArgumentException("Unknown condition type.");
        }
        float scale = ConditionsGUI2D3D.visualizedConditionSize;
        ConditionVisualization3D.array[0] = matrix[0][0] * (double)scale;
        ConditionVisualization3D.array[1] = matrix[0][1] * (double)scale;
        ConditionVisualization3D.array[2] = matrix[0][2] * (double)scale;
        ConditionVisualization3D.array[4] = matrix[1][0] * (double)scale;
        ConditionVisualization3D.array[5] = matrix[1][1] * (double)scale;
        ConditionVisualization3D.array[6] = matrix[1][2] * (double)scale;
        ConditionVisualization3D.array[8] = matrix[2][0] * (double)scale;
        ConditionVisualization3D.array[9] = matrix[2][1] * (double)scale;
        ConditionVisualization3D.array[10] = matrix[2][2] * (double)scale;
        ConditionVisualization3D.array[3] = matrix[0][3];
        ConditionVisualization3D.array[7] = matrix[1][3];
        ConditionVisualization3D.array[11] = matrix[2][3];
    }

    private class Axis
    extends Shape3D {
        private static final float axis0 = 0.0f;
        private static final float axis1 = 1.1f;
        private static final float arrowLength = 0.1f;
        private static final float dist = 0.1f;
        private static final float arrow0 = 1.0f;

        public Axis() {
            IndexedLineArray axisLines = new IndexedLineArray(18, 1, 30);
            axisLines.setCoordinate(0, new Point3f(0.0f, 0.0f, 0.0f));
            axisLines.setCoordinate(1, new Point3f(1.1f, 0.0f, 0.0f));
            axisLines.setCoordinate(2, new Point3f(1.0f, 0.1f, 0.1f));
            axisLines.setCoordinate(3, new Point3f(1.0f, 0.1f, -0.1f));
            axisLines.setCoordinate(4, new Point3f(1.0f, -0.1f, 0.1f));
            axisLines.setCoordinate(5, new Point3f(1.0f, -0.1f, -0.1f));
            axisLines.setCoordinate(6, new Point3f(0.0f, 0.0f, 0.0f));
            axisLines.setCoordinate(7, new Point3f(0.0f, 1.1f, 0.0f));
            axisLines.setCoordinate(8, new Point3f(0.1f, 1.0f, 0.1f));
            axisLines.setCoordinate(9, new Point3f(0.1f, 1.0f, -0.1f));
            axisLines.setCoordinate(10, new Point3f(-0.1f, 1.0f, 0.1f));
            axisLines.setCoordinate(11, new Point3f(-0.1f, 1.0f, -0.1f));
            axisLines.setCoordinate(12, new Point3f(0.0f, 0.0f, 0.0f));
            axisLines.setCoordinate(13, new Point3f(0.0f, 0.0f, 1.1f));
            axisLines.setCoordinate(14, new Point3f(0.1f, 0.1f, 1.0f));
            axisLines.setCoordinate(15, new Point3f(0.1f, -0.1f, 1.0f));
            axisLines.setCoordinate(16, new Point3f(-0.1f, 0.1f, 1.0f));
            axisLines.setCoordinate(17, new Point3f(-0.1f, -0.1f, 1.0f));
            axisLines.setCoordinateIndex(0, 0);
            axisLines.setCoordinateIndex(1, 1);
            axisLines.setCoordinateIndex(2, 2);
            axisLines.setCoordinateIndex(3, 1);
            axisLines.setCoordinateIndex(4, 3);
            axisLines.setCoordinateIndex(5, 1);
            axisLines.setCoordinateIndex(6, 4);
            axisLines.setCoordinateIndex(7, 1);
            axisLines.setCoordinateIndex(8, 5);
            axisLines.setCoordinateIndex(9, 1);
            axisLines.setCoordinateIndex(10, 6);
            axisLines.setCoordinateIndex(11, 7);
            axisLines.setCoordinateIndex(12, 8);
            axisLines.setCoordinateIndex(13, 7);
            axisLines.setCoordinateIndex(14, 9);
            axisLines.setCoordinateIndex(15, 7);
            axisLines.setCoordinateIndex(16, 10);
            axisLines.setCoordinateIndex(17, 7);
            axisLines.setCoordinateIndex(18, 11);
            axisLines.setCoordinateIndex(19, 7);
            axisLines.setCoordinateIndex(20, 12);
            axisLines.setCoordinateIndex(21, 13);
            axisLines.setCoordinateIndex(22, 14);
            axisLines.setCoordinateIndex(23, 13);
            axisLines.setCoordinateIndex(24, 15);
            axisLines.setCoordinateIndex(25, 13);
            axisLines.setCoordinateIndex(26, 16);
            axisLines.setCoordinateIndex(27, 13);
            axisLines.setCoordinateIndex(28, 17);
            axisLines.setCoordinateIndex(29, 13);
            this.setGeometry((Geometry)axisLines);
        }
    }
}

