/*
 * Decompiled with CFR 0.152.
 */
package xcsf.examples;

import xcsf.Function;
import xcsf.XCSF;
import xcsf.XCSFConstants;
import xcsf.examples.Sine;
import xcsf.listener.PerformanceGUI;
import xcsf.listener.ProgressGUI;

public class ExampleMultiThreading {
    static final Function SINE = new Sine(1.0, 4.0, 0.0, 2);

    public static void main(String[] args) {
        final MyFunction f = new MyFunction();
        XCSFConstants.load();
        final XCSF xcsf = new XCSF(f);
        xcsf.addListener(new PerformanceGUI(true));
        xcsf.addListener(new ProgressGUI(true));
        Thread xcsfThread = new Thread(new Runnable(){

            public void run() {
                xcsf.runExperiments();
            }
        });
        Thread functionThread = new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < XCSFConstants.maxLearningIterations; ++i) {
                    try {
                        Thread.sleep((long)(Math.random() * 10.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.out.print(".");
                    if (i % 80 == 0) {
                        System.out.println();
                    }
                    f.addProblemInstance(SINE.nextProblemInstance());
                }
            }
        });
        xcsfThread.start();
        functionThread.start();
    }

    static class MyFunction
    extends Function.BlockingFunction {
        MyFunction() {
        }

        public int getPredictionInputDimension() {
            return SINE.getPredictionInputDimension();
        }

        public int getOutputDimension() {
            return SINE.getOutputDimension();
        }

        public double[] getNoiselessFunctionValue() {
            return SINE.getNoiselessFunctionValue();
        }

        public int getConditionInputDimension() {
            return SINE.getConditionInputDimension();
        }
    }
}

