/*
 * Decompiled with CFR 0.152.
 */
package xcsf.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import xcsf.Function;
import xcsf.XCSF;
import xcsf.XCSFConstants;
import xcsf.XCSFListener;
import xcsf.XCSFUtils;
import xcsf.examples.CrossedRidge;
import xcsf.examples.Linear;
import xcsf.examples.LinearImbalanced;
import xcsf.examples.Mesa;
import xcsf.examples.Polynomial;
import xcsf.examples.Radial;
import xcsf.examples.RadialSine;
import xcsf.examples.Sine;
import xcsf.examples.SineInSine;
import xcsf.examples.Tent1;
import xcsf.examples.Tent2;
import xcsf.listener.ConditionsGUI2D3D;
import xcsf.listener.OutputWriter2D;
import xcsf.listener.PerformanceGUI;
import xcsf.listener.PopulationWriter;
import xcsf.listener.PredictionErrorPlot;
import xcsf.listener.PredictionPlot;
import xcsf.listener.ProgressGUI;

public class ExampleMain {
    public static final String SETTINGS_FILE = "xcsf.ini";
    public static final String FUNCTION_FILE = "xcsf_functions.ini";
    public static final String VISUALIZATION_FILE = "xcsf_visualization.ini";
    private static boolean writeOutput = false;
    private static boolean writePopulation = false;
    private static String outputFolder = "output/";
    private static Vector<XCSFListener> listeners = new Vector();

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("--help")) {
                    ExampleMain.printUsage();
                    return;
                }
                if (args[i].equals("-o") || args[i].equals("--writeOutput")) {
                    writeOutput = true;
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--writePopulation")) {
                    writePopulation = true;
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--directory")) {
                    if (++i == args.length) {
                        throw new IllegalArgumentException("Missing argument 'path'.");
                    }
                    outputFolder = args[i];
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument: '" + args[i] + "'");
            }
        }
        System.out.println("Run with --help to see a list of available commands.");
        ExampleMain.initSettings();
        Function[] functions = ExampleMain.initFunctions();
        ExampleMain.initVisualization(functions);
        System.out.println("");
        for (Function f : functions) {
            XCSF xcsf = new XCSF(f);
            xcsf.addListeners(listeners);
            System.out.println(xcsf.toString());
            xcsf.runExperiments();
            if (!writeOutput) continue;
            String performanceFilename = outputFolder + f.getClass().getSimpleName() + "-performance";
            xcsf.writePerformance(performanceFilename);
        }
        if (writeOutput) {
            File source = new File(SETTINGS_FILE);
            File dest = new File(outputFolder + SETTINGS_FILE);
            XCSFUtils.FileIO.fileCopy(source, dest);
            source = new File(FUNCTION_FILE);
            dest = new File(outputFolder + FUNCTION_FILE);
            XCSFUtils.FileIO.fileCopy(source, dest);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java " + ExampleMain.class.getSimpleName() + " [options]");
        System.out.println("The following options are available:");
        System.out.println(" -o or --writeOutput");
        System.out.println("    Indicates that performance output is written to the filesystem.");
        System.out.println(" -p or --writePopulation");
        System.out.println("    Inidicates that populations are written to the filesystem.");
        System.out.println(" -d 'path' or --directory 'path'");
        System.out.println("    Secifies the path to write to.");
    }

    private static void initSettings() {
        System.out.format("%-50s", "loading xcsf.ini");
        XCSFConstants.load(SETTINGS_FILE);
        System.out.println("done");
        System.out.println(" + " + new File(SETTINGS_FILE).getAbsolutePath());
        System.out.format("%-50s", "initializing random number generator");
        if (XCSFConstants.doRandomize) {
            XCSFUtils.Random.setSeed(11L + System.currentTimeMillis() % 100000L);
        } else {
            XCSFUtils.Random.setSeed(XCSFConstants.initialSeed);
        }
        System.out.println("done, " + (XCSFConstants.doRandomize ? "rnd-" : "") + "seed = " + XCSFConstants.initialSeed);
        if (writeOutput || writePopulation) {
            if (outputFolder.length() > 0) {
                if (!outputFolder.endsWith(File.pathSeparator)) {
                    outputFolder = outputFolder + File.separatorChar;
                }
                File outputDirectory = new File(outputFolder);
                System.out.format("%-50s", "initializing output folder");
                if (!outputDirectory.exists() && !outputDirectory.mkdir()) {
                    System.err.println("FATAL ERROR\nFailed to create output directory: '" + outputFolder + "'");
                    System.exit(1);
                }
                System.out.println("done");
                System.out.println(" + " + outputDirectory.getAbsolutePath());
            } else {
                System.out.println("done");
                System.out.println(" + current working directory");
            }
            if (writePopulation) {
                listeners.add(new PopulationWriter(outputFolder));
            }
        }
    }

    private static Function[] initFunctions() {
        System.out.format("%-50s", "loading xcsf_functions.ini");
        Function[] functions = null;
        try {
            FileInputStream in = new FileInputStream(FUNCTION_FILE);
            Properties p = new Properties();
            p.load(in);
            String functionNames = p.getProperty("functions");
            int dim = Integer.parseInt(p.getProperty("functionInputDimension"));
            double scale = Double.parseDouble(p.getProperty("functionScale"));
            double modifier = Double.parseDouble(p.getProperty("functionModifier"));
            double noiseDeviation = Double.parseDouble(p.getProperty("functionNormNoiseDeviation"));
            in.close();
            functions = ExampleMain.getFunctions(functionNames, scale, modifier, noiseDeviation, dim);
            System.out.println("done, " + functions.length + " function(s)");
            for (Function f : functions) {
                System.out.println(" + " + f.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            File f = new File(FUNCTION_FILE);
            System.err.println("CRITICAL: Failed to load functions from");
            System.err.println("   " + f.getAbsolutePath());
            e.printStackTrace();
            System.exit(1);
        }
        return functions;
    }

    private static Function[] getFunctions(String functionNames, double scale, double modifier, double noiseDeviation, int dim) {
        String[] splited = functionNames.split(",");
        int n = splited.length;
        Function[] functions = new Function[n];
        for (int i = 0; i < n; ++i) {
            functions[i] = ExampleMain.getFunction(splited[i].trim().toLowerCase(), scale, modifier, noiseDeviation, dim);
        }
        return functions;
    }

    private static Function getFunction(String functionName, double scale, double modifier, double noiseDeviation, int dim) {
        String name = functionName.trim().toLowerCase();
        if (name.equals("sine")) {
            return new Sine(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("radial")) {
            return new Radial(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("radialsine")) {
            return new RadialSine(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("linear")) {
            return new Linear(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("linearimbalanced")) {
            return new LinearImbalanced(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("crossedridge")) {
            return new CrossedRidge(scale, noiseDeviation, dim);
        }
        if (name.equals("polynomial")) {
            return new Polynomial(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("tent1")) {
            return new Tent1(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("tent2")) {
            return new Tent2(scale, modifier, noiseDeviation, dim);
        }
        if (name.equals("mesa") && dim == 2) {
            return new Mesa(scale, modifier, noiseDeviation);
        }
        if (name.equals("sineinsine") && dim == 2) {
            return new SineInSine(scale, modifier, noiseDeviation);
        }
        throw new IllegalArgumentException("Function and/or dimension not available: '" + name + "' " + dim + "D.");
    }

    private static void initVisualization(Function[] functions) {
        System.out.format("%-50s", "loading xcsf_visualization.ini");
        int dimension = functions[0].getConditionInputDimension();
        for (int i = 1; i < functions.length; ++i) {
            if (functions[i].getConditionInputDimension() == dimension) continue;
            System.err.println("Inconsistent Dimensions for Visualization.");
            dimension = -1;
            break;
        }
        if (writeOutput && dimension == 2) {
            listeners.add(new OutputWriter2D(outputFolder, true, 0, 0.2, 0.2));
        }
        try {
            FileInputStream in = new FileInputStream(VISUALIZATION_FILE);
            Properties p = new Properties();
            p.load(in);
            boolean doVisualization = Boolean.parseBoolean(p.getProperty("doVisualization"));
            String gnuplotExe = p.getProperty("gnuplotExecutable");
            if (!gnuplotExe.toLowerCase().equals("default")) {
                XCSFUtils.Gnuplot.executable = gnuplotExe;
            }
            if (doVisualization) {
                ConditionsGUI2D3D.slowMotion = Boolean.parseBoolean(p.getProperty("slowMotion"));
                ConditionsGUI2D3D.visualizationSteps = Integer.parseInt(p.getProperty("updateVisualizationSteps"));
                ConditionsGUI2D3D.visualizedConditionSize = Float.parseFloat(p.getProperty("relativeVisualizedConditionSize"));
                ConditionsGUI2D3D.visualizationTransparency = Float.parseFloat(p.getProperty("visualizationTransparencyDegree"));
                ConditionsGUI2D3D.visualizationDelay = Integer.parseInt(p.getProperty("visualizationDelay"));
                listeners.add(new PerformanceGUI(true));
                listeners.add(new ProgressGUI(true));
                if (dimension == 2) {
                    listeners.add(new ConditionsGUI2D3D());
                    try {
                        listeners.add(new PredictionErrorPlot());
                        listeners.add(new PredictionPlot());
                    }
                    catch (IOException e) {
                        System.err.println("Failed to execute GnuPlot!");
                    }
                } else if (dimension == 3) {
                    try {
                        XCSF.class.getClassLoader().loadClass("com.sun.j3d.utils.universe.SimpleUniverse");
                        listeners.add(new ConditionsGUI2D3D());
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Java3D is not installed! ");
                    }
                }
            }
            in.close();
        }
        catch (IOException e) {
            File f = new File(VISUALIZATION_FILE);
            System.err.println("Failed to load visualization settings from");
            System.err.println("   " + f.getAbsolutePath());
        }
        System.out.println("done");
    }
}

