/*
 * Decompiled with CFR 0.152.
 */
package xcsf.examples;

import xcsf.Function;
import xcsf.XCSFUtils;

public class CrossedRidge
extends Function.SimpleFunction {
    public CrossedRidge(double scale, double noiseDeviation, int dim) {
        super(scale, 0.0, noiseDeviation, dim);
        if (dim < 2) {
            throw new IllegalArgumentException();
        }
    }

    protected double evaluate() {
        double valX = this.input[0] * 2.0 - 1.0;
        double valY = this.input[1] * 2.0 - 1.0;
        double sq1 = valX * valX;
        double sq2 = valY * valY;
        double f1 = Math.exp(-10.0 * sq1);
        double f2 = Math.exp(-50.0 * sq2);
        double f3 = 1.25 * Math.exp(-5.0 * (sq1 + sq2));
        double value = Math.max(f1, Math.max(f2, f3));
        for (int d = 10; d < this.dim; ++d) {
            value += XCSFUtils.Random.normRand() * 0.0025;
        }
        return value;
    }
}

