/*
 * Decompiled with CFR 0.152.
 */
package xcsf.classifier;

import java.io.PrintStream;
import java.util.Arrays;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Prediction;

public class PredictionLinearRLS
implements Prediction {
    private static double[] tmpExtendedPredInput;
    private static double[] tmpGainVector;
    private static double[][] tmpMatrix1;
    private static double[][] tmpMatrix2;
    private int inputLength;
    private int predictionLength;
    private double[][] coefficients;
    private double[][] gainMatrix;
    private double[] prediction;

    public PredictionLinearRLS(int inputLength, double[] initialPrediction) {
        this.inputLength = inputLength + 1;
        this.predictionLength = initialPrediction.length;
        this.coefficients = new double[this.predictionLength][this.inputLength];
        this.gainMatrix = new double[this.inputLength][this.inputLength];
        this.prediction = new double[this.predictionLength];
        for (int p = 0; p < this.predictionLength; ++p) {
            this.coefficients[p][0] = XCSFConstants.predictionOffsetValue > 0.0 ? initialPrediction[p] : 0.0;
            for (int i = 1; i < this.inputLength; ++i) {
                this.coefficients[p][i] = 0.0;
            }
        }
        this.initializeGainMatrix();
        PredictionLinearRLS.init(this.inputLength);
    }

    public PredictionLinearRLS(String[] args) {
        this();
        this.inputLength = Integer.parseInt(args[0]);
        this.predictionLength = Integer.parseInt(args[1]);
        this.prediction = XCSFUtils.FileIO.parseDoubleArray(args[2]);
        this.coefficients = XCSFUtils.FileIO.parse2dDoubleArray(args[3]);
        this.gainMatrix = XCSFUtils.FileIO.parse2dDoubleArray(args[4]);
        PredictionLinearRLS.init(this.inputLength);
    }

    private static void init(int inputLength) {
        if (tmpGainVector == null || tmpGainVector.length != inputLength) {
            tmpGainVector = new double[inputLength];
            tmpExtendedPredInput = new double[inputLength];
            tmpMatrix1 = new double[inputLength][inputLength];
            tmpMatrix2 = new double[inputLength][inputLength];
        }
    }

    private PredictionLinearRLS() {
    }

    public double[] predict(double[] input) {
        for (int dim = 0; dim < this.predictionLength; ++dim) {
            this.prediction[dim] = this.coefficients[dim][0] * XCSFConstants.predictionOffsetValue;
            for (int i = 1; i < this.inputLength; ++i) {
                int n = dim;
                this.prediction[n] = this.prediction[n] + this.coefficients[dim][i] * input[i - 1];
            }
        }
        return this.prediction;
    }

    public void update(double[] input, double[] functionValue) {
        int i;
        PredictionLinearRLS.tmpExtendedPredInput[0] = XCSFConstants.predictionOffsetValue;
        for (int i2 = 0; i2 < input.length; ++i2) {
            PredictionLinearRLS.tmpExtendedPredInput[i2 + 1] = input[i2];
        }
        XCSFUtils.Matrix.multiply(this.gainMatrix, tmpExtendedPredInput, tmpGainVector, this.inputLength);
        double divisor = XCSFConstants.lambdaRLS;
        for (i = 0; i < this.inputLength; ++i) {
            divisor += tmpExtendedPredInput[i] * tmpGainVector[i];
        }
        i = 0;
        while (i < this.inputLength) {
            int n = i++;
            tmpGainVector[n] = tmpGainVector[n] / divisor;
        }
        for (int p = 0; p < this.predictionLength; ++p) {
            double error = functionValue[p] - this.prediction[p];
            for (int i3 = 0; i3 < this.inputLength; ++i3) {
                double[] dArray = this.coefficients[p];
                int n = i3;
                dArray[n] = dArray[n] + error * tmpGainVector[i3];
            }
        }
        for (i = 0; i < this.inputLength; ++i) {
            for (int j = 0; j < this.inputLength; ++j) {
                double tmp = tmpGainVector[i] * tmpExtendedPredInput[j];
                PredictionLinearRLS.tmpMatrix1[i][j] = i == j ? 1.0 - tmp : -tmp;
            }
        }
        XCSFUtils.Matrix.multiply(tmpMatrix1, this.gainMatrix, tmpMatrix2, this.inputLength);
        for (int row = 0; row < this.inputLength; ++row) {
            for (int col = 0; col < this.inputLength; ++col) {
                this.gainMatrix[row][col] = tmpMatrix2[row][col] / XCSFConstants.lambdaRLS;
            }
        }
    }

    public void crossover(Prediction otherPrediction) {
        PredictionLinearRLS other = (PredictionLinearRLS)otherPrediction;
        for (int p = 0; p < this.predictionLength; ++p) {
            for (int i = 0; i < this.inputLength; ++i) {
                double avg = this.coefficients[p][i] + other.coefficients[p][i];
                double d = avg / 2.0;
                other.coefficients[p][i] = d;
                this.coefficients[p][i] = d;
            }
        }
    }

    public PredictionLinearRLS reproduce() {
        PredictionLinearRLS clone = new PredictionLinearRLS();
        clone.inputLength = this.inputLength;
        clone.predictionLength = this.predictionLength;
        clone.coefficients = new double[this.predictionLength][this.inputLength];
        for (int p = 0; p < this.predictionLength; ++p) {
            for (int i = 0; i < this.inputLength; ++i) {
                clone.coefficients[p][i] = this.coefficients[p][i];
            }
        }
        clone.prediction = new double[this.predictionLength];
        clone.gainMatrix = new double[this.inputLength][this.inputLength];
        clone.initializeGainMatrix();
        return clone;
    }

    public String toString() {
        String s = "prediction{in=" + (this.inputLength - 1) + ",out=" + this.predictionLength + " coef=";
        for (double[] coeff : this.coefficients) {
            s = s + Arrays.toString(coeff);
        }
        s = s + ", gain=";
        for (double[] row : this.gainMatrix) {
            s = s + Arrays.toString(row);
        }
        return s + "}";
    }

    public void write(PrintStream out, CharSequence separator) {
        StringBuffer s = new StringBuffer();
        s.append(this.inputLength);
        s.append(separator);
        s.append(this.predictionLength);
        s.append(separator);
        s.append(Arrays.toString(this.prediction));
        s.append(separator);
        s.append(Arrays.deepToString((Object[])this.coefficients));
        s.append(separator);
        s.append(Arrays.deepToString((Object[])this.gainMatrix));
        out.print(s.toString());
    }

    public double[][] getCoefficients(boolean withOffsetWeight) {
        int offset = withOffsetWeight ? 0 : 1;
        int length = this.inputLength - offset;
        double[][] coef = new double[this.predictionLength][length];
        for (int row = 0; row < this.predictionLength; ++row) {
            System.arraycopy(this.coefficients[row], offset, coef[row], 0, length);
        }
        return coef;
    }

    public void resetGainMatrix() {
        int i = 0;
        while (i < this.inputLength) {
            double[] dArray = this.gainMatrix[i];
            int n = i++;
            dArray[n] = dArray[n] + XCSFConstants.rlsInitScaleFactor;
        }
    }

    private void initializeGainMatrix() {
        for (int row = 0; row < this.gainMatrix.length; ++row) {
            for (int col = 0; col < this.gainMatrix.length; ++col) {
                this.gainMatrix[row][col] = row != col ? 0.0 : XCSFConstants.rlsInitScaleFactor;
            }
        }
    }
}

