/*
 * Decompiled with CFR 0.152.
 */
package xcsf.classifier;

import java.io.PrintStream;
import java.util.Arrays;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Prediction;

public class PredictionConstant
implements Prediction {
    private int predictionLength;
    private double[] prediction;

    public PredictionConstant(int inputlength, double[] initialPrediction) {
        this.predictionLength = initialPrediction.length;
        this.prediction = new double[this.predictionLength];
        for (int i = 0; i < this.predictionLength; ++i) {
            this.prediction[i] = initialPrediction[i];
        }
    }

    public PredictionConstant(String[] args) {
        this();
        this.predictionLength = Integer.parseInt(args[0]);
        this.prediction = XCSFUtils.FileIO.parseDoubleArray(args[1]);
    }

    private PredictionConstant() {
    }

    public double[] predict(double[] input) {
        double[] pred = new double[this.predictionLength];
        System.arraycopy(this.prediction, 0, pred, 0, this.predictionLength);
        return pred;
    }

    public void update(double[] input, double[] functionValue) {
        int i = 0;
        while (i < this.predictionLength) {
            double error = functionValue[i] - this.prediction[i];
            int n = i++;
            this.prediction[n] = this.prediction[n] + XCSFConstants.beta * error;
        }
    }

    public void crossover(Prediction otherPrediction) {
        PredictionConstant other = (PredictionConstant)otherPrediction;
        for (int i = 0; i < this.predictionLength; ++i) {
            double avg = this.prediction[i] + other.prediction[i];
            this.prediction[i] = other.prediction[i] = avg / 2.0;
        }
    }

    public Prediction reproduce() {
        PredictionConstant clone = new PredictionConstant();
        clone.predictionLength = this.predictionLength;
        clone.prediction = new double[this.predictionLength];
        System.arraycopy(this.prediction, 0, clone.prediction, 0, this.predictionLength);
        return clone;
    }

    public String toString() {
        return "prediction{" + Arrays.toString(this.prediction) + "}";
    }

    public void write(PrintStream out, CharSequence separator) {
        StringBuffer s = new StringBuffer();
        s.append(this.predictionLength);
        s.append(separator);
        s.append(Arrays.toString(this.prediction));
        out.print(s.toString());
    }
}

