/*
 * Decompiled with CFR 0.152.
 */
package xcsf.classifier;

import java.io.PrintStream;
import java.util.Arrays;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Condition;

public class ConditionRotatingEllipsoid
implements Condition {
    private static double[] tmpArray2;
    private static double[][] tmpSingleRotation;
    private static double[][] tmpTransformation;
    private static double[][] tmpMatrix;
    private int dimension;
    private double[] center;
    private double[] stretch;
    private double[] angle;
    private double[][] transform;
    private double[][] inverseTransform;
    private boolean changed;
    private double[] conditionInput;
    private double squareDistance;
    private double[] tmpArray1;

    public ConditionRotatingEllipsoid(double[] conditionInput) {
        this(conditionInput.length);
        int i;
        ConditionRotatingEllipsoid.init(this.dimension);
        for (i = 0; i < this.dimension; ++i) {
            this.center[i] = conditionInput[i];
        }
        for (i = 0; i < this.dimension; ++i) {
            this.stretch[i] = XCSFConstants.minConditionStretch + XCSFUtils.Random.uniRand() * XCSFConstants.coverConditionRange;
        }
        for (i = 0; i < this.angle.length; ++i) {
            this.angle[i] = XCSFUtils.Random.uniRand() * 2.0 * Math.PI;
        }
        this.recalculateTransformationMatrix();
    }

    public ConditionRotatingEllipsoid(String[] args) {
        this(Integer.parseInt(args[0]));
        ConditionRotatingEllipsoid.init(this.dimension);
        this.center = XCSFUtils.FileIO.parseDoubleArray(args[1]);
        this.stretch = XCSFUtils.FileIO.parseDoubleArray(args[2]);
        this.angle = XCSFUtils.FileIO.parseDoubleArray(args[3]);
        this.inverseTransform = XCSFUtils.FileIO.parse2dDoubleArray(args[4]);
        this.transform = XCSFUtils.FileIO.parse2dDoubleArray(args[5]);
    }

    private ConditionRotatingEllipsoid(int dimension) {
        this.dimension = dimension;
        this.center = new double[dimension];
        this.stretch = new double[dimension];
        this.angle = new double[dimension * (dimension - 1) / 2];
        this.tmpArray1 = new double[dimension];
        this.transform = new double[dimension + 1][dimension + 1];
        this.inverseTransform = new double[dimension + 1][dimension + 1];
    }

    private static void init(int dimension) {
        if (tmpArray2 == null || tmpArray2.length != dimension) {
            tmpArray2 = new double[dimension];
            tmpMatrix = new double[dimension][dimension];
            tmpTransformation = new double[dimension + 1][dimension + 1];
            tmpSingleRotation = new double[dimension][dimension];
            for (int i = 0; i < dimension; ++i) {
                for (int j = 0; j < dimension; ++j) {
                    ConditionRotatingEllipsoid.tmpSingleRotation[i][j] = i != j ? 0.0 : 1.0;
                }
            }
        }
    }

    public boolean doesMatch(double[] input) {
        if (!XCSFUtils.arrayEquals(this.conditionInput, input)) {
            this.squareDistance = this.calculateRelativeSquaredDistance(input);
            this.conditionInput = input;
        }
        return this.squareDistance < 1.0;
    }

    public double getActivity(double[] input) {
        if (!XCSFUtils.arrayEquals(this.conditionInput, input)) {
            this.squareDistance = this.calculateRelativeSquaredDistance(input);
            this.conditionInput = input;
        }
        return Math.exp(-this.squareDistance);
    }

    public boolean isMoreGeneral(Condition otherCondition) {
        ConditionRotatingEllipsoid other = (ConditionRotatingEllipsoid)otherCondition;
        XCSFUtils.Matrix.multiply(this.inverseTransform, other.transform, tmpTransformation, this.dimension + 1);
        for (int dim = 0; dim < this.dimension; ++dim) {
            double length1 = 0.0;
            double length2 = 0.0;
            for (int row = 0; row < this.dimension; ++row) {
                double v = tmpTransformation[row][dim] + tmpTransformation[row][this.dimension];
                length1 += v * v;
                v = -tmpTransformation[row][dim] + tmpTransformation[row][this.dimension];
                length2 += v * v;
            }
            if (!(length1 > 1.0) && !(length2 > 1.0)) continue;
            return false;
        }
        return true;
    }

    public double getVolume() {
        double volume = Math.pow(2.0, this.dimension - 1) / (double)this.dimension * Math.PI;
        for (int i = 0; i < this.dimension; ++i) {
            volume *= this.stretch[i];
        }
        return volume;
    }

    public void crossover(Condition otherCondition) {
        ConditionRotatingEllipsoid other = (ConditionRotatingEllipsoid)otherCondition;
        other.changed = false;
        this.changed = false;
        if (XCSFUtils.Random.uniRand() < XCSFConstants.pX) {
            int i;
            for (i = 0; i < this.dimension; ++i) {
                if (!(XCSFUtils.Random.uniRand() < 0.5)) continue;
                other.changed = true;
                this.changed = true;
                XCSFUtils.flip(i, this.center, other.center);
            }
            for (i = 0; i < this.dimension; ++i) {
                if (!(XCSFUtils.Random.uniRand() < 0.5)) continue;
                other.changed = true;
                this.changed = true;
                XCSFUtils.flip(i, this.stretch, other.stretch);
            }
            for (i = 0; i < this.angle.length; ++i) {
                if (!(XCSFUtils.Random.uniRand() < 0.5)) continue;
                other.changed = true;
                this.changed = true;
                XCSFUtils.flip(i, this.angle, other.angle);
            }
        }
    }

    public void mutation() {
        int i;
        double probability = XCSFConstants.pM / (double)(2 * this.dimension + this.angle.length);
        for (i = 0; i < this.dimension; ++i) {
            if (XCSFUtils.Random.uniRand() < probability) {
                this.changed = true;
                this.tmpArray1[i] = 2.0 * XCSFUtils.Random.uniRand() - 1.0;
                continue;
            }
            this.tmpArray1[i] = 0.0;
        }
        if (this.changed) {
            XCSFUtils.Matrix.multiply(this.transform, this.tmpArray1, tmpArray2, this.dimension);
            for (i = 0; i < this.dimension; ++i) {
                int n = i;
                this.center[n] = this.center[n] + tmpArray2[i];
                if (this.center[i] < 0.0) {
                    this.center[i] = 0.0;
                    continue;
                }
                if (!(this.center[i] > 1.0)) continue;
                this.center[i] = 1.0;
            }
        }
        for (i = 0; i < this.dimension; ++i) {
            if (!(XCSFUtils.Random.uniRand() < probability)) continue;
            this.changed = true;
            double rnd = 1.0;
            rnd = XCSFUtils.Random.uniRand() < 0.5 ? (rnd += XCSFUtils.Random.uniRand()) : (rnd -= 0.5 * XCSFUtils.Random.uniRand());
            int n = i;
            this.stretch[n] = this.stretch[n] * rnd;
        }
        for (i = 0; i < this.angle.length; ++i) {
            if (!(XCSFUtils.Random.uniRand() < probability)) continue;
            this.changed = true;
            double change = XCSFUtils.Random.uniRand() * Math.PI * 0.25;
            int n = i;
            this.angle[n] = this.angle[n] + (XCSFUtils.Random.uniRand() < 0.5 ? change : -change);
            if (this.angle[i] < 0.0) {
                int n2 = i;
                this.angle[n2] = this.angle[n2] + Math.PI * 2;
                continue;
            }
            if (!(this.angle[i] > Math.PI * 2)) continue;
            int n3 = i;
            this.angle[n3] = this.angle[n3] - Math.PI * 2;
        }
        if (this.changed) {
            this.recalculateTransformationMatrix();
        }
    }

    public boolean equals(Condition otherCondition) {
        int i;
        ConditionRotatingEllipsoid other = (ConditionRotatingEllipsoid)otherCondition;
        for (i = 0; i < this.dimension; ++i) {
            if (this.center[i] == other.center[i] && this.stretch[i] == other.stretch[i]) continue;
            return false;
        }
        for (i = 0; i < this.angle.length; ++i) {
            if (this.angle[i] == other.angle[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "condition{center" + Arrays.toString(this.center) + " stretch" + Arrays.toString(this.stretch) + " angles" + Arrays.toString(this.angle) + "}";
    }

    public Condition reproduce() {
        ConditionRotatingEllipsoid clone = new ConditionRotatingEllipsoid(this.dimension);
        System.arraycopy(this.center, 0, clone.center, 0, this.dimension);
        System.arraycopy(this.stretch, 0, clone.stretch, 0, this.dimension);
        System.arraycopy(this.angle, 0, clone.angle, 0, this.angle.length);
        clone.transform[this.dimension][this.dimension] = 1.0;
        clone.inverseTransform[this.dimension][this.dimension] = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            System.arraycopy(this.transform[i], 0, clone.transform[i], 0, this.dimension + 1);
            System.arraycopy(this.inverseTransform[i], 0, clone.inverseTransform[i], 0, this.dimension + 1);
        }
        return clone;
    }

    public double[] getCenter() {
        return this.center;
    }

    public void write(PrintStream out, CharSequence separator) {
        StringBuffer s = new StringBuffer();
        s.append(this.dimension);
        s.append(separator);
        s.append(Arrays.toString(this.center));
        s.append(separator);
        s.append(Arrays.toString(this.stretch));
        s.append(separator);
        s.append(Arrays.toString(this.angle));
        s.append(separator);
        s.append(Arrays.deepToString((Object[])this.inverseTransform));
        s.append(separator);
        s.append(Arrays.deepToString((Object[])this.transform));
        out.print(s);
    }

    public double[] getStretch() {
        return this.stretch;
    }

    public double[] getAngles() {
        return this.angle;
    }

    public double[][] getTransform() {
        return this.transform;
    }

    public double[][] getInverseTransform() {
        return this.inverseTransform;
    }

    public void recalculateTransformationMatrix() {
        ConditionRotatingEllipsoid.setInverseTransform(this.inverseTransform, this.center, this.stretch, this.angle, this.dimension);
        ConditionRotatingEllipsoid.setTransform(this.transform, this.center, this.stretch, this.angle, this.dimension);
        this.changed = false;
        this.conditionInput = null;
    }

    private double calculateRelativeSquaredDistance(double[] point) {
        XCSFUtils.Matrix.multiplyExtended(this.inverseTransform, point, this.tmpArray1, this.dimension);
        double dist = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            dist += this.tmpArray1[i] * this.tmpArray1[i];
        }
        return dist;
    }

    private static void setTransform(double[][] matrix, double[] center, double[] stretch, double[] angle, int dim) {
        int j;
        int i;
        for (int i2 = 0; i2 < dim; ++i2) {
            for (int j2 = 0; j2 < dim; ++j2) {
                matrix[i2][j2] = i2 != j2 ? 0.0 : 1.0;
            }
            matrix[i2][dim] = center[i2];
            matrix[dim][i2] = 0.0;
        }
        matrix[dim][dim] = 1.0;
        int a = angle.length - 1;
        for (i = dim - 1; i >= 0; --i) {
            for (j = dim - 1; j > i; --j) {
                double d = Math.cos(angle[a]);
                ConditionRotatingEllipsoid.tmpSingleRotation[j][j] = d;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][i] = d;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][j] = -Math.sin(angle[a]);
                ConditionRotatingEllipsoid.tmpSingleRotation[j][i] = -tmpSingleRotation[i][j];
                XCSFUtils.Matrix.multiply(matrix, tmpSingleRotation, tmpMatrix, dim);
                XCSFUtils.Matrix.copyMatrix(tmpMatrix, matrix, dim);
                --a;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][i] = 1.0;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][j] = 0.0;
                ConditionRotatingEllipsoid.tmpSingleRotation[j][i] = 0.0;
                ConditionRotatingEllipsoid.tmpSingleRotation[j][j] = 1.0;
            }
        }
        for (i = 0; i < dim; ++i) {
            for (j = 0; j < dim; ++j) {
                double[] dArray = matrix[i];
                int n = j;
                dArray[n] = dArray[n] * stretch[j];
            }
        }
    }

    private static void setInverseTransform(double[][] matrix, double[] center, double[] stretch, double[] angle, int dim) {
        int j;
        int i;
        for (int i2 = 0; i2 < dim; ++i2) {
            for (int j2 = 0; j2 < dim; ++j2) {
                matrix[i2][j2] = i2 != j2 ? 0.0 : 1.0 / stretch[i2];
            }
            matrix[dim][i2] = 0.0;
            matrix[i2][dim] = 0.0;
        }
        matrix[dim][dim] = 1.0;
        int a = 0;
        for (i = 0; i < dim; ++i) {
            for (j = i + 1; j < dim; ++j) {
                double d = Math.cos(angle[a]);
                ConditionRotatingEllipsoid.tmpSingleRotation[j][j] = d;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][i] = d;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][j] = Math.sin(angle[a]);
                ConditionRotatingEllipsoid.tmpSingleRotation[j][i] = -tmpSingleRotation[i][j];
                XCSFUtils.Matrix.multiply(matrix, tmpSingleRotation, tmpMatrix, dim);
                XCSFUtils.Matrix.copyMatrix(tmpMatrix, matrix, dim);
                ++a;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][i] = 1.0;
                ConditionRotatingEllipsoid.tmpSingleRotation[i][j] = 0.0;
                ConditionRotatingEllipsoid.tmpSingleRotation[j][i] = 0.0;
                ConditionRotatingEllipsoid.tmpSingleRotation[j][j] = 1.0;
            }
        }
        for (i = 0; i < dim; ++i) {
            for (j = 0; j < dim; ++j) {
                double[] dArray = matrix[i];
                int n = dim;
                dArray[n] = dArray[n] - matrix[i][j] * center[j];
            }
        }
    }
}

