/*
 * Decompiled with CFR 0.152.
 */
package xcsf.classifier;

import java.io.PrintStream;
import java.util.Arrays;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Condition;

public class ConditionRectangle
implements Condition {
    private int dimension;
    private double[] center;
    private double[] stretch;
    private double[] conditionInput;
    private double maxDistance;
    private double[] tmpArray;

    public ConditionRectangle(double[] conditionInput) {
        this(conditionInput.length);
        int i;
        for (i = 0; i < this.dimension; ++i) {
            this.center[i] = conditionInput[i];
        }
        for (i = 0; i < this.dimension; ++i) {
            this.stretch[i] = XCSFConstants.minConditionStretch + XCSFUtils.Random.uniRand() * XCSFConstants.coverConditionRange;
        }
    }

    public ConditionRectangle(String[] args) {
        this(Integer.parseInt(args[0]));
        this.center = XCSFUtils.FileIO.parseDoubleArray(args[1]);
        this.stretch = XCSFUtils.FileIO.parseDoubleArray(args[2]);
    }

    private ConditionRectangle(int dimension) {
        this.dimension = dimension;
        this.center = new double[dimension];
        this.stretch = new double[dimension];
        this.tmpArray = new double[dimension];
    }

    public boolean doesMatch(double[] input) {
        if (!XCSFUtils.arrayEquals(this.conditionInput, input)) {
            this.calculateMaxDistance(input);
            this.conditionInput = input;
        }
        return this.maxDistance < 1.0;
    }

    public double getActivity(double[] input) {
        if (!XCSFUtils.arrayEquals(this.conditionInput, input)) {
            this.calculateMaxDistance(input);
            this.conditionInput = input;
        }
        return Math.exp(-this.maxDistance);
    }

    public boolean isMoreGeneral(Condition otherCondition) {
        ConditionRectangle other = (ConditionRectangle)otherCondition;
        for (int i = 0; i < this.dimension; ++i) {
            double l1 = this.center[i] - this.stretch[i];
            double u1 = this.center[i] + this.stretch[i];
            double l2 = other.center[i] - other.stretch[i];
            double u2 = other.center[i] + other.stretch[i];
            if (!(l1 > l2) && !(u1 < u2)) continue;
            return false;
        }
        return true;
    }

    public double getVolume() {
        double volume = 1.0;
        for (int i = 0; i < this.dimension; ++i) {
            volume *= 2.0 * this.stretch[i];
        }
        return volume;
    }

    public void crossover(Condition otherCondition) {
        ConditionRectangle other = (ConditionRectangle)otherCondition;
        if (XCSFUtils.Random.uniRand() < XCSFConstants.pX) {
            int i;
            for (i = 0; i < this.dimension; ++i) {
                if (!(XCSFUtils.Random.uniRand() < 0.5)) continue;
                XCSFUtils.flip(i, this.center, other.center);
            }
            for (i = 0; i < this.dimension; ++i) {
                if (!(XCSFUtils.Random.uniRand() < 0.5)) continue;
                XCSFUtils.flip(i, this.stretch, other.stretch);
            }
        }
    }

    public void mutation() {
        double rnd;
        int i;
        double probability = XCSFConstants.pM / (double)(2 * this.dimension);
        for (i = 0; i < this.dimension; ++i) {
            if (!(XCSFUtils.Random.uniRand() < probability)) continue;
            rnd = 2.0 * XCSFUtils.Random.uniRand() - 1.0;
            int n = i;
            this.center[n] = this.center[n] + rnd * this.stretch[i];
            if (this.center[i] < 0.0) {
                this.center[i] = 0.0;
                continue;
            }
            if (!(this.center[i] > 1.0)) continue;
            this.center[i] = 1.0;
        }
        for (i = 0; i < this.dimension; ++i) {
            if (!(XCSFUtils.Random.uniRand() < probability)) continue;
            rnd = 1.0;
            rnd = XCSFUtils.Random.uniRand() < 0.5 ? (rnd += XCSFUtils.Random.uniRand()) : (rnd -= 0.5 * XCSFUtils.Random.uniRand());
            int n = i;
            this.stretch[n] = this.stretch[n] * rnd;
        }
    }

    public boolean equals(Condition otherCondition) {
        ConditionRectangle other = (ConditionRectangle)otherCondition;
        for (int i = 0; i < this.dimension; ++i) {
            if (this.center[i] == other.center[i] && this.stretch[i] == other.stretch[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "condition{center" + Arrays.toString(this.center) + " stretch" + Arrays.toString(this.stretch) + "}";
    }

    public Condition reproduce() {
        ConditionRectangle clone = new ConditionRectangle(this.dimension);
        System.arraycopy(this.center, 0, clone.center, 0, this.dimension);
        System.arraycopy(this.stretch, 0, clone.stretch, 0, this.dimension);
        return clone;
    }

    public double[] getCenter() {
        return this.center;
    }

    public void write(PrintStream out, CharSequence separator) {
        StringBuffer s = new StringBuffer();
        s.append(this.dimension);
        s.append(separator);
        s.append(Arrays.toString(this.center));
        s.append(separator);
        s.append(Arrays.toString(this.stretch));
        out.print(s);
    }

    public double[] getStretch() {
        return this.stretch;
    }

    private void calculateMaxDistance(double[] input) {
        int i;
        for (i = 0; i < this.dimension; ++i) {
            this.tmpArray[i] = input[i] - this.center[i];
            int n = i;
            this.tmpArray[n] = this.tmpArray[n] / this.stretch[i];
        }
        this.maxDistance = 0.0;
        for (i = 0; i < this.dimension; ++i) {
            double relativeDist = Math.abs(this.tmpArray[i]);
            if (!(relativeDist > this.maxDistance)) continue;
            this.maxDistance = relativeDist;
        }
    }
}

