/*
 * Decompiled with CFR 0.152.
 */
package xcsf.classifier;

import java.io.PrintStream;
import java.util.Arrays;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Condition;

public class ConditionEllipsoid
implements Condition {
    private static double[] tmpArray2;
    private int dimension;
    private double[] center;
    private double[] stretch;
    private double[] conditionInput;
    private double squareDistance;
    private double[] tmpArray1;

    public ConditionEllipsoid(double[] conditionInput) {
        this(conditionInput.length);
        int i;
        for (i = 0; i < this.dimension; ++i) {
            this.center[i] = conditionInput[i];
        }
        for (i = 0; i < this.dimension; ++i) {
            this.stretch[i] = XCSFConstants.minConditionStretch + XCSFUtils.Random.uniRand() * XCSFConstants.coverConditionRange;
        }
    }

    public ConditionEllipsoid(String[] args) {
        this(Integer.parseInt(args[0]));
        this.center = XCSFUtils.FileIO.parseDoubleArray(args[1]);
        this.stretch = XCSFUtils.FileIO.parseDoubleArray(args[2]);
    }

    private ConditionEllipsoid(int dimension) {
        this.dimension = dimension;
        this.tmpArray1 = new double[dimension];
        this.center = new double[dimension];
        this.stretch = new double[dimension];
        this.tmpArray1 = new double[dimension];
        if (tmpArray2 == null || tmpArray2.length != dimension) {
            tmpArray2 = new double[dimension];
        }
    }

    public boolean doesMatch(double[] input) {
        if (!XCSFUtils.arrayEquals(this.conditionInput, input)) {
            this.squareDistance = this.calculateRelativeSquaredDistance(input);
            this.conditionInput = input;
        }
        return this.squareDistance < 1.0;
    }

    public double getActivity(double[] input) {
        if (!XCSFUtils.arrayEquals(this.conditionInput, input)) {
            this.squareDistance = this.calculateRelativeSquaredDistance(input);
            this.conditionInput = input;
        }
        return Math.exp(-this.squareDistance);
    }

    public boolean isMoreGeneral(Condition otherCondition) {
        ConditionEllipsoid other = (ConditionEllipsoid)otherCondition;
        System.arraycopy(other.center, 0, tmpArray2, 0, this.dimension);
        for (int dim = 0; dim < this.dimension; ++dim) {
            if (this.center[dim] == other.center[dim] && this.stretch[dim] == other.stretch[dim]) continue;
            int n = dim;
            tmpArray2[n] = tmpArray2[n] + other.stretch[dim];
            if (this.calculateRelativeSquaredDistance(tmpArray2) > 1.0) {
                return false;
            }
            int n2 = dim;
            tmpArray2[n2] = tmpArray2[n2] - 2.0 * other.stretch[dim];
            if (this.calculateRelativeSquaredDistance(tmpArray2) > 1.0) {
                return false;
            }
            ConditionEllipsoid.tmpArray2[dim] = other.center[dim];
        }
        return true;
    }

    public void mutation() {
        double rnd;
        int i;
        double probability = XCSFConstants.pM / (double)(2 * this.dimension);
        for (i = 0; i < this.dimension; ++i) {
            if (!(XCSFUtils.Random.uniRand() < probability)) continue;
            rnd = 2.0 * XCSFUtils.Random.uniRand() - 1.0;
            int n = i;
            this.center[n] = this.center[n] + rnd * this.stretch[i];
            if (this.center[i] < 0.0) {
                this.center[i] = 0.0;
                continue;
            }
            if (!(this.center[i] > 1.0)) continue;
            this.center[i] = 1.0;
        }
        for (i = 0; i < this.dimension; ++i) {
            if (!(XCSFUtils.Random.uniRand() < probability)) continue;
            rnd = 1.0;
            rnd = XCSFUtils.Random.uniRand() < 0.5 ? (rnd += XCSFUtils.Random.uniRand()) : (rnd -= 0.5 * XCSFUtils.Random.uniRand());
            int n = i;
            this.stretch[n] = this.stretch[n] * rnd;
        }
    }

    public void crossover(Condition otherCondition) {
        ConditionEllipsoid other = (ConditionEllipsoid)otherCondition;
        if (XCSFUtils.Random.uniRand() < XCSFConstants.pX) {
            int i;
            for (i = 0; i < this.dimension; ++i) {
                if (!(XCSFUtils.Random.uniRand() < 0.5)) continue;
                XCSFUtils.flip(i, this.center, other.center);
            }
            for (i = 0; i < this.dimension; ++i) {
                if (!(XCSFUtils.Random.uniRand() < 0.5)) continue;
                XCSFUtils.flip(i, this.stretch, other.stretch);
            }
        }
    }

    public double getVolume() {
        double volume = Math.pow(2.0, this.dimension - 1) / (double)this.dimension * Math.PI;
        for (int i = 0; i < this.dimension; ++i) {
            volume *= this.stretch[i];
        }
        return volume;
    }

    public String toString() {
        return "condition{center" + Arrays.toString(this.center) + " stretch" + Arrays.toString(this.stretch) + "}";
    }

    public Condition reproduce() {
        ConditionEllipsoid clone = new ConditionEllipsoid(this.dimension);
        System.arraycopy(this.center, 0, clone.center, 0, this.dimension);
        System.arraycopy(this.stretch, 0, clone.stretch, 0, this.dimension);
        return clone;
    }

    public boolean equals(Condition otherCondition) {
        ConditionEllipsoid other = (ConditionEllipsoid)otherCondition;
        for (int i = 0; i < this.dimension; ++i) {
            if (this.center[i] == other.center[i] && this.stretch[i] == other.stretch[i]) continue;
            return false;
        }
        return true;
    }

    public double[] getCenter() {
        return this.center;
    }

    public void write(PrintStream out, CharSequence separator) {
        StringBuffer s = new StringBuffer();
        s.append(this.dimension);
        s.append(separator);
        s.append(Arrays.toString(this.center));
        s.append(separator);
        s.append(Arrays.toString(this.stretch));
        out.print(s);
    }

    public double[] getStretch() {
        return this.stretch;
    }

    private double calculateRelativeSquaredDistance(double[] point) {
        for (int i = 0; i < this.dimension; ++i) {
            this.tmpArray1[i] = point[i] - this.center[i];
            int n = i;
            this.tmpArray1[n] = this.tmpArray1[n] / this.stretch[i];
        }
        double dist = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            dist += this.tmpArray1[i] * this.tmpArray1[i];
        }
        return dist;
    }
}

