/*
 * Decompiled with CFR 0.152.
 */
package xcsf.classifier;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import xcsf.StateDescriptor;
import xcsf.XCSFConstants;
import xcsf.XCSFUtils;
import xcsf.classifier.Condition;
import xcsf.classifier.Prediction;

public class Classifier
implements Cloneable {
    private static Constructor<?> conditionCoverer;
    private static Constructor<?> predictionCoverer;
    private static Constructor<?> conditionParser;
    private static Constructor<?> predictionParser;
    private static double[] tmpCenterDifference;
    private Condition condition;
    private Prediction prediction;
    private double fitness;
    private int numerosity;
    private int experience;
    private double setSizeEstimate;
    private double predictionError;
    private int timestamp;

    public Classifier(StateDescriptor state, int timestamp) {
        this.fitness = XCSFConstants.fitnessIni;
        this.numerosity = 1;
        this.experience = 0;
        this.setSizeEstimate = 1.0;
        this.predictionError = XCSFConstants.predictionErrorIni;
        this.timestamp = timestamp;
        Classifier.init(state.getConditionInput().length);
        if (conditionCoverer == null) {
            conditionCoverer = XCSFUtils.loadConstructor(XCSFConstants.conditionType, Condition.class, Condition.CONSTRUCTOR_SIGNATURE);
            predictionCoverer = XCSFUtils.loadConstructor(XCSFConstants.predictionType, Prediction.class, Prediction.CONSTRUCTOR_SIGNATURE);
            if (conditionCoverer == null || predictionCoverer == null) {
                System.err.println("Failed to instantiate constructors for condition and/or prediction.");
                System.exit(0);
            }
        }
        try {
            this.condition = (Condition)conditionCoverer.newInstance(new Object[]{state.getConditionInput()});
            this.prediction = (Prediction)predictionCoverer.newInstance(state.getPredictionInput().length, state.getOutput());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Classifier() {
    }

    private static void init(int conditionInputLength) {
        if (tmpCenterDifference == null) {
            tmpCenterDifference = new double[conditionInputLength];
        } else if (tmpCenterDifference.length != conditionInputLength) {
            tmpCenterDifference = new double[conditionInputLength];
        }
    }

    public double getActivity(StateDescriptor state) {
        return this.condition.getActivity(state.getConditionInput());
    }

    public boolean doesMatch(StateDescriptor state) {
        return this.condition.doesMatch(state.getConditionInput());
    }

    public double[] predict(StateDescriptor state) {
        if (state.isSameInput()) {
            double[] input = state.getConditionInput();
            double[] center = this.condition.getCenter();
            for (int i = 0; i < input.length; ++i) {
                Classifier.tmpCenterDifference[i] = input[i] - center[i];
            }
            return this.prediction.predict(tmpCenterDifference);
        }
        return this.prediction.predict(state.getPredictionInput());
    }

    public void crossover(Classifier other) {
        double avgfitness;
        double avgPredictionError;
        this.predictionError = other.predictionError = (avgPredictionError = (this.predictionError + other.predictionError) / 2.0);
        this.fitness = other.fitness = (avgfitness = (this.fitness + other.fitness) / 2.0);
        this.prediction.crossover(other.prediction);
        this.condition.crossover(other.condition);
    }

    public void mutation() {
        this.condition.mutation();
    }

    public void update1(StateDescriptor state) {
        ++this.experience;
        if (state.isSameInput()) {
            double[] input = state.getConditionInput();
            double[] center = this.condition.getCenter();
            for (int i = 0; i < input.length; ++i) {
                Classifier.tmpCenterDifference[i] = input[i] - center[i];
            }
            this.prediction.update(tmpCenterDifference, state.getOutput());
        } else {
            this.prediction.update(state.getPredictionInput(), state.getOutput());
        }
        double absError = 0.0;
        double[] currentPrediction = this.predict(state);
        double[] actualValue = state.getOutput();
        for (int i = 0; i < currentPrediction.length; ++i) {
            absError += Math.abs(currentPrediction[i] - actualValue[i]);
        }
        double max = 1.0 / (double)this.experience;
        if (XCSFConstants.beta > max) {
            max = XCSFConstants.beta;
        }
        this.predictionError += max * (absError - this.predictionError);
    }

    public void update2(double accuracySum, int numerositySum) {
        double learningRate = 1.0 / (double)this.experience;
        if (XCSFConstants.beta > learningRate) {
            learningRate = XCSFConstants.beta;
        }
        this.setSizeEstimate += learningRate * ((double)numerositySum - this.setSizeEstimate);
        this.fitness += XCSFConstants.beta * (this.getAccuracy() * (double)this.numerosity / accuracySum - this.fitness);
    }

    public Classifier reproduce() {
        Classifier clone = new Classifier();
        clone.condition = this.condition.reproduce();
        clone.prediction = this.prediction.reproduce();
        clone.setSizeEstimate = this.setSizeEstimate;
        clone.predictionError = this.predictionError * XCSFConstants.predictionErrorReduction;
        clone.timestamp = this.timestamp;
        clone.fitness = this.fitness / (double)this.numerosity * XCSFConstants.fitnessReduction;
        clone.numerosity = 1;
        clone.experience = 0;
        return clone;
    }

    public double getDeletionVote(double meanFitness) {
        double microfitness = this.fitness / (double)this.numerosity;
        if (microfitness >= XCSFConstants.delta * meanFitness || this.experience < XCSFConstants.theta_del) {
            return this.setSizeEstimate * (double)this.numerosity;
        }
        return this.setSizeEstimate * (double)this.numerosity * meanFitness / microfitness;
    }

    public double getAccuracy() {
        if (this.predictionError <= XCSFConstants.epsilon_0) {
            return 1.0;
        }
        return XCSFConstants.alpha * Math.pow(XCSFConstants.epsilon_0 / this.predictionError, XCSFConstants.nu);
    }

    public boolean canSubsume() {
        return this.experience > XCSFConstants.theta_sub && this.predictionError < XCSFConstants.epsilon_0;
    }

    public boolean isMoreGeneral(Classifier other) {
        return this.condition.isMoreGeneral(other.condition);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Prediction getPrediction() {
        return this.prediction;
    }

    public double getFitness() {
        return this.fitness;
    }

    public double getPredictionError() {
        return this.predictionError;
    }

    public double getGenerality() {
        return this.condition.getVolume();
    }

    public int getNumerosity() {
        return this.numerosity;
    }

    public void addNumerosity(int val) {
        this.numerosity += val;
    }

    public int getExperience() {
        return this.experience;
    }

    public double getSetSizeEstimate() {
        return this.setSizeEstimate;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return "cl{fit=" + this.fitness + ",num=" + this.numerosity + ",exp=" + this.experience + ",setSizeEst=" + this.setSizeEstimate + " " + this.condition.toString() + " " + this.prediction.toString() + "}";
    }

    public void write(PrintStream ps, CharSequence separator1, CharSequence separator2) {
        StringBuffer s = new StringBuffer();
        s.append(this.fitness);
        s.append(separator1);
        s.append(this.numerosity);
        s.append(separator1);
        s.append(this.experience);
        s.append(separator1);
        s.append(this.setSizeEstimate);
        s.append(separator1);
        s.append(this.timestamp);
        s.append(separator1);
        s.append(this.predictionError);
        ps.print(s.toString());
        ps.print(separator1);
        ps.print(this.condition.getClass().getName() + separator1);
        this.condition.write(ps, separator2);
        ps.print(separator1);
        ps.print(this.prediction.getClass().getName() + separator1);
        this.prediction.write(ps, separator2);
    }

    public static Classifier parse(String s, String splitRegex1, String splitRegex2) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String[] splited = s.split(splitRegex1);
        Classifier cl = new Classifier();
        int i = 0;
        cl.fitness = Double.parseDouble(splited[i++]);
        cl.numerosity = Integer.parseInt(splited[i++]);
        cl.experience = Integer.parseInt(splited[i++]);
        cl.setSizeEstimate = Double.parseDouble(splited[i++]);
        cl.timestamp = Integer.parseInt(splited[i++]);
        cl.predictionError = Double.parseDouble(splited[i++]);
        String conditionClass = splited[i++];
        if (conditionParser == null || !conditionClass.equals(conditionParser.getDeclaringClass().getName())) {
            conditionParser = XCSFUtils.loadConstructor(conditionClass, Condition.class, Condition.CONSTRUCTOR_PARSER_SIGNATURE);
        }
        Object[] args = new Object[]{splited[i++].split(splitRegex2)};
        cl.condition = (Condition)conditionParser.newInstance(args);
        String predictionClass = splited[i++];
        if (predictionParser == null || !predictionClass.equals(predictionParser.getDeclaringClass().getName())) {
            predictionParser = XCSFUtils.loadConstructor(predictionClass, Prediction.class, Prediction.CONSTRUCTOR_PARSER_SIGNATURE);
        }
        args[0] = splited[i++].split(splitRegex2);
        cl.prediction = (Prediction)predictionParser.newInstance(args);
        Classifier.init(cl.condition.getCenter().length);
        return cl;
    }
}

